/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.type;

import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.core.enums.RelationTypeMultiplicity;
import org.eclipse.osee.framework.core.model.cache.IOseeTypeFactory;
import org.eclipse.osee.framework.core.model.cache.RelationTypeCache;
import org.eclipse.osee.framework.core.model.type.RelationType;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class RelationTypeFactory
implements IOseeTypeFactory {
    public RelationType create(Long guid, String name, String sideAName, String sideBName, ArtifactTypeToken artifactTypeSideA, ArtifactTypeToken artifactTypeSideB, RelationTypeMultiplicity multiplicity, RelationSorter defaultRelationSorter) {
        Conditions.checkNotNullOrEmpty((String)name, (String)"relation type name");
        Conditions.checkNotNullOrEmpty((String)sideAName, (String)"side A name");
        Conditions.checkNotNullOrEmpty((String)sideBName, (String)"side B name");
        Conditions.checkNotNull((Object)artifactTypeSideA, (String)"artifact type A");
        Conditions.checkNotNull((Object)artifactTypeSideB, (String)"relation type B");
        Conditions.checkNotNull((Object)multiplicity, (String)"multiplicity");
        return new RelationType(guid, name, sideAName, sideBName, artifactTypeSideA, artifactTypeSideB, multiplicity, defaultRelationSorter);
    }

    public RelationType createOrUpdate(RelationTypeCache cache, Long guid, String typeName, String sideAName, String sideBName, ArtifactTypeToken artifactTypeSideA, ArtifactTypeToken artifactTypeSideB, RelationTypeMultiplicity multiplicity, RelationSorter defaultRelationSorter) {
        Conditions.checkNotNull((Object)cache, (String)"RelationTypeCache");
        RelationType relationType = (RelationType)cache.getByGuid(guid);
        if (relationType == null) {
            relationType = this.create(guid, typeName, sideAName, sideBName, artifactTypeSideA, artifactTypeSideB, multiplicity, defaultRelationSorter);
            cache.cache(relationType);
        } else {
            relationType.setFields(typeName, sideAName, sideBName, artifactTypeSideA, artifactTypeSideB, multiplicity, defaultRelationSorter);
        }
        return relationType;
    }
}

