/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.access;

import java.util.ArrayList;
import java.util.List;

public class Scope
implements Cloneable {
    private static final String LEGACY_SCOPE = "##";
    private static final String ARTIFACT_LOCK_SCOPE = "##**";
    private final List<String> scopePath = new ArrayList<String>();

    public int getScopeDepth() {
        return this.scopePath.size();
    }

    public Scope add(String value) {
        this.scopePath.add(this.normalize(value));
        return this;
    }

    public String getPath() {
        StringBuilder builder = new StringBuilder();
        for (String entry : this.scopePath) {
            if (!entry.startsWith("#")) {
                builder.append("/");
            }
            builder.append(entry);
        }
        return builder.toString();
    }

    private String normalize(String value) {
        return value.replaceAll(" ", "_");
    }

    public Scope addSubPath(String value) {
        this.scopePath.add("#" + this.normalize(value));
        return this;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.scopePath == null ? 0 : this.scopePath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Scope other = (Scope)obj;
        return !(this.scopePath == null ? other.scopePath != null : !this.scopePath.equals(other.scopePath));
    }

    public boolean isLegacy() {
        return this instanceof LegacyScope;
    }

    public String toString() {
        return this.getPath();
    }

    public Scope clone() {
        Scope scope = new Scope();
        for (String value : this.scopePath) {
            scope.add(value);
        }
        return scope;
    }

    public static Scope createLegacyScope() {
        return new LegacyScope();
    }

    public static Scope createArtifactLockScope() {
        return new ArtifactLockScope();
    }

    private static final class ArtifactLockScope
    extends NonCmScope {
        private ArtifactLockScope() {
        }

        @Override
        public String getPath() {
            return Scope.ARTIFACT_LOCK_SCOPE;
        }

        @Override
        public Scope clone() {
            return Scope.createArtifactLockScope();
        }
    }

    private static final class LegacyScope
    extends NonCmScope {
        private LegacyScope() {
        }

        @Override
        public String getPath() {
            return Scope.LEGACY_SCOPE;
        }

        @Override
        public Scope clone() {
            return Scope.createLegacyScope();
        }
    }

    private static abstract class NonCmScope
    extends Scope {
        private NonCmScope() {
        }

        @Override
        public Scope add(String path) {
            return this;
        }

        @Override
        public Scope addSubPath(String path) {
            return this;
        }
    }
}

