/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc.internal.osgi;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcConstants;
import org.eclipse.osee.jdbc.JdbcException;
import org.eclipse.osee.jdbc.internal.osgi.JdbcServiceConfig;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JdbcServiceConfigParser {
    public Map<String, JdbcServiceConfig> parse(String source) {
        LinkedHashMap<String, JdbcServiceConfig> toReturn = new LinkedHashMap<String, JdbcServiceConfig>();
        if (Strings.isValid((String)source)) {
            try {
                HashSet<String> allBindings = new HashSet<String>();
                JSONArray array = new JSONArray(source);
                int index = 0;
                while (index < array.length()) {
                    JSONObject object = array.getJSONObject(index);
                    JdbcServiceConfig newConfig = this.asConfig(object);
                    if (!newConfig.isEmpty()) {
                        this.checkBinding(newConfig, allBindings);
                        this.checkId(newConfig);
                        JdbcServiceConfig oldConfig = toReturn.put(newConfig.getId(), newConfig);
                        this.checkUnique(oldConfig, newConfig);
                    }
                    ++index;
                }
            }
            catch (JSONException ex) {
                throw JdbcException.newJdbcException(ex, "Error parsing jdbc config [%s]", source);
            }
        }
        return toReturn;
    }

    private JdbcServiceConfig asConfig(JSONObject object) throws JSONException {
        String[] names;
        JdbcServiceConfig toReturn = new JdbcServiceConfig();
        String[] stringArray = names = JSONObject.getNames((JSONObject)object);
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            Set<String> value = object.get(key);
            if (value instanceof JSONArray) {
                value = this.asSet(key, (JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = this.asDictionary((JSONObject)value);
            }
            toReturn.put(key, value);
            ++n2;
        }
        return toReturn;
    }

    private Dictionary<String, Object> asDictionary(JSONObject object) throws JSONException {
        String[] names;
        Hashtable<String, Object> toReturn = new Hashtable<String, Object>();
        String[] stringArray = names = JSONObject.getNames((JSONObject)object);
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            Set<String> value = object.get(key);
            if (value instanceof JSONArray) {
                value = this.asSet(key, (JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = this.asDictionary((JSONObject)value);
            }
            ((Dictionary)toReturn).put(key, value);
            ++n2;
        }
        return toReturn;
    }

    private Set<String> asSet(String key, JSONArray array) throws JSONException {
        TreeSet<String> toReturn = new TreeSet<String>();
        int index = 0;
        while (index < array.length()) {
            String name = array.getString(index);
            if (Strings.isValid((String)name)) {
                toReturn.add(name);
            }
            ++index;
        }
        return toReturn;
    }

    private void checkId(JdbcServiceConfig config) {
        String id = config.getId();
        if (!Strings.isValid((String)id)) {
            throw this.newError("id cannot be null or empty - config[%s]", config);
        }
    }

    private void checkUnique(JdbcServiceConfig oldConfig, JdbcServiceConfig newConfig) {
        if (oldConfig != null) {
            throw this.newError("duplicate service id detected - id[%s]", newConfig.getId());
        }
    }

    private void checkBinding(JdbcServiceConfig config, Set<String> allBindings) {
        if (!config.hasBindings()) {
            throw this.newError("[%s] - was not defined for [%s]", "osgi.binding", config);
        }
        for (String binding : config.getBindings()) {
            boolean wasAdded = allBindings.add(binding);
            if (wasAdded) continue;
            throw this.newError("binding [%s] should not be referenced multiple times betweeen [%s] configurations. Ensure [%s] contains unique bindings.", binding, JdbcConstants.JDBC_SERVICE__CONFIGS, "osgi.binding");
        }
    }

    private RuntimeException newError(String msg, Object ... args) {
        return JdbcException.newJdbcException("Jdbc Service configuration error - " + msg, args);
    }
}

