/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.data;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.exception.AttributeDoesNotExist;
import org.eclipse.osee.framework.core.exception.MultipleAttributesExist;
import org.eclipse.osee.framework.jdk.core.type.BaseId;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSetList;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.ArtifactTypes;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.data.RelationReadable;
import org.eclipse.osee.orcs.search.QueryFactory;

public final class ArtifactReadableImpl
extends BaseId
implements ArtifactReadable {
    private final HashCollection<AttributeTypeToken, Object> attributes = new HashCollection();
    private final HashCollection<RelationTypeToken, ArtifactReadable> relationsSideA = new HashCollection();
    private final HashCollection<RelationTypeToken, ArtifactReadable> relationsSideB = new HashCollection();
    private final ArtifactTypeToken artifactType;
    private final BranchId branch;
    private final ArtifactId view;
    private final QueryFactory queryFactory;
    private final ApplicabilityId applicability;
    private final ArtifactTypes artifactTypes;
    private final TransactionId txId;
    private final ModificationType modType;

    public ArtifactReadableImpl(Long id, ArtifactTypeToken artifactType, BranchId branch, ArtifactId view, ApplicabilityId applicability, TransactionId txId, ModificationType modType, QueryFactory queryFactory, ArtifactTypes artifactTypes) {
        super(id);
        this.artifactType = artifactType;
        this.branch = branch;
        this.view = view;
        this.applicability = applicability;
        this.txId = txId;
        this.modType = modType;
        this.queryFactory = queryFactory;
        this.artifactTypes = artifactTypes;
    }

    public String getName() {
        if (this.attributes.isEmpty()) {
            return "Name not loaded";
        }
        return (String)this.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Name);
    }

    public BranchId getBranch() {
        return this.branch;
    }

    @Override
    public TransactionId getTransaction() {
        return this.txId;
    }

    @Override
    public ModificationType getModificationType() {
        return this.modType;
    }

    public ArtifactTypeToken getArtifactType() {
        return this.artifactType;
    }

    @Override
    public TransactionId getLastModifiedTransaction() {
        return TransactionId.SENTINEL;
    }

    @Override
    public boolean isOfType(ArtifactTypeId ... otherTypes) {
        return this.artifactTypes.inheritsFrom((ArtifactTypeId)this.artifactType, otherTypes);
    }

    @Override
    public int getAttributeCount(AttributeTypeToken type) {
        return this.attributes.sizeByKey((Object)type);
    }

    @Override
    public int getAttributeCount(AttributeTypeToken type, DeletionFlag deletionFlag) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAttributeTypeValid(AttributeTypeToken attributeType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<AttributeTypeToken> getValidAttributeTypes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<AttributeTypeToken> getExistingAttributeTypes() {
        return this.attributes.keySet();
    }

    @Override
    public <T> T getSoleAttributeValue(AttributeTypeToken attributeType) {
        List<T> values = this.getAttributeValues(attributeType);
        this.ensureSole(attributeType, values);
        return values.iterator().next();
    }

    private void ensureSole(AttributeTypeToken attributeType, Collection<?> values) {
        if (values == null || values.size() < 1) {
            throw new AttributeDoesNotExist("Attribute of type [%s] could not be found on [%s]", new Object[]{attributeType, this.getIdString()});
        }
        this.ensureNotMoreThanOne(attributeType, values.size());
    }

    private void ensureNotMoreThanOne(AttributeTypeToken attributeType, int size) {
        if (size > 1) {
            throw new MultipleAttributesExist("[%s] attributes of type [%s] on [%s], but only 1 instance is allowed", new Object[]{attributeType, size, this.getIdString()});
        }
    }

    @Override
    public <T> T getSoleAttributeValue(AttributeTypeToken attributeType, DeletionFlag flag, T defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getSoleAttributeValue(AttributeTypeToken attributeType, T defaultValue) {
        List<T> values = this.getAttributeValues(attributeType);
        if (values == null) {
            return defaultValue;
        }
        this.ensureNotMoreThanOne(attributeType, values.size());
        if (values.size() == 1) {
            T value = values.iterator().next();
            return value == null ? defaultValue : value;
        }
        return defaultValue;
    }

    @Override
    public String getSoleAttributeAsString(AttributeTypeToken attributeType) {
        return this.getSoleAttributeValue(attributeType).toString();
    }

    @Override
    public String getSoleAttributeAsString(AttributeTypeToken attributeType, String defaultValue) {
        Object value = this.getSoleAttributeValue(attributeType, null);
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    @Override
    public Long getSoleAttributeId(AttributeTypeToken attributeType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<T> getAttributeValues(AttributeTypeToken attributeType) {
        if (this.attributes.isEmpty()) {
            throw new OseeStateException("attributes not loaded for artifact [%s]", new Object[]{this.getIdString()});
        }
        return (List)this.attributes.getValues((Object)attributeType);
    }

    public void putAttributeValue(AttributeTypeToken attributeType, Object value) {
        this.attributes.put((Object)attributeType, value);
    }

    public void putRelation(RelationTypeToken relationType, RelationSide side, ArtifactReadable artifact) {
        (side.isSideA() ? this.relationsSideA : this.relationsSideB).put((Object)relationType, (Object)artifact);
    }

    @Override
    public Iterable<Collection<? extends AttributeReadable<Object>>> getAttributeIterable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AttributeReadable<Object> getAttributeById(AttributeId attributeId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet<? extends AttributeReadable<Object>> getAttributes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> ResultSet<? extends AttributeReadable<T>> getAttributes(AttributeTypeId attributeType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet<? extends AttributeReadable<Object>> getAttributes(DeletionFlag deletionFlag) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> ResultSet<? extends AttributeReadable<T>> getAttributes(AttributeTypeToken attributeType, DeletionFlag deletionFlag) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaximumRelationAllowed(RelationTypeSide relationTypeSide) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<RelationTypeId> getValidRelationTypes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<RelationTypeId> getExistingRelationTypes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ArtifactReadable> getDescendants() {
        return this.queryFactory.fromBranch(this.branch, this.view).andRelatedRecursive(CoreRelationTypes.Default_Hierarchical__Child, (ArtifactId)this).asArtifacts();
    }

    @Override
    public void getDescendants(List<ArtifactReadable> descendants) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDescendantOf(ArtifactToken parent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ArtifactReadable> getChildren() {
        return this.getRelated(CoreRelationTypes.Default_Hierarchical__Child, ArtifactTypeId.SENTINEL);
    }

    @Override
    public ResultSet<ArtifactReadable> getRelated(RelationTypeSide relationTypeSide) {
        return new ResultSetList(this.getRelated(relationTypeSide, ArtifactTypeId.SENTINEL));
    }

    @Override
    public List<ArtifactReadable> getRelated(RelationTypeSide relationTypeSide, ArtifactTypeId artifactType) {
        return this.getRelated(relationTypeSide, artifactType, DeletionFlag.EXCLUDE_DELETED);
    }

    @Override
    public List<ArtifactReadable> getRelated(RelationTypeSide relationTypeSide, ArtifactTypeId artifactType, DeletionFlag deletionFlag) {
        List related = (List)(relationTypeSide.getSide().isSideA() ? this.relationsSideA : this.relationsSideB).getValues((Object)relationTypeSide.getRelationType());
        if (related == null) {
            return Collections.emptyList();
        }
        Predicate<ArtifactReadable> filter = artifact -> this.modType.isIncluded(deletionFlag) && (artifactType.isInvalid() || this.artifactTypes.inheritsFrom((ArtifactTypeId)artifact.getArtifactType(), artifactType));
        if (artifactType.isValid() || deletionFlag.equals((Object)DeletionFlag.EXCLUDE_DELETED)) {
            return related.stream().filter(filter).collect(Collectors.toList());
        }
        return related;
    }

    @Override
    public List<ArtifactReadable> getRelated(RelationTypeSide relationTypeSide, DeletionFlag deletionFlag) {
        return this.getRelated(relationTypeSide, ArtifactTypeId.SENTINEL, deletionFlag);
    }

    @Override
    public boolean areRelated(RelationTypeSide typeAndSide, ArtifactReadable artifact) {
        return this.getRelated(typeAndSide, ArtifactTypeId.SENTINEL).contains(artifact);
    }

    @Override
    public int getRelatedCount(RelationTypeSide typeAndSide) {
        return this.getRelated(typeAndSide, ArtifactTypeId.SENTINEL).size();
    }

    @Override
    public String getRationale(RelationTypeSide typeAndSide, ArtifactReadable readable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet<RelationReadable> getRelations(RelationTypeSide relationTypeSide) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Long> getChildrentIds() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Long> getRelatedIds(RelationTypeSide relationTypeSide) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isHistorical() {
        return false;
    }

    @Override
    public ApplicabilityId getApplicability() {
        return this.applicability;
    }

    @Override
    public String getSafeName() {
        return this.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Name, DeletionFlag.INCLUDE_DELETED, "Unknown Name: " + this.getIdString());
    }
}

