/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.define.api.ArtifactUrlServer;
import org.eclipse.osee.define.api.AttributeElement;
import org.eclipse.osee.define.api.MetadataElement;
import org.eclipse.osee.define.api.OseeLinkBuilder;
import org.eclipse.osee.define.api.PublishingOptions;
import org.eclipse.osee.define.api.WordTemplateContentData;
import org.eclipse.osee.define.rest.DataRightsOperationsImpl;
import org.eclipse.osee.define.rest.internal.wordupdate.WordTemplateContentRendererHandler;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.OseeSessionGrant;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DataRightsClassification;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.model.datarights.DataRightResult;
import org.eclipse.osee.framework.core.model.type.LinkType;
import org.eclipse.osee.framework.core.util.PageOrientation;
import org.eclipse.osee.framework.core.util.WordMLProducer;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.xml.Xml;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WordTemplateProcessor {
    private static final String LOAD_EXCLUDED_ARTIFACTIDS = "select art_id from osee_artifact art, osee_txs txs where art.gamma_id = txs.gamma_id and txs.branch_id = ? and txs.tx_current = 1 and not exists (select null from osee_tuple2 t2, osee_txs txsP where tuple_type = 2 and e1 = ? and t2.gamma_id = txsP.gamma_id and txsP.branch_id = ? and txsP.tx_current = 1 and e2 = txs.app_id)";
    protected static final String ARTIFACT = "Artifact";
    private static final String ARTIFACT_TYPE = "Artifact Type";
    private static final Object ARTIFACT_ID = "Artifact Id";
    private static final String APPLICABILITY = "Applicability";
    private static final String INSERT_LINK = "INSERT_LINK_HERE";
    private static final String INSERT_ARTIFACT_HERE = "INSERT_ARTIFACT_HERE";
    protected static final String NESTED_TEMPLATE = "NestedTemplate";
    public static final String PGNUMTYPE_START_1 = "<w:pgNumType [^>]*w:start=\"1\"/>";
    public static final String STYLES = "<w:lists>.*?</w:lists><w:styles>.*?</w:styles>";
    private final String newLineChar = System.getProperty("line.separator");
    protected static final Pattern headElementsPattern = Pattern.compile("(INSERT_ARTIFACT_HERE)|INSERT_LINK_HERE", 42);
    private String slaveTemplate;
    private String slaveTemplateOptions;
    private String slaveTemplateStyles;
    protected String elementType;
    private DataRightsClassification overrideClassification;
    private BranchId branch;
    protected AttributeTypeId headingAttributeType;
    protected boolean outlining;
    protected boolean recurseChildren;
    protected String outlineNumber;
    private String attributeLabel;
    private String attributeType;
    private String formatPre;
    private String formatPost;
    private String metadataType;
    private String metadataLabel;
    private String metadataFormat;
    private String outlineType;
    private String sectionNumber;
    private String subDocName;
    private String key;
    private String value;
    private int nestedCount;
    protected final List<AttributeElement> attributeElements = new LinkedList<AttributeElement>();
    protected final List<MetadataElement> metadataElements = new LinkedList<MetadataElement>();
    protected final List<ArtifactReadable> nonTemplateArtifacts = new LinkedList<ArtifactReadable>();
    protected final Set<ArtifactReadable> processedArtifacts = new HashSet<ArtifactReadable>();
    protected PublishingOptions publishingOptions = new PublishingOptions();
    private boolean isDiff;
    protected boolean excludeFolders;
    protected CharSequence paragraphNumber = null;
    protected final List<ArtifactTypeToken> excludeArtifactTypes = new LinkedList<ArtifactTypeToken>();
    private HashMap<ApplicabilityId, ApplicabilityToken> applicabilityTokens;
    private final HashMap<ArtifactId, ArtifactId> artifactsToExclude;
    private final Set<ArtifactId> emptyFolders = new HashSet<ArtifactId>();
    private final Log logger;
    private final OrcsApi orcsApi;

    public WordTemplateProcessor(PublishingOptions publishingOptions, Log logger, OrcsApi orcsApi) {
        this.publishingOptions = publishingOptions;
        this.logger = logger;
        this.orcsApi = orcsApi;
        this.artifactsToExclude = new HashMap();
    }

    public String publishWithNestedTemplates(ArtifactId masterTemplateArtId, ArtifactId slaveTemplateArtId, ArtifactId headArtifact) {
        String attributeName;
        Object masterTemplateArtifact = null;
        ArtifactReadable slaveTemplateArtifact = null;
        LinkedList<ArtifactReadable> artifacts = new LinkedList<ArtifactReadable>();
        masterTemplateArtifact = masterTemplateArtId != ArtifactId.SENTINEL ? this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId(masterTemplateArtId).getArtifact() : ArtifactReadable.SENTINEL;
        if (slaveTemplateArtId != ArtifactId.SENTINEL) {
            slaveTemplateArtifact = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId(slaveTemplateArtId).getArtifact();
        }
        if (headArtifact != null) {
            ArtifactReadable art = this.orcsApi.getQueryFactory().fromBranch(this.publishingOptions.branch).andId(headArtifact).getArtifact();
            artifacts.add(art);
        }
        this.nestedCount = 0;
        String masterTemplate = (String)masterTemplateArtifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.WholeWordContent, (Object)"");
        String masterTemplateOptions = (String)masterTemplateArtifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.RendererOptions, (Object)"");
        this.slaveTemplate = "";
        this.slaveTemplateOptions = "";
        this.isDiff = this.publishingOptions.publishDiff;
        this.publishingOptions.templateArtifact = masterTemplateArtifact;
        this.slaveTemplateStyles = "";
        if (slaveTemplateArtifact != null) {
            this.publishingOptions.templateArtifact = slaveTemplateArtifact;
            this.slaveTemplate = (String)slaveTemplateArtifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.WholeWordContent, (Object)"");
            this.slaveTemplateOptions = slaveTemplateArtifact.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.RendererOptions, "");
            ResultSet slaveTemplateRelatedArtifacts = slaveTemplateArtifact.getRelated(CoreRelationTypes.SupportingInfo_SupportingInfo);
            if (slaveTemplateRelatedArtifacts.size() == 1) {
                this.slaveTemplateStyles = String.valueOf(this.slaveTemplateStyles) + ((ArtifactReadable)slaveTemplateRelatedArtifacts.getExactlyOne()).getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.WholeWordContent, "");
            } else {
                this.logger.info("More than one style relation currently not supported. Defaulting to styles defined in the template.", new Object[0]);
            }
        }
        try {
            this.attributeElements.clear();
            this.metadataElements.clear();
            JSONObject jsonObject = new JSONObject(masterTemplateOptions);
            this.elementType = jsonObject.getString("ElementType");
            if (this.elementType.equals(ARTIFACT)) {
                this.parseAttributeOptions(masterTemplateOptions);
                this.parseMetadataOptions(masterTemplateOptions);
            }
        }
        catch (JSONException ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
        this.publishingOptions.allAttributes = false;
        if (this.attributeElements.size() == 1 && (attributeName = this.attributeElements.get(0).getAttributeName()).equals("*")) {
            this.publishingOptions.allAttributes = true;
        }
        List masterTemplateRelatedArtifacts = masterTemplateArtifact.getRelated(CoreRelationTypes.SupportingInfo_SupportingInfo).getList();
        String masterTemplateStyles = "";
        if (masterTemplateRelatedArtifacts.size() == 1) {
            masterTemplateStyles = String.valueOf(masterTemplateStyles) + ((ArtifactReadable)masterTemplateRelatedArtifacts.get(0)).getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.WholeWordContent, "");
        } else {
            this.logger.info("More than one style relation currently not supported. Defaulting to styles defined in the template.", new Object[0]);
        }
        this.getExcludeArtifactTypes();
        if (!this.publishingOptions.publishEmptyHeaders) {
            this.isEmptyHeaders(artifacts);
        }
        StringBuilder wordMlOutput = this.applyTemplate(artifacts, masterTemplate, masterTemplateOptions, masterTemplateStyles, null, null, PresentationType.PREVIEW);
        return wordMlOutput.toString();
    }

    public boolean isEmptyHeaders(List<ArtifactReadable> artifacts) {
        boolean hasIncludedChildren = false;
        boolean includeParent = false;
        List children = null;
        for (ArtifactReadable artifact : artifacts) {
            children = artifact.getChildren();
            if (!children.isEmpty()) {
                hasIncludedChildren = this.isEmptyHeaders(children);
                if (!hasIncludedChildren && artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.HeadingMsWord})) {
                    this.emptyFolders.add((ArtifactId)artifact);
                }
            } else if (children.isEmpty() && artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.HeadingMsWord})) {
                this.emptyFolders.add((ArtifactId)artifact);
            }
            if (!this.isOfType(artifact, this.excludeArtifactTypes) && !artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.HeadingMsWord})) {
                includeParent = true;
            }
            if (!hasIncludedChildren) continue;
            includeParent = true;
        }
        return includeParent;
    }

    protected List<ArtifactTypeToken> getExcludeArtifactTypes() {
        this.excludeArtifactTypes.clear();
        if (this.publishingOptions.excludeArtifactTypes != null) {
            for (ArtifactTypeToken artToken : this.publishingOptions.excludeArtifactTypes) {
                this.excludeArtifactTypes.add(artToken);
            }
        }
        return this.excludeArtifactTypes;
    }

    public StringBuilder applyTemplate(List<ArtifactReadable> artifacts, String templateContent, String templateOptions, String templateStyles, String outlineNumber, String outlineType, PresentationType presentationType) {
        String overrideDataRights = this.publishingOptions.overrideDataRights;
        this.overrideClassification = DataRightsClassification.noOverride;
        DataRightsClassification[] dataRightsClassificationArray = DataRightsClassification.values();
        int n = dataRightsClassificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataRightsClassification classification = dataRightsClassificationArray[n2];
            if (classification.getDataRightsClassification().equals(overrideDataRights)) {
                this.overrideClassification = classification;
            }
            ++n2;
        }
        this.excludeFolders = this.publishingOptions.excludeFolders;
        if (artifacts.isEmpty()) {
            this.branch = BranchId.SENTINEL;
        } else {
            BranchId fullBranch = this.branch = artifacts.get(0).getBranch();
            BranchQuery branchQuery = (BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(fullBranch);
            BranchType branchType = ((Branch)branchQuery.getResults().getExactlyOne()).getBranchType();
            if (branchType.equals((Object)BranchType.MERGE)) {
                fullBranch = ((Branch)branchQuery.getResults().getExactlyOne()).getParentBranch();
            }
            this.applicabilityTokens = new HashMap();
            Collection appTokens = this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityTokens(fullBranch).values();
            for (ApplicabilityToken token : appTokens) {
                this.applicabilityTokens.put((ApplicabilityId)token, token);
            }
        }
        WordMLProducer wordMl = null;
        StringBuilder strBuilder = null;
        try {
            strBuilder = new StringBuilder();
            wordMl = new WordMLProducer((Appendable)strBuilder);
            templateContent = templateContent.replaceAll(PGNUMTYPE_START_1, "");
            if (!templateStyles.isEmpty()) {
                templateContent = templateContent.replaceAll(STYLES, templateStyles);
            }
            this.outlineNumber = outlineNumber == null ? this.peekAtFirstArtifactToGetParagraphNumber(templateContent, null, artifacts) : outlineNumber;
            templateContent = wordMl.setHeadingNumbers(this.outlineNumber, templateContent, outlineType);
            Matcher matcher = headElementsPattern.matcher(templateContent);
            int lastEndIndex = 0;
            while (matcher.find()) {
                wordMl.addWordMl((CharSequence)templateContent.substring(lastEndIndex, matcher.start()));
                lastEndIndex = matcher.end();
                JSONObject jsonObject = new JSONObject(templateOptions);
                this.elementType = jsonObject.getString("ElementType");
                if (this.elementType.equals(ARTIFACT)) {
                    this.parseOutliningOptions(templateOptions);
                    if (presentationType == PresentationType.SPECIALIZED_EDIT && artifacts.size() == 1) {
                        this.outlining = false;
                    }
                    this.processArtifactSet(templateOptions, artifacts, wordMl, outlineType, presentationType, this.publishingOptions.view);
                    continue;
                }
                if (this.elementType.equals(NESTED_TEMPLATE)) continue;
                throw new OseeArgumentException("Invalid input [%s]", new Object[]{""});
            }
            String endOfTemplate = templateContent.substring(lastEndIndex);
            wordMl.addWordMl((CharSequence)this.updateFooter(endOfTemplate));
            this.displayNonTemplateArtifacts(this.nonTemplateArtifacts, "Only artifacts of type Word Template Content are supported in this case.");
        }
        catch (JSONException ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
        return strBuilder;
    }

    protected void parseAttributeOptions(String templateOptions) {
        try {
            this.attributeElements.clear();
            JSONObject jsonObject = new JSONObject(templateOptions);
            JSONArray attributeOptions = jsonObject.getJSONArray("AttributeOptions");
            JSONObject options = null;
            int i = 0;
            while (i < attributeOptions.length()) {
                options = attributeOptions.getJSONObject(i);
                this.attributeType = options.getString("AttrType");
                this.attributeLabel = options.getString("Label");
                this.formatPre = options.getString("FormatPre");
                this.formatPost = options.getString("FormatPost");
                AttributeElement attrElement = new AttributeElement();
                boolean typeExists = this.orcsApi.getOrcsTypes().getAttributeTypes().typeExists(this.attributeType);
                if (this.attributeType.equals("*") || typeExists) {
                    attrElement.setElements(this.attributeType, this.attributeLabel, this.formatPre, this.formatPost);
                    this.attributeElements.add(attrElement);
                }
                ++i;
            }
        }
        catch (JSONException ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }

    protected void parseOutliningOptions(String templateOptions) {
        try {
            JSONObject jsonObject = new JSONObject(templateOptions);
            JSONArray optionsArray = jsonObject.getJSONArray("OutliningOptions");
            JSONObject options = optionsArray.getJSONObject(0);
            this.outlining = options.getBoolean("Outlining");
            this.recurseChildren = options.getBoolean("RecurseChildren");
            String headingAttrType = options.getString("HeadingAttributeType");
            this.headingAttributeType = this.orcsApi.getOrcsTypes().getAttributeTypes().getByName(headingAttrType);
        }
        catch (JSONException ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }

    protected void parseMetadataOptions(String metadataOptions) {
        try {
            JSONObject jsonObject = new JSONObject(metadataOptions);
            JSONObject options = null;
            if (!jsonObject.has("MetadataOptions")) {
                return;
            }
            JSONArray optionsArray = jsonObject.getJSONArray("MetadataOptions");
            int i = 0;
            while (i < optionsArray.length()) {
                options = optionsArray.getJSONObject(i);
                this.metadataType = options.getString("Type");
                this.metadataFormat = options.getString("Format");
                this.metadataLabel = options.getString("Label");
                MetadataElement metadataElement = new MetadataElement();
                metadataElement.setElements(this.metadataType, this.metadataFormat, this.metadataLabel);
                this.metadataElements.add(metadataElement);
                ++i;
            }
        }
        catch (JSONException ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }

    protected String updateFooter(String endOfTemplate) {
        endOfTemplate = endOfTemplate.replaceAll("<w:ftr[\\s\\S]+?</w:ftr>", "");
        endOfTemplate = endOfTemplate.replaceFirst("<w:pgSz [^>]*/>", "<w:type w:val=\"continuous\"/><w:pgSz w:w=\"12240\" w:h=\"15840\" w:code=\"1\"/>");
        return endOfTemplate;
    }

    protected String peekAtFirstArtifactToGetParagraphNumber(String template, String nextParagraphNumber, List<ArtifactReadable> artifacts) {
        String paragraphNum;
        ArtifactReadable artifact;
        String elementType;
        Matcher matcher;
        String startParagraphNumber = "1";
        if (artifacts != null && (matcher = headElementsPattern.matcher(template)).find() && (elementType = matcher.group(0)) != null && elementType.equals(INSERT_ARTIFACT_HERE) && !artifacts.isEmpty() && (artifact = artifacts.iterator().next()).isAttributeTypeValid((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber) && Strings.isValid((String)(paragraphNum = (String)artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber, (Object)"")))) {
            startParagraphNumber = paragraphNum;
        }
        return startParagraphNumber;
    }

    protected void processArtifactSet(String templateOptions, List<ArtifactReadable> artifacts, WordMLProducer wordMl, String outlineType, PresentationType presentationType, ArtifactId viewId) {
        this.nonTemplateArtifacts.clear();
        ArtifactId artifactId = this.publishingOptions.view = viewId == null ? ArtifactId.SENTINEL : viewId;
        if (Strings.isValid((String)this.outlineNumber)) {
            wordMl.setNextParagraphNumberTo(this.outlineNumber);
        }
        if (this.attributeElements.isEmpty()) {
            this.parseAttributeOptions(templateOptions);
        }
        if (this.metadataElements.isEmpty()) {
            this.parseMetadataOptions(templateOptions);
        }
        if (!this.publishingOptions.publishDiff) {
            ArrayList<ArtifactId> allArtifacts = new ArrayList<ArtifactId>();
            if (this.recurseChildren || this.publishingOptions.recurseOnLoad && !this.publishingOptions.originPublishAsDiff) {
                for (ArtifactReadable art : artifacts) {
                    allArtifacts.add((ArtifactId)art);
                    if (art.isHistorical()) continue;
                    allArtifacts.addAll(art.getDescendants());
                }
            } else {
                allArtifacts.addAll(artifacts);
            }
            DataRightsOperationsImpl dataRightsOps = new DataRightsOperationsImpl(this.orcsApi);
            DataRightResult response = dataRightsOps.getDataRights(allArtifacts, this.branch, this.overrideClassification);
            for (ArtifactReadable artifact : artifacts) {
                this.processObjectArtifact(artifact, wordMl, outlineType, presentationType, response);
            }
        }
        this.processedArtifacts.clear();
    }

    private void processObjectArtifact(ArtifactReadable artifact, WordMLProducer wordMl, String outlineType, PresentationType presentationType, DataRightResult data) {
        if (!artifact.isAttributeTypeValid((AttributeTypeToken)CoreAttributeTypes.WholeWordContent) && !artifact.isAttributeTypeValid((AttributeTypeToken)CoreAttributeTypes.NativeContent)) {
            if (!this.processedArtifacts.contains(artifact)) {
                boolean ignoreArtifact = this.excludeFolders && artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.Folder}) || this.artifactsToExclude.containsKey(ArtifactId.valueOf((Long)artifact.getId())) || this.emptyFolders.contains(artifact);
                boolean ignoreArtType = this.excludeArtifactTypes != null && this.isOfType(artifact, this.excludeArtifactTypes);
                boolean publishInline = (Boolean)artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.PublishInline, (Object)false);
                boolean startedSection = false;
                boolean templateOnly = this.publishingOptions.templateOnly;
                boolean includeUUIDs = this.publishingOptions.includeUuids;
                if (!ignoreArtifact && !ignoreArtType) {
                    if (this.outlining && !templateOnly) {
                        Boolean mergeTag;
                        AttributeTypeToken attrToken = AttributeTypeToken.valueOf((String)this.headingAttributeType.getIdString());
                        String headingText = artifact.getSoleAttributeAsString(attrToken, "");
                        if (includeUUIDs) {
                            String UUIDtext = String.format(" <UUID = %s>", artifact.getId());
                            headingText = headingText.concat(UUIDtext);
                        }
                        if ((mergeTag = Boolean.valueOf(this.publishingOptions.addMergeTag)) != null && mergeTag.booleanValue()) {
                            headingText = headingText.concat(" [MERGED]");
                        }
                        if (!publishInline && !templateOnly) {
                            this.paragraphNumber = wordMl.startOutlineSubSection((CharSequence)"Times New Roman", (CharSequence)headingText, outlineType);
                            startedSection = true;
                        }
                        if (this.paragraphNumber == null) {
                            this.paragraphNumber = wordMl.startOutlineSubSection();
                            startedSection = true;
                        }
                        if (this.publishingOptions.updateParagraphNumbers && !publishInline && artifact.isAttributeTypeValid((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber)) {
                            TransactionBuilder transaction = this.orcsApi.getTransactionFactory().createTransaction(this.branch, (UserId)SystemUser.OseeSystem, "Update paragraph number on artifact");
                            transaction.setSoleAttributeValue((ArtifactId)artifact, (AttributeTypeToken)CoreAttributeTypes.ParagraphNumber, (Object)this.paragraphNumber.toString());
                            transaction.commit();
                        }
                    }
                    String orientationStr = null;
                    if (artifact.isAttributeTypeValid((AttributeTypeToken)CoreAttributeTypes.PageOrientation)) {
                        orientationStr = (String)artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.PageOrientation, (Object)"Portrait");
                    }
                    PageOrientation orientation = PageOrientation.fromString(orientationStr);
                    String footer = data.getContent((ArtifactId)artifact, orientation);
                    this.processMetadata(artifact, wordMl);
                    this.processAttributes(artifact, wordMl, presentationType, publishInline, footer);
                }
                boolean recurse = this.publishingOptions.recurseOnLoad;
                boolean origDiff = this.publishingOptions.originPublishAsDiff;
                if (this.recurseChildren && !recurse || recurse && !origDiff) {
                    for (ArtifactReadable childArtifact : artifact.getChildren()) {
                        this.processObjectArtifact(childArtifact, wordMl, outlineType, presentationType, data);
                    }
                }
                if (startedSection) {
                    wordMl.endOutlineSubSection();
                }
                this.processedArtifacts.add(artifact);
            }
        } else {
            this.nonTemplateArtifacts.add(artifact);
        }
    }

    protected boolean isOfType(ArtifactReadable artifact, List<ArtifactTypeToken> excludeArtifactTypes) {
        for (ArtifactTypeToken artType : excludeArtifactTypes) {
            if (!artifact.isOfType(new ArtifactTypeId[]{artType})) continue;
            return true;
        }
        return false;
    }

    protected void processMetadata(ArtifactReadable artifact, WordMLProducer wordMl) {
        for (MetadataElement metadataElement : this.metadataElements) {
            this.processMetadata(artifact, wordMl, metadataElement);
        }
    }

    protected void processAttributes(ArtifactReadable artifact, WordMLProducer wordMl, PresentationType presentationType, boolean publishInLine, String footer) {
        for (AttributeElement attributeElement : this.attributeElements) {
            AttributeTypeToken attributeType2;
            String attributeName = attributeElement.getAttributeName();
            if (this.publishingOptions.allAttributes || attributeName.equals("*")) {
                for (AttributeTypeToken attributeType2 : this.getOrderedAttributeTypes(artifact, artifact.getValidAttributeTypes())) {
                    if (this.outlining && !attributeType2.notEqual((Id)this.headingAttributeType)) continue;
                    this.processAttribute(artifact, wordMl, attributeElement, attributeType2, true, presentationType, publishInLine, footer);
                }
                continue;
            }
            attributeType2 = this.orcsApi.getOrcsTypes().getAttributeTypes().getByName(attributeName);
            if (!artifact.isAttributeTypeValid(attributeType2)) continue;
            this.processAttribute(artifact, wordMl, attributeElement, attributeType2, false, presentationType, publishInLine, footer);
        }
    }

    protected void processMetadata(ArtifactReadable artifact, WordMLProducer wordMl, MetadataElement element) {
        wordMl.startParagraph();
        String name = element.getType();
        String format = element.getFormat();
        String label = element.getLabel();
        String value = "";
        if (name.equals(APPLICABILITY)) {
            value = "unknown";
            if (artifact.getApplicability().isValid()) {
                ApplicabilityToken applicabilityToken = this.applicabilityTokens.get(artifact.getApplicability());
                value = applicabilityToken != null && applicabilityToken.isValid() ? applicabilityToken.getName() : artifact.getApplicability().getIdString();
            }
        } else if (name.equals(ARTIFACT_TYPE)) {
            value = artifact.getArtifactType().getName();
        } else if (name.equals(ARTIFACT_ID)) {
            value = artifact.getIdString();
        }
        if (!format.isEmpty() || !label.isEmpty()) {
            if (label.contains(">x<")) {
                wordMl.addWordMl((CharSequence)label.replace(">x<", ">" + Xml.escape((CharSequence)(String.valueOf(name) + ": ")).toString() + "<"));
            }
            if (format.contains(">x<")) {
                wordMl.addWordMl((CharSequence)format.replace(">x<", ">" + Xml.escape((CharSequence)value).toString() + "<"));
            }
        } else {
            wordMl.addTextInsideParagraph((CharSequence)(String.valueOf(name) + ": " + value));
        }
        wordMl.endParagraph();
    }

    private void processAttribute(ArtifactReadable artifact, WordMLProducer wordMl, AttributeElement attributeElement, AttributeTypeToken attributeType, boolean allAttrs, PresentationType presentationType, boolean publishInLine, String footer) {
        boolean templateOnly;
        this.publishingOptions.allAttributes = allAttrs;
        if (!allAttrs && attributeType.matches(new Id[]{CoreAttributeTypes.Partition, CoreAttributeTypes.SeverityCategory}) && artifact.isAttributeTypeValid((AttributeTypeToken)CoreAttributeTypes.Partition)) {
            for (AttributeReadable partition : artifact.getAttributes((AttributeTypeId)CoreAttributeTypes.Partition)) {
                if (partition != null && partition.getValue() != null && !partition.getValue().equals("Unspecified")) continue;
                return;
            }
        }
        if ((templateOnly = this.publishingOptions.templateOnly) && attributeType.notEqual((Id)CoreAttributeTypes.WordTemplateContent)) {
            return;
        }
        ResultSet attributes = artifact.getAttributes((AttributeTypeId)attributeType);
        if (!attributes.isEmpty()) {
            if (attributeType.equals(CoreAttributeTypes.WordOleData)) {
                return;
            }
            if (this.publishingOptions.inPublishMode && CoreAttributeTypes.RelationOrder.equals((Object)attributeType)) {
                return;
            }
            if (!publishInLine || !artifact.isAttributeTypeValid((AttributeTypeToken)CoreAttributeTypes.WordTemplateContent) || attributeType.equals(CoreAttributeTypes.WordTemplateContent)) {
                this.renderAttribute(attributeType, artifact, presentationType, wordMl, attributeElement.getFormat(), attributeElement.getLabel(), footer);
            }
        } else if (attributeType.equals(CoreAttributeTypes.WordTemplateContent)) {
            this.renderAttribute(attributeType, artifact, presentationType, wordMl, attributeElement.getFormat(), attributeElement.getLabel(), footer);
        }
    }

    protected void displayNonTemplateArtifacts(Collection<ArtifactReadable> artifacts, String warningString) {
    }

    public Set<ArtifactId> getEmptyFolders() {
        return this.emptyFolders;
    }

    public void setExcludedArtifactTypeForTest(List<ArtifactTypeToken> excludeTokens) {
        this.excludeArtifactTypes.clear();
        for (ArtifactTypeToken token : excludeTokens) {
            this.excludeArtifactTypes.add(token);
        }
    }

    public List<ArtifactReadable> getScriptResult(String script) {
        return null;
    }

    public List<AttributeTypeToken> getOrderedAttributeTypes(ArtifactReadable artifact, Collection<AttributeTypeToken> attributeTypes) {
        ArrayList<AttributeTypeToken> orderedAttributeTypes = new ArrayList<AttributeTypeToken>(attributeTypes.size());
        AttributeTypeToken contentType = null;
        for (AttributeTypeToken attributeType : attributeTypes) {
            if (attributeType.matches(new Id[]{CoreAttributeTypes.WholeWordContent, CoreAttributeTypes.WordTemplateContent, CoreAttributeTypes.PlainTextContent})) {
                contentType = attributeType;
                continue;
            }
            orderedAttributeTypes.add(attributeType);
        }
        Collections.sort(orderedAttributeTypes);
        if (contentType != null) {
            orderedAttributeTypes.add(contentType);
        }
        return orderedAttributeTypes;
    }

    protected void renderAttribute(AttributeTypeToken attributeType, ArtifactReadable artifact, PresentationType presentationType, WordMLProducer producer, String format, String label, String footer) {
        WordMLProducer wordMl = producer;
        if (attributeType.equals(CoreAttributeTypes.WordTemplateContent)) {
            String data = null;
            LinkType linkType = this.publishingOptions.linkType;
            if (label.length() > 0) {
                wordMl.addParagraph((CharSequence)label);
            }
            Object txId = null;
            txId = artifact.isHistorical() ? this.orcsApi.getTransactionFactory().getTx(artifact.getTransaction()) : TransactionToken.SENTINEL;
            WordTemplateContentData wtcData = new WordTemplateContentData();
            wtcData.setArtId(artifact.getUuid());
            wtcData.setBranch(artifact.getBranch());
            wtcData.setFooter(footer);
            wtcData.setIsEdit(presentationType == PresentationType.SPECIALIZED_EDIT);
            wtcData.setLinkType(linkType != null ? linkType.toString() : null);
            wtcData.setTxId(txId);
            OseeSessionGrant session = new OseeSessionGrant();
            wtcData.setSessionId(session.getSessionId());
            wtcData.setPresentationType(presentationType);
            ArtifactId view = this.publishingOptions.view;
            wtcData.setViewId(view == null ? ArtifactId.SENTINEL : view);
            ArtifactUrlServer artUrl = new ArtifactUrlServer(this.orcsApi);
            wtcData.setPermanentLinkUrl(artUrl.getSelectedPermanentLinkUrl());
            Pair<String, Set<String>> content = null;
            try {
                WordTemplateContentRendererHandler rendererHandler = new WordTemplateContentRendererHandler(this.orcsApi, this.logger);
                content = rendererHandler.renderWordML(wtcData);
            }
            catch (Exception ex) {
                this.logger.error(ex.toString(), new Object[0]);
            }
            if (content != null) {
                data = (String)content.getFirst();
                data = data.replaceAll(this.newLineChar, "");
            }
            if (presentationType == PresentationType.SPECIALIZED_EDIT) {
                OseeLinkBuilder linkBuilder = new OseeLinkBuilder();
                wordMl.addEditParagraphNoEscape((CharSequence)linkBuilder.getStartEditImage(artifact.getGuid()));
                wordMl.addWordMl((CharSequence)data);
                wordMl.addEditParagraphNoEscape((CharSequence)linkBuilder.getEndEditImage(artifact.getGuid()));
            } else if (data != null) {
                wordMl.addWordMl((CharSequence)data);
            } else if (footer != null) {
                wordMl.addWordMl((CharSequence)footer);
            }
            wordMl.resetListValue();
        } else {
            if (attributeType.equals(CoreAttributeTypes.RelationOrder)) {
                return;
            }
            this.defaultRenderAttribute(attributeType, artifact, presentationType, producer, format, label, footer);
        }
    }

    protected void defaultRenderAttribute(AttributeTypeToken attributeType, ArtifactReadable artifact, PresentationType presentationType, WordMLProducer producer, String format, String label, String footer) {
        WordMLProducer wordMl = producer;
        boolean allAttrs = this.publishingOptions.allAttributes;
        wordMl.startParagraph();
        if (allAttrs) {
            if (!attributeType.matches(new Id[]{CoreAttributeTypes.PlainTextContent})) {
                wordMl.addWordMl((CharSequence)("<w:r><w:t> " + Xml.escape((CharSequence)attributeType.getName()) + ": </w:t></w:r>"));
            } else {
                wordMl.addWordMl((CharSequence)"<w:r><w:t> </w:t></w:r>");
            }
        } else {
            wordMl.addWordMl((CharSequence)label);
        }
        if (attributeType.equals(CoreAttributeTypes.RelationOrder)) {
            wordMl.endParagraph();
        } else {
            String valueList = artifact.getAttributeValuesAsString(attributeType);
            if (format.contains(">x<")) {
                wordMl.addWordMl((CharSequence)format.replace(">x<", ">" + Xml.escape((CharSequence)valueList).toString() + "<"));
            } else {
                wordMl.addTextInsideParagraph((CharSequence)valueList);
            }
            wordMl.endParagraph();
        }
    }
}

