/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.app.OseeAppletPage;
import org.eclipse.osee.define.rest.internal.DataRightsStreamingOutput;
import org.eclipse.osee.define.rest.internal.TraceAccumulator;
import org.eclipse.osee.define.rest.internal.TraceMatch;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.type.IResourceRegistry;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

@Path(value="/traceability/datarights")
public final class DataRightsSwReqAndCodeResource {
    private final OrcsApi orcsApi;
    private final IResourceRegistry resourceRegistry;
    private final ActivityLog activityLog;
    private final QueryFactory queryFactory;
    private static final ArtifactTypeToken WCAFE = ArtifactTypeToken.valueOf((long)204509162766367L, (String)"WCAFE", (ArtifactTypeToken[])new ArtifactTypeToken[0]);

    public DataRightsSwReqAndCodeResource(ActivityLog activityLog, IResourceRegistry resourceRegistry, OrcsApi orcsApi) {
        this.resourceRegistry = resourceRegistry;
        this.orcsApi = orcsApi;
        this.queryFactory = orcsApi.getQueryFactory();
        this.activityLog = activityLog;
    }

    @GET
    @Produces(value={"application/xml"})
    public Response getDataRightspReport(@QueryParam(value="branch") BranchId branch, @QueryParam(value="code_root") String codeRoot) {
        TraceMatch match = new TraceMatch("\\^SRS\\s*([^;]+);?", null);
        TraceAccumulator traceAccumulator = new TraceAccumulator(".*\\.(java|ada|ads|adb|c|h)", match);
        DataRightsStreamingOutput streamingOutput = new DataRightsStreamingOutput(this.orcsApi, branch, codeRoot, traceAccumulator, this.activityLog);
        Response.ResponseBuilder builder = Response.ok((Object)streamingOutput);
        String fileName = "Req_Code_Data_Rights_Trace_Report.xml";
        builder.header("Content-Disposition", (Object)("attachment; filename=" + fileName));
        return builder.build();
    }

    @Path(value="ui")
    @GET
    @Produces(value={"text/html"})
    public String getApplet() {
        OseeAppletPage pageUtil = new OseeAppletPage(this.queryFactory.branchQuery());
        return pageUtil.realizeApplet(this.resourceRegistry, "dataRightsReport.html", this.getClass());
    }

    @Path(value="validate")
    @GET
    @Produces(value={"text/html"})
    public String check(@QueryParam(value="branchId") BranchId branchId) {
        ResultSet results = this.queryFactory.fromBranch(branchId).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.AbstractSoftwareRequirement}).getResults();
        StringBuilder strb = new StringBuilder(2000);
        int count = 0;
        for (ArtifactReadable art : results) {
            if (art.isOfType(new ArtifactTypeId[]{WCAFE})) continue;
            String classification = (String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.DataRightsClassification, (Object)"");
            String subsystem = (String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Subsystem, (Object)"");
            String sme = (String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.SubjectMatterExpert, (Object)"");
            if (!subsystem.equals("Controls and Displays") && !subsystem.equals("Mission System Management") && !subsystem.equals("Data Management") && !subsystem.equals("Unmanned Systems Management")) continue;
            if (classification.isEmpty()) {
                this.appendDetails("missing classification", strb, art, subsystem, classification);
            }
            if (sme.equals("")) {
                this.appendDetails("missing sme", strb, art, subsystem, classification);
            }
            ++count;
        }
        strb.append("done" + count);
        return strb.toString();
    }

    @Path(value="software/{sourceBranch}/{destinationBranch}")
    @POST
    @Produces(value={"text/html"})
    public String copySWReqDataRights(@PathParam(value="sourceBranch") BranchId sourceBranch, @PathParam(value="destinationBranch") BranchId destinationBranch) {
        return this.copyDataRights(sourceBranch, destinationBranch, CoreArtifactTypes.AbstractSoftwareRequirement);
    }

    @Path(value="ssd/{sourceBranch}/{destinationBranch}")
    @POST
    @Produces(value={"text/html"})
    public String copySSDDataRights(@PathParam(value="sourceBranch") BranchId sourceBranch, @PathParam(value="destinationBranch") BranchId destinationBranch) {
        return this.copyDataRights(sourceBranch, destinationBranch, CoreArtifactTypes.SubsystemDesign);
    }

    private String copyDataRights(BranchId sourceBranch, BranchId destinationBranch, ArtifactTypeToken artifactType) {
        ResultSet results = this.queryFactory.fromBranch(destinationBranch).andIsOfType(new ArtifactTypeId[]{artifactType}).getResults();
        String branchName = ((Branch)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(sourceBranch)).getResults().getExactlyOne()).getName();
        String txMsg = "Copy data rights for " + artifactType + " from " + branchName;
        TransactionBuilder txBuilder = this.createTxBuilder(txMsg, destinationBranch);
        StringBuilder strb = new StringBuilder(2000);
        int count = 0;
        for (ArtifactReadable dest : results) {
            if (dest.isOfType(new ArtifactTypeId[]{WCAFE})) continue;
            ArtifactReadable source = (ArtifactReadable)this.queryFactory.fromBranch(sourceBranch).andId((ArtifactId)dest).getResults().getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
            if (source.isInvalid()) {
                String classification = (String)dest.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.DataRightsClassification, (Object)"");
                String subsystem = (String)dest.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Subsystem, (Object)"");
                this.appendDetails("missing source", strb, dest, subsystem, classification);
                continue;
            }
            this.setBestValue(txBuilder, source, dest, (AttributeTypeToken)CoreAttributeTypes.DataRightsClassification, strb);
            this.setBestValue(txBuilder, source, dest, (AttributeTypeToken)CoreAttributeTypes.SubjectMatterExpert, strb);
            this.setBestValue(txBuilder, source, dest, (AttributeTypeToken)CoreAttributeTypes.DataRightsBasis, strb);
            ++count;
        }
        txBuilder.commit();
        strb.append("done: " + count);
        return strb.toString();
    }

    private void appendDetails(String msg, StringBuilder strb, ArtifactReadable art, String subsystem, String classification) {
        strb.append(String.valueOf(msg) + "|" + subsystem + "|" + classification + " |" + art.getArtifactType() + "| " + art.getName() + "| " + art.getId() + "| " + art.getLastModifiedTransaction() + "<br />");
    }

    private TransactionBuilder createTxBuilder(String comment, BranchId branchId) {
        return this.orcsApi.getTransactionFactory().createTransaction(branchId, (UserId)SystemUser.OseeSystem, comment);
    }

    private void setBestValue(TransactionBuilder txBuilder, ArtifactReadable source, ArtifactReadable dest, AttributeTypeToken attributeType, StringBuilder strb) {
        String value = (String)dest.getSoleAttributeValue(attributeType, (Object)"");
        String sourceValue = (String)source.getSoleAttributeValue(attributeType, (Object)"Unspecified");
        if (sourceValue.equals("Unspecified")) {
            if (value.isEmpty() && attributeType.equals(CoreAttributeTypes.DataRightsClassification)) {
                txBuilder.setSoleAttributeValue((ArtifactId)dest, attributeType, (Object)"Unspecified");
            }
        } else if (value.isEmpty()) {
            txBuilder.setSoleAttributeValue((ArtifactId)dest, attributeType, (Object)sourceValue);
        } else if (!value.equals(sourceValue)) {
            strb.append(attributeType + " conflict | " + sourceValue + " | " + value + " | " + dest.getName() + "<br />");
        }
    }
}

