/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.osee.define.api.DefineApi;
import org.eclipse.osee.define.api.MSWordEndpoint;
import org.eclipse.osee.define.api.WordTemplateContentData;
import org.eclipse.osee.define.api.WordUpdateChange;
import org.eclipse.osee.define.api.WordUpdateData;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.Pair;

public final class MSWordEndpointImpl
implements MSWordEndpoint {
    private final DefineApi defineApi;

    public MSWordEndpointImpl(DefineApi defineApi) {
        this.defineApi = defineApi;
    }

    public WordUpdateChange updateWordArtifacts(WordUpdateData data) {
        return this.defineApi.getMSWordOperations().updateWordArtifacts(data);
    }

    public Pair<String, Set<String>> renderWordTemplateContent(WordTemplateContentData data) {
        return this.defineApi.getMSWordOperations().renderWordTemplateContent(data);
    }

    public Response publishWithNestedTemplates(BranchId branch, ArtifactId masterTemplate, ArtifactId slaveTemplate, ArtifactId headArtifact) {
        StreamingOutput streamingOutput = this.defineApi.getMSWordOperations().publishWithNestedTemplates(branch, masterTemplate, slaveTemplate, headArtifact);
        SimpleDateFormat format = new SimpleDateFormat("MM-dd_HH-mm-ss");
        Date date = new Date(System.currentTimeMillis());
        String time = format.format(date);
        String msofdName = headArtifact.getIdString();
        String fileName = String.valueOf(msofdName) + "_" + time + ".xml";
        Response.ResponseBuilder builder = Response.ok((Object)streamingOutput);
        builder.header("Content-Disposition", (Object)("attachment; filename=" + fileName));
        return builder.build();
    }

    public String getDocumentNames(BranchId branchId) {
        return null;
    }
}

