/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.NetRCCredentialsProvider;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.io.DisabledOutputStream;
import org.eclipse.osee.define.api.GitOperations;
import org.eclipse.osee.define.rest.FastHistoryStrategy;
import org.eclipse.osee.define.rest.HistoryImportStrategy;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.SystemPreferences;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public final class GitOperationsImpl
implements GitOperations {
    private final OrcsApi orcsApi;
    private final QueryFactory queryFactory;
    private final SystemPreferences systemPrefs;
    private final Map<String, ArtifactId> pathToCodeunitMap = new HashMap<String, ArtifactId>(10000);
    private static final Pattern changeIdPattern = Pattern.compile("\\s+Change-Id: (I\\w{40})");
    private final Matcher changeIdMatcher = changeIdPattern.matcher("");

    public GitOperationsImpl(OrcsApi orcsApi, SystemPreferences systemPrefs) {
        this.orcsApi = orcsApi;
        this.queryFactory = orcsApi.getQueryFactory();
        this.systemPrefs = systemPrefs;
    }

    public ArtifactToken getCommitArtifactId(BranchId branch, String changeId) {
        List commits = this.queryFactory.fromBranch(branch).andAttributeIs((AttributeTypeId)CoreAttributeTypes.GitChangeId, changeId).andTypeEquals(new ArtifactTypeId[]{CoreArtifactTypes.GitCommit}).getResults().getList();
        ArtifactToken latestCommit = ArtifactToken.SENTINEL;
        Date lastestAuthorDate = new Date(0L);
        for (ArtifactReadable commit : commits) {
            Date authorDate = (Date)commit.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.GitCommitAuthorDate);
            if (!authorDate.after(lastestAuthorDate)) continue;
            lastestAuthorDate = authorDate;
            latestCommit = commit;
        }
        return latestCommit;
    }

    public ArtifactReadable getRepoArtifact(BranchId branch, String repositoryName) {
        return this.queryFactory.fromBranch(branch).andNameEquals(repositoryName).andTypeEquals(new ArtifactTypeId[]{CoreArtifactTypes.GitRepository}).getArtifact();
    }

    private Repository getLocalRepoReference(String repoPath) {
        File gitDirPath = new File(String.valueOf(repoPath) + File.separator + ".git");
        try {
            return ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(gitDirPath)).readEnvironment()).findGitDir()).setMustExist(true)).build();
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public void fetch(ArtifactReadable repoArtifact, String passphrase) {
        Repository jgitRepo = this.getLocalRepoReference((String)repoArtifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.FileSystemPath));
        this.fetch(jgitRepo, passphrase);
    }

    private void fetch(Repository localRepo, String passphrase) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Git git = new Git(localRepo);){
                FetchCommand fetchCommand = git.fetch().setCheckFetchedObjects(true).setTagOpt(TagOpt.NO_TAGS);
                this.configurateAuthentication(localRepo, (TransportCommand<?, ?>)fetchCommand, passphrase);
                fetchCommand.call();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (GitAPIException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    private void configurateAuthentication(Repository repo, TransportCommand<?, ?> transportCommand, String passphrase) {
        String gitRepoUrl = repo.getConfig().getString("remote", "origin", "url");
        this.configurateAuthentication(gitRepoUrl, transportCommand, passphrase);
    }

    private void configurateAuthentication(String gitRepoUrl, TransportCommand<?, ?> transportCommand, String passphrase) {
        if (gitRepoUrl.startsWith("ssh")) {
            this.configureSsh(transportCommand, passphrase);
        } else {
            transportCommand.setCredentialsProvider((CredentialsProvider)new NetRCCredentialsProvider());
        }
    }

    private void configureSsh(TransportCommand<?, ?> transportCommand, final String passphrase) {
        JschConfigSessionFactory sshSessionFactory = new JschConfigSessionFactory(){

            protected void configure(OpenSshConfig.Host host, Session session) {
                session.setPassword(passphrase);
            }

            protected JSch createDefaultJSch(FS fs) throws JSchException {
                JSch defaultJSch = super.createDefaultJSch(fs);
                defaultJSch.addIdentity("~/.ssh/id_rsa", passphrase);
                return defaultJSch;
            }
        };
        transportCommand.setTransportConfigCallback(new TransportConfigCallback((SshSessionFactory)sshSessionFactory){
            private final /* synthetic */ SshSessionFactory val$sshSessionFactory;
            {
                this.val$sshSessionFactory = sshSessionFactory;
            }

            public void configure(Transport transport) {
                SshTransport sshTransport = (SshTransport)transport;
                sshTransport.setSshSessionFactory(this.val$sshSessionFactory);
            }
        });
    }

    public ArtifactId trackGitBranch(String gitRepoUrl, BranchId branch, UserId account, String gitBranchName, boolean clone, String passphrase) {
        ArtifactReadable repoArtifact = this.clone(gitRepoUrl, branch, account, clone, passphrase);
        return this.updateGitTrackingBranch(branch, repoArtifact, account, gitBranchName, !clone, passphrase, true);
    }

    public ArtifactId updateGitTrackingBranch(BranchId branch, ArtifactReadable repoArtifact, UserId account, String gitBranchName, boolean fetch, String passphrase, boolean initialImport) {
        Repository jgitRepo = this.getLocalRepoReference((String)repoArtifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.FileSystemPath));
        if (fetch) {
            this.fetch(jgitRepo, passphrase);
        }
        if (gitBranchName == null) {
            gitBranchName = (String)repoArtifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.DefaultTrackingBranch);
        }
        try {
            String latestImportedSHA;
            String fromString = "remotes/origin/" + gitBranchName;
            ObjectId from = jgitRepo.resolve(fromString);
            if (from == null) {
                throw new OseeStateException("Failed to resolve commit [%s]", new Object[]{fromString});
            }
            ObjectId to = null;
            ArtifactReadable latestCommit = (ArtifactReadable)repoArtifact.getRelated(CoreRelationTypes.Git_Repository_Commit).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
            if (latestCommit.isValid() && (to = ObjectId.fromString((String)(latestImportedSHA = (String)latestCommit.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.GitCommitSha)))) == null) {
                throw new OseeStateException("Failed to resolve commit [%s]", new Object[]{latestImportedSHA});
            }
            List currentCommits = this.queryFactory.fromBranch(branch).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.CodeUnit}).asArtifactTokens();
            for (ArtifactToken singleCommit : currentCommits) {
                this.pathToCodeunitMap.put(singleCommit.getName(), (ArtifactId)singleCommit);
            }
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(repoArtifact.getBranch(), account, "updateGitTrackingBranch repo [" + repoArtifact + "]");
            FastHistoryStrategy importStrategy = new FastHistoryStrategy((ArtifactToken)repoArtifact, this.orcsApi, tx, initialImport, this.pathToCodeunitMap);
            this.walkTree(repoArtifact, jgitRepo, to, from, repoArtifact.getBranch(), account, importStrategy);
        }
        catch (IOException | RevisionSyntaxException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
        return repoArtifact;
    }

    public ArtifactReadable clone(String gitRepoUrl, BranchId branch, UserId account, boolean clone, String passphrase) {
        String serverDataLocation = this.systemPrefs.getValue("osee.application.server.data");
        String repoName = gitRepoUrl.substring(gitRepoUrl.lastIndexOf(47) + 1).replaceAll("\\.git$", "");
        File localPath = new File(String.valueOf(serverDataLocation) + File.separator + "git", repoName);
        if (clone) {
            CloneCommand jgitClone = Git.cloneRepository().setURI(gitRepoUrl).setDirectory(localPath).setNoCheckout(true);
            this.configurateAuthentication(gitRepoUrl, (TransportCommand<?, ?>)jgitClone, passphrase);
            try {
                jgitClone.call();
            }
            catch (GitAPIException ex) {
                throw OseeCoreException.wrap((Throwable)ex);
            }
        }
        if (this.queryFactory.fromBranch(branch).andNameEquals(repoName).andTypeEquals(new ArtifactTypeId[]{CoreArtifactTypes.GitRepository}).exists()) {
            throw new OseeStateException("A repository named %s already exists on branch %s", new Object[]{repoName, branch});
        }
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, account, "GitOperationsImpl.createGitRepository()");
        ArtifactToken repoArtifact = tx.createArtifact((ArtifactId)CoreArtifactTokens.GitRepoFolder, CoreArtifactTypes.GitRepository, repoName);
        tx.setSoleAttributeValue((ArtifactId)repoArtifact, (AttributeTypeToken)CoreAttributeTypes.RepositoryUrl, (Object)gitRepoUrl);
        try {
            tx.setSoleAttributeValue((ArtifactId)repoArtifact, (AttributeTypeToken)CoreAttributeTypes.FileSystemPath, (Object)localPath.getCanonicalPath());
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
        tx.commit();
        return this.queryFactory.fromBranch(branch).andId((ArtifactId)repoArtifact).getArtifact();
    }

    private TransactionToken walkTree(ArtifactReadable repoArtifact, Repository jgitRepo, ObjectId to, ObjectId from, BranchId branch, UserId account, HistoryImportStrategy importStrategy) {
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (RevWalk revWalk = new RevWalk(jgitRepo);){
                revWalk.markStart(revWalk.parseCommit((AnyObjectId)from));
                if (to != null) {
                    RevCommit toRev = revWalk.parseCommit((AnyObjectId)to);
                    revWalk.markUninteresting(toRev);
                }
                revWalk.sort(RevSort.TOPO, true);
                revWalk.sort(RevSort.REVERSE, true);
                DiffFormatter df = new DiffFormatter((OutputStream)DisabledOutputStream.INSTANCE);
                df.setRepository(jgitRepo);
                df.setDiffComparator(RawTextComparator.DEFAULT);
                df.setDetectRenames(true);
                this.setPathFilter(repoArtifact, df);
                ArtifactId lastValidCommit = ArtifactId.SENTINEL;
                ObjectReader objectReader = revWalk.getObjectReader();
                for (RevCommit revCommit : revWalk) {
                    ArtifactId lastCommit = this.parseGitCommit(objectReader, df, (ArtifactId)repoArtifact, revCommit, branch, account, importStrategy);
                    if (!lastCommit.isValid()) continue;
                    lastValidCommit = lastCommit;
                }
                if (lastValidCommit.isValid()) {
                    TransactionBuilder tx = importStrategy.getTransactionBuilder(this.orcsApi, branch, account);
                    tx.unrelateFromAll(CoreRelationTypes.Git_Repository_Commit.getOpposite(), (ArtifactId)repoArtifact);
                    tx.relate((ArtifactId)repoArtifact, (RelationTypeToken)CoreRelationTypes.Git_Repository_Commit, lastValidCommit);
                    importStrategy.finishGitCommit(tx);
                }
                return importStrategy.finishImport();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    private void setPathFilter(ArtifactReadable repoArtifact, DiffFormatter df) {
        List paths = repoArtifact.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.ExcludePath);
        if (!paths.isEmpty()) {
            ArrayList<PathFilter> filters = new ArrayList<PathFilter>();
            for (String path : paths) {
                filters.add(PathFilter.create((String)path));
            }
            if (filters.size() > 1) {
                df.setPathFilter(AndTreeFilter.create(filters).negate());
            } else {
                df.setPathFilter(((TreeFilter)filters.get(0)).negate());
            }
        }
    }

    private ArtifactId parseGitCommit(ObjectReader objectReader, DiffFormatter df, ArtifactId repoArtifact, RevCommit revCommit, BranchId branch, UserId account, HistoryImportStrategy importStrategy) {
        try {
            String commitId;
            TransactionBuilder tx = importStrategy.getTransactionBuilder(this.orcsApi, branch, account);
            String commitSHA = revCommit.getId().name();
            if (this.changeIdMatcher.reset(revCommit.getFullMessage()).find()) {
                String changeId;
                commitId = changeId = this.changeIdMatcher.group(1);
                if (importStrategy.hasChangeIdAlredyImported(changeId)) {
                    ArtifactId artifactId = ArtifactId.SENTINEL;
                    return artifactId;
                }
            } else {
                commitId = commitSHA;
            }
            ArtifactToken commitArtifact = tx.createArtifact(CoreArtifactTypes.GitCommit, revCommit.getShortMessage());
            tx.setSoleAttributeValue((ArtifactId)commitArtifact, (AttributeTypeToken)CoreAttributeTypes.GitCommitSha, (Object)commitSHA);
            tx.setSoleAttributeValue((ArtifactId)commitArtifact, (AttributeTypeToken)CoreAttributeTypes.UserArtifactId, (Object)SystemUser.OseeSystem);
            tx.setSoleAttributeValue((ArtifactId)commitArtifact, (AttributeTypeToken)CoreAttributeTypes.GitCommitAuthorDate, (Object)revCommit.getAuthorIdent().getWhen());
            tx.setSoleAttributeValue((ArtifactId)commitArtifact, (AttributeTypeToken)CoreAttributeTypes.GitCommitMessage, (Object)revCommit.getFullMessage());
            tx.setSoleAttributeValue((ArtifactId)commitArtifact, (AttributeTypeToken)CoreAttributeTypes.GitChangeId, (Object)commitId);
            this.importFileChanges(objectReader, df, repoArtifact, revCommit, commitSHA, (ArtifactId)commitArtifact, branch, tx, importStrategy);
            importStrategy.finishGitCommit(tx);
            ArtifactToken artifactToken = commitArtifact;
            return artifactToken;
        }
        finally {
            revCommit.disposeBody();
        }
    }

    private void importFileChanges(ObjectReader objectReader, DiffFormatter df, ArtifactId repoArtifact, RevCommit revCommit, String commitSHA, ArtifactId commitArtifact, BranchId branch, TransactionBuilder tx, HistoryImportStrategy importStrategy) {
        if (revCommit.getParents().length > 1) {
            return;
        }
        RevTree parentTree = revCommit.getParentCount() > 0 ? revCommit.getParent(0).getTree() : null;
        List diffs = null;
        try {
            diffs = df.scan(parentTree, revCommit.getTree());
            for (DiffEntry entry : diffs) {
                String newPath;
                String path;
                DiffEntry.ChangeType changeType = entry.getChangeType();
                ArtifactId codeUnit = importStrategy.getCodeUnit(branch, tx, commitSHA, changeType, path = entry.getOldPath(), newPath = entry.getNewPath());
                if (!codeUnit.isValid()) continue;
                importStrategy.handleCodeUnit(branch, codeUnit, tx, repoArtifact, commitArtifact, changeType);
            }
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }
}

