/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import java.util.Collections;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.workflow.AtsTeamWfEndpointApi;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IOseeBranch;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.model.change.ChangeItem;

@Path(value="teamwf")
public class AtsTeamWfEndpointImpl
implements AtsTeamWfEndpointApi {
    private final AtsApi services;

    public AtsTeamWfEndpointImpl(AtsApi services) {
        this.services = services;
    }

    @GET
    @Path(value="{id}/changedata")
    @Produces(value={"application/json"})
    public List<ChangeItem> getChangeData(@PathParam(value="id") String id) {
        IAtsWorkItem workItem = this.services.getWorkItemService().getWorkItemByAnyId(id);
        if (!workItem.isTeamWorkflow()) {
            throw new UnsupportedOperationException();
        }
        IAtsTeamWorkflow teamWf = workItem.getParentTeamWorkflow();
        TransactionToken trans = this.services.getBranchService().getEarliestTransactionId(teamWf);
        if (trans.isValid()) {
            return this.services.getBranchService().getChangeData(trans);
        }
        IOseeBranch branch = this.services.getBranchService().getWorkingBranch(teamWf);
        if (branch.isValid()) {
            return this.services.getBranchService().getChangeData((BranchId)branch);
        }
        return Collections.emptyList();
    }
}

