/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import com.fasterxml.jackson.core.JsonFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.query.IAtsQuery;
import org.eclipse.osee.ats.api.team.ChangeType;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.AtsActionEndpointApi;
import org.eclipse.osee.ats.api.workflow.Attribute;
import org.eclipse.osee.ats.api.workflow.AttributeKey;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.NewActionData;
import org.eclipse.osee.ats.api.workflow.NewActionResult;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.api.workflow.transition.ITransitionHelper;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.core.util.ActionFactory;
import org.eclipse.osee.ats.core.workflow.transition.TransitionHelper;
import org.eclipse.osee.ats.core.workflow.transition.TransitionManager;
import org.eclipse.osee.ats.rest.internal.util.RestUtil;
import org.eclipse.osee.ats.rest.internal.util.TargetedVersion;
import org.eclipse.osee.ats.rest.internal.workitem.operations.ActionOperations;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeString;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.exception.OseeWrappedException;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.mvc.IdentityView;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeTypes;
import org.eclipse.osee.orcs.search.QueryBuilder;

@Path(value="action")
public final class AtsActionEndpointImpl
implements AtsActionEndpointApi {
    private final AtsApi atsApi;
    private final OrcsApi orcsApi;
    private final AttributeTypes attributeTypes;
    private static final String ATS_UI_ACTION_PREFIX = "/ui/action/ID";
    @Context
    private HttpHeaders httpHeaders;

    public AtsActionEndpointImpl(AtsApi atsApi, OrcsApi orcsApi, JsonFactory jsonFactory) {
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
        this.attributeTypes = orcsApi.getOrcsTypes().getAttributeTypes();
    }

    @GET
    @Produces(value={"text/html"})
    public String get() {
        try {
            return RestUtil.simplePageHtml("Action Resource");
        }
        catch (Exception ex) {
            return "Error producing action page " + ex.getMessage();
        }
    }

    @Path(value="{ids}")
    @IdentityView
    @GET
    @Produces(value={"application/json"})
    public List<IAtsWorkItem> getAction(@PathParam(value="ids") String ids) {
        List workItems = this.atsApi.getQueryService().getWorkItemsByIds(ids);
        return workItems;
    }

    @Path(value="{ids}/details")
    @GET
    @Produces(value={"application/json"})
    public List<IAtsWorkItem> getActionDetails(@PathParam(value="ids") String ids) {
        List workItems = this.atsApi.getQueryService().getWorkItemsByIds(ids);
        return workItems;
    }

    @Path(value="{ids}/child")
    @IdentityView
    @TargetedVersion
    @GET
    @Produces(value={"application/json"})
    public List<IAtsWorkItem> getActionChildren(@PathParam(value="ids") String ids) {
        LinkedList<IAtsWorkItem> children = new LinkedList<IAtsWorkItem>();
        for (ArtifactToken action : this.atsApi.getQueryService().getArtifactsByIds(ids)) {
            for (ArtifactToken childWf : this.atsApi.getRelationResolver().getRelated((ArtifactId)action, AtsRelationTypes.ActionToWorkflow_WorkFlow)) {
                IAtsWorkItem child = this.atsApi.getWorkItemService().getWorkItem(childWf);
                if (child == null) continue;
                children.add(child);
            }
        }
        return children;
    }

    @GET
    @Path(value="{id}/UnreleasedVersions")
    @Produces(value={"application/json"})
    public List<String> getUnreleasedVersionNames(@PathParam(value="id") String id) {
        LinkedList<String> versions = new LinkedList<String>();
        IAtsTeamWorkflow teamWf = this.atsApi.getQueryService().getTeamWf((ArtifactId)this.atsApi.getQueryService().getArtifactById(id));
        IAtsTeamDefinition targedVersionsTeamDef = teamWf.getTeamDefinition().getTeamDefinitionHoldingVersions();
        if (targedVersionsTeamDef != null) {
            for (IAtsVersion version : this.atsApi.getVersionService().getVersions(targedVersionsTeamDef)) {
                if (version.isReleased().booleanValue()) continue;
                versions.add(version.getName());
            }
        }
        return versions;
    }

    @GET
    @Path(value="{id}/TransitionToStates")
    @Produces(value={"application/json"})
    public List<String> getTransitionToStateNames(@PathParam(value="id") String id) {
        LinkedList<String> states = new LinkedList<String>();
        IAtsTeamWorkflow teamWf = this.atsApi.getQueryService().getTeamWf((ArtifactId)this.atsApi.getQueryService().getArtifactById(id));
        states.add(teamWf.getStateDefinition().getDefaultToState().getName());
        for (IAtsStateDefinition state : teamWf.getStateDefinition().getToStates()) {
            if (states.contains(state.getName())) continue;
            states.add(state.getName());
        }
        for (IAtsStateDefinition state : teamWf.getStateDefinition().getOverrideAttributeValidationStates()) {
            if (states.contains(state.getName())) continue;
            states.add(state.getName());
        }
        for (IAtsVersion version : this.atsApi.getVersionService().getVersions(teamWf.getTeamDefinition())) {
            if (version.isReleased().booleanValue()) continue;
            states.add(version.getName());
        }
        return states;
    }

    @GET
    @Path(value="{id}/assocArt/{attrTypeId}")
    @Produces(value={"application/json"})
    public List<String> getRelatedRequirements(@PathParam(value="id") ArtifactId workflowId, @PathParam(value="attrTypeId") AttributeTypeId relatedReqs, @QueryParam(value="versionType") AttributeTypeId versionType) {
        LinkedList<String> requirements = new LinkedList<String>();
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON);
        ArtifactReadable workflow = query.andId(workflowId).getArtifact();
        Integer vertionArtId = (Integer)workflow.getSoleAttributeValue((AttributeTypeToken)this.attributeTypes.get((Id)versionType));
        ArtifactReadable version = query.andId(ArtifactId.valueOf((int)vertionArtId)).getArtifact();
        BranchId versionBranch = BranchId.valueOf((String)((String)version.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.BaselineBranchId, (Object)"-1")));
        String values = (String)workflow.getSoleAttributeValue((AttributeTypeToken)this.attributeTypes.get((Id)relatedReqs));
        if (Strings.isValid((String)values)) {
            List<String> items = Arrays.asList(values.split("\\s*,\\s*"));
            List artIds = Collections.transform(items, ArtifactId::valueOf);
            Collection tokens = this.atsApi.getQueryService().getArtifacts(artIds, versionBranch);
            for (ArtifactToken token : tokens) {
                requirements.add(String.format("{ \"reqUuid\": \"%s\", \"reqName\": \"%s\" }", token.getIdString(), token.getName()));
            }
        }
        return requirements;
    }

    @Path(value="{id}/attributeType/{attrTypeId}")
    @GET
    @Produces(value={"application/json"})
    public Attribute getActionAttributeByType(@PathParam(value="id") String id, @PathParam(value="attrTypeId") String attrTypeId) {
        IAtsWorkItem workItem = this.atsApi.getQueryService().getWorkItem(id);
        ActionOperations ops = new ActionOperations(null, workItem, this.atsApi, this.orcsApi);
        Attribute attribute = ops.getActionAttributeValues(attrTypeId, workItem);
        return attribute;
    }

    @Path(value="{id}/attributeType/{attrTypeIdOrKey}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Attribute setActionAttributeByType(@PathParam(value="id") String id, @PathParam(value="attrTypeIdOrKey") String attrTypeIdOrKey, List<String> values) {
        Conditions.assertNotNull(values, (String)"values can not be null", (Object[])new Object[0]);
        IAtsWorkItem workItem = (IAtsWorkItem)this.atsApi.getQueryService().getWorkItemsByIds(id).iterator().next();
        IAtsChangeSet changes = this.atsApi.createChangeSet("Set attr by type/key [" + attrTypeIdOrKey + "]");
        IAtsUser asUser = this.atsApi.getUserService().getUserByAccountId(this.httpHeaders);
        if (asUser == null) {
            asUser = AtsCoreUsers.SYSTEM_USER;
        }
        AttributeTypeString attrTypeId = null;
        if (attrTypeIdOrKey.equals(AttributeKey.Title.name())) {
            changes.setSoleAttributeValue(workItem, (AttributeTypeToken)CoreAttributeTypes.Name, values.iterator().next());
            attrTypeId = CoreAttributeTypes.Name;
        } else if (attrTypeIdOrKey.equals(AttributeKey.Priority.name())) {
            changes.setSoleAttributeValue(workItem, (AttributeTypeToken)AtsAttributeTypes.Priority, values.iterator().next());
            attrTypeId = AtsAttributeTypes.Priority;
        } else if (attrTypeIdOrKey.equals(AttributeKey.ColorTeam.name())) {
            changes.setSoleAttributeValue(workItem, (AttributeTypeToken)AtsAttributeTypes.ColorTeam, values.iterator().next());
            attrTypeId = AtsAttributeTypes.ColorTeam;
        } else if (attrTypeIdOrKey.equals(AttributeKey.IPT.name())) {
            changes.setSoleAttributeValue(workItem, (AttributeTypeToken)AtsAttributeTypes.IPT, values.iterator().next());
            attrTypeId = AtsAttributeTypes.IPT;
        } else if (attrTypeIdOrKey.equals(AttributeKey.State.name())) {
            String state = values.iterator().next();
            TransitionHelper helper = new TransitionHelper("Transition Workflow", Arrays.asList(workItem), state, new ArrayList(), "", changes, this.atsApi, new TransitionOption[]{TransitionOption.OverrideAssigneeCheck});
            helper.setTransitionUser(asUser);
            TransitionManager mgr = new TransitionManager((ITransitionHelper)helper);
            TransitionResults results = new TransitionResults();
            mgr.handleTransitionValidation(results);
            if (!results.isEmpty()) {
                throw new OseeArgumentException("Exception transitioning " + results.toString(), new Object[0]);
            }
            mgr.handleTransition(results);
            if (!results.isEmpty()) {
                throw new OseeArgumentException("Exception transitioning " + results.toString(), new Object[0]);
            }
            attrTypeId = AtsAttributeTypes.CurrentState;
        } else if (attrTypeIdOrKey.equals(AttributeKey.Version.name())) {
            if (!workItem.isTeamWorkflow()) {
                throw new OseeArgumentException("Not valid to set version for [%s]", new Object[]{workItem.getArtifactTypeName()});
            }
            IAtsVersion currVersion = this.atsApi.getVersionService().getTargetedVersion(workItem);
            if (values.isEmpty() && currVersion != null) {
                this.atsApi.getVersionService().removeTargetedVersion(workItem.getParentTeamWorkflow(), changes);
            } else if (Strings.isNumeric((String)values.iterator().next())) {
                String version = values.iterator().next();
                if (currVersion == null || !currVersion.getIdString().equals(version)) {
                    IAtsVersion newVer = null;
                    IAtsTeamDefinition teamDef = workItem.getParentTeamWorkflow().getTeamDefinition().getTeamDefinitionHoldingVersions();
                    for (IAtsVersion teamDefVer : this.atsApi.getVersionService().getVersions(teamDef)) {
                        if (!teamDefVer.getIdString().equals(version)) continue;
                        newVer = teamDefVer;
                        break;
                    }
                    if (newVer == null) {
                        throw new OseeArgumentException("Version id [%s] not valid for team ", new Object[]{version, teamDef.toStringWithId()});
                    }
                    this.atsApi.getVersionService().setTargetedVersion(workItem.getParentTeamWorkflow(), newVer, changes);
                }
            } else if (Strings.isValid((String)values.iterator().next())) {
                String version = values.iterator().next();
                if (currVersion == null || !currVersion.getName().equals(version)) {
                    IAtsVersion newVer = null;
                    IAtsTeamDefinition teamDef = workItem.getParentTeamWorkflow().getTeamDefinition().getTeamDefinitionHoldingVersions();
                    for (IAtsVersion teamDefVer : this.atsApi.getVersionService().getVersions(teamDef)) {
                        if (!teamDefVer.getName().equals(version)) continue;
                        newVer = teamDefVer;
                        break;
                    }
                    if (newVer == null) {
                        throw new OseeArgumentException("Version name [%s] not valid for team ", new Object[]{version, teamDef.toStringWithId()});
                    }
                    this.atsApi.getVersionService().setTargetedVersion(workItem.getParentTeamWorkflow(), newVer, changes);
                }
            }
        } else if (attrTypeIdOrKey.equals(AttributeKey.Originator.name())) {
            String accountId = values.iterator().next();
            if (!Strings.isNumeric((String)accountId)) {
                IAtsUser originator = this.atsApi.getUserService().getUserByAccountId(Long.valueOf(accountId));
                if (originator == null) {
                    throw new OseeArgumentException("No user with account id [%s]", new Object[]{accountId});
                }
                this.atsApi.getActionFactory().setCreatedBy(workItem, originator, true, workItem.getCreatedDate(), changes);
            }
        } else if (attrTypeIdOrKey.equals(AttributeKey.Assignee.name())) {
            LinkedList<IAtsUser> assignees = new LinkedList<IAtsUser>();
            for (String accountIdOrName : values) {
                IAtsUser assignee;
                if (Strings.isNumeric((String)accountIdOrName)) {
                    assignee = this.atsApi.getUserService().getUserByAccountId(Long.valueOf(accountIdOrName));
                    if (assignee == null) {
                        throw new OseeArgumentException("No user with account id [%s]", new Object[]{accountIdOrName});
                    }
                    assignees.add(assignee);
                    continue;
                }
                assignee = this.atsApi.getUserService().getUserByName(accountIdOrName);
                if (assignee == null) {
                    throw new OseeArgumentException("No user with account name [%s]", new Object[]{accountIdOrName});
                }
                assignees.add(assignee);
            }
            workItem.getStateMgr().setAssignees(assignees);
            changes.add((Object)workItem);
        } else {
            attrTypeId = this.atsApi.getStoreService().getAttributeType(Long.valueOf(attrTypeIdOrKey));
            if (attrTypeId != null) {
                changes.setAttributeValuesAsStrings((IAtsObject)workItem, (AttributeTypeId)attrTypeId, values);
            }
        }
        ActionOperations actionOps = new ActionOperations(asUser, workItem, this.atsApi, this.orcsApi);
        return actionOps.setActionAttributeByType(id, attrTypeIdOrKey, values);
    }

    @Path(value="{id}/cancel")
    @GET
    @Produces(value={"text/html"})
    public Response cancelAction(@PathParam(value="id") String id) {
        IAtsUser asUser = this.atsApi.getUserService().getUserByAccountId(this.httpHeaders);
        IAtsWorkItem workItem = this.atsApi.getQueryService().getWorkItem(id);
        if (workItem.isInWork()) {
            Conditions.assertNotNull((Object)workItem, (String)"workItem can not be found", (Object[])new Object[0]);
            if (asUser == null) {
                asUser = AtsCoreUsers.SYSTEM_USER;
            }
            ActionOperations ops = new ActionOperations(asUser, workItem, this.atsApi, this.orcsApi);
            ops.setActionAttributeByType(id, AttributeKey.State.name(), Arrays.asList("Cancelled"));
        }
        String htmlUrl = this.atsApi.getWorkItemService().getHtmlUrl(workItem, this.atsApi);
        try {
            return Response.temporaryRedirect((URI)new URI(htmlUrl)).build();
        }
        catch (Exception ex) {
            throw new OseeWrappedException((Throwable)ex);
        }
    }

    @Path(value="{workItemId}/changeType/{changeType}")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Collection<ArtifactToken> setByArtifactToken(@PathParam(value="workItemId") String workItemId, @PathParam(value="changeType") String changeType, Collection<ArtifactToken> artifacts) {
        IAtsWorkItem workItem = this.atsApi.getQueryService().getWorkItem(workItemId);
        IAtsUser asUser = this.atsApi.getUserService().getUserByAccountId(this.httpHeaders);
        if (asUser == null) {
            asUser = AtsCoreUsers.SYSTEM_USER;
        }
        ActionOperations ops = new ActionOperations(asUser, workItem, this.atsApi, this.orcsApi);
        return ops.setByArtifactToken(workItem, changeType, artifacts);
    }

    @Path(value="{ids}/legacy/state")
    @GET
    @Produces(value={"application/json"})
    public String getActionStateFromLegacyPcrId(@PathParam(value="ids") String ids) {
        ArrayList<IAtsWorkItem> workItems = new ArrayList<IAtsWorkItem>();
        for (String id : this.atsApi.getQueryService().getIdsFromStr(ids)) {
            ArtifactToken action = this.atsApi.getQueryService().getArtifactByLegacyPcrId(id);
            if (action == null) continue;
            IAtsWorkItem workItem = this.atsApi.getWorkItemService().getWorkItem(action);
            workItems.add(workItem);
        }
        return this.atsApi.getActionFactory().getActionStateJson(workItems);
    }

    @Path(value="{ids}/state")
    @GET
    @Produces(value={"application/json"})
    public String getActionState(@PathParam(value="ids") String ids) {
        List workItems = this.atsApi.getQueryService().getWorkItemsByIds(ids);
        return this.atsApi.getActionFactory().getActionStateJson((Collection)workItems);
    }

    @Path(value="query")
    @GET
    @Produces(value={"application/json"})
    public Set<IAtsWorkItem> query(@Context UriInfo uriInfo) {
        HashSet<IAtsWorkItem> workItems = new HashSet<IAtsWorkItem>();
        MultivaluedMap queryParameters = uriInfo.getQueryParameters(true);
        Set entrySet = queryParameters.entrySet();
        IAtsQuery query = this.atsApi.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]);
        LinkedList<IAtsTeamDefinition> teams = new LinkedList<IAtsTeamDefinition>();
        for (Map.Entry entry : entrySet) {
            if (((String)entry.getKey()).equals("Title")) {
                query.andName((String)((List)entry.getValue()).iterator().next(), QueryOption.CONTAINS_MATCH_OPTIONS);
                continue;
            }
            if (((String)entry.getKey()).equals("Priority")) {
                query.andAttr((AttributeTypeId)AtsAttributeTypes.Priority, (Collection)entry.getValue(), new QueryOption[0]);
                continue;
            }
            if (((String)entry.getKey()).equals("ColorTeam")) {
                query.andColorTeam((String)((List)entry.getValue()).iterator().next());
                continue;
            }
            if (((String)entry.getKey()).equals("Assignee")) {
                LinkedList<IAtsUser> assignees = new LinkedList<IAtsUser>();
                for (Object userId : (List)entry.getValue()) {
                    IAtsUser assignee = this.atsApi.getUserService().getUserById((String)userId);
                    if (assignee == null) continue;
                    assignees.add(assignee);
                }
                query.andAssignee(assignees.toArray(new IAtsUser[assignees.size()]));
                continue;
            }
            if (((String)entry.getKey()).equals("IPT")) {
                query.andAttr((AttributeTypeId)AtsAttributeTypes.IPT, (String)((List)entry.getValue()).iterator().next(), new QueryOption[0]);
                continue;
            }
            if (((String)entry.getKey()).equals("Team")) {
                Object userId;
                userId = ((List)entry.getValue()).iterator();
                while (userId.hasNext()) {
                    String teamId = (String)userId.next();
                    IAtsTeamDefinition team = (IAtsTeamDefinition)this.atsApi.getQueryService().getConfigItem(Long.valueOf(teamId));
                    if (team == null) continue;
                    teams.add(team);
                }
                query.andTeam(teams);
                continue;
            }
            if (((String)entry.getKey()).equals("State")) {
                query.andState((String)((List)entry.getValue()).iterator().next());
                continue;
            }
            if (((String)entry.getKey()).equals("StateType")) {
                try {
                    LinkedList<StateType> stateTypes = new LinkedList<StateType>();
                    for (String type : (List)entry.getValue()) {
                        StateType stateType2 = StateType.valueOf((String)type);
                        stateTypes.add(stateType2);
                    }
                    query.andStateType(stateTypes.toArray(new StateType[stateTypes.size()]));
                }
                catch (Exception exception) {}
                continue;
            }
            if (((String)entry.getKey()).equals("Originator")) {
                IAtsUser assignee = this.atsApi.getUserService().getUserById((String)((List)entry.getValue()).iterator().next());
                query.andOriginator(assignee);
                continue;
            }
            if (((String)entry.getKey()).equals("WorkItemType")) {
                LinkedList<WorkItemType> workItemTypes = new LinkedList<WorkItemType>();
                for (String type : (List)entry.getValue()) {
                    WorkItemType workItem = WorkItemType.valueOf((String)type);
                    workItemTypes.add(workItem);
                }
                query.andWorkItemType(workItemTypes.toArray(new WorkItemType[workItemTypes.size()]));
                continue;
            }
            if (((String)entry.getKey()).equals("Version")) {
                IAtsVersion version = (IAtsVersion)this.atsApi.getQueryService().getConfigItem(Long.valueOf((String)((List)entry.getValue()).iterator().next()));
                query.andVersion(version);
                continue;
            }
            String key = (String)entry.getKey();
            AttributeTypeToken attrType = null;
            if (Strings.isNumeric((String)key)) {
                attrType = this.atsApi.getStoreService().getAttributeType(Long.valueOf(key));
            }
            if (attrType == null) {
                attrType = this.atsApi.getStoreService().getAttributeType(key);
            }
            query.andAttr((AttributeTypeId)attrType, (Collection)entry.getValue(), new QueryOption[0]);
        }
        if (teams.isEmpty()) {
            throw new OseeArgumentException("Team(s) are invalid and must be included.", new Object[0]);
        }
        workItems.addAll(query.getItems());
        return workItems;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public NewActionResult createAction(NewActionData newActionData) {
        return this.createNewAction(newActionData);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NewActionResult createNewAction(NewActionData newActionData) {
        NewActionResult result = new NewActionResult();
        try {
            ArtifactId teamWf;
            String ret;
            IAtsUser asUser = this.atsApi.getUserService().getUserById(newActionData.getAsUserId());
            if (asUser == null) {
                result.getResults().errorf("asUser [%s] not valid", new Object[]{newActionData.getAsUserId()});
                return result;
            }
            IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Create Action - Server", asUser);
            ActionFactory factory = new ActionFactory(this.atsApi);
            ActionResult actionResult = factory.createAction(newActionData, changes);
            TransactionId transaction = changes.executeIfNeeded();
            if (transaction != null && transaction.isInvalid()) {
                result.getResults().errorf("TransactionId came back as inValid.  Action not created.", new Object[0]);
                return result;
            }
            result.setAction(ArtifactId.valueOf((Id)actionResult.getActionArt()));
            Iterator iterator = actionResult.getTeamWfArts().iterator();
            do {
                if (!iterator.hasNext()) {
                    return result;
                }
                teamWf = (ArtifactId)iterator.next();
                result.addTeamWf(teamWf);
            } while (!Strings.isInValid((String)(ret = teamWf.getIdString())));
            return null;
        }
        catch (Exception ex) {
            result.getResults().errorf("Exception creating action [%s]", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
        return result;
    }

    @Path(value="createEmpty")
    @POST
    @Produces(value={"application/json"})
    public String createEmptyAction(@QueryParam(value="userId") String userId, @QueryParam(value="ai") String actionItem, @QueryParam(value="title") String title) {
        String newActionId = "";
        NewActionData newActionData = this.getNewActionData(userId, actionItem, title);
        NewActionResult newAction = this.createNewAction(newActionData);
        if (newAction == null || newAction.getTeamWfs().isEmpty()) {
            throw new OseeCoreException("Unable to create new Action", new Object[0]);
        }
        newActionId = ((ArtifactId)newAction.getTeamWfs().get(0)).getIdString();
        return String.format("{ \"id\":\"%s\" }", newActionId);
    }

    private NewActionData getNewActionData(String userId, String actionItem, String title) {
        NewActionData newActionData = new NewActionData();
        ArrayList<String> actionIds = new ArrayList<String>();
        actionIds.add(actionItem);
        newActionData.setAiIds(actionIds);
        newActionData.setTitle(title);
        newActionData.setAsUserId(userId);
        newActionData.setCreatedByUserId(userId);
        return newActionData;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response createAction(MultivaluedMap<String, String> form) {
        String title = (String)form.getFirst((Object)"ats_title");
        if (!Strings.isValid((String)title)) {
            return RestUtil.returnBadRequest("title is not valid");
        }
        String description = (String)form.getFirst((Object)"desc");
        String actionableItems = (String)form.getFirst((Object)"actionableItems");
        if (!Strings.isValid((String)actionableItems)) {
            return RestUtil.returnBadRequest("actionableItems is not valid");
        }
        ArrayList<IAtsActionableItem> aias = new ArrayList<IAtsActionableItem>();
        IAtsActionableItem aia = (IAtsActionableItem)this.atsApi.getQueryService().createQuery(new ArtifactTypeToken[]{AtsArtifactTypes.ActionableItem}).andName(actionableItems).getOneOrDefault(IAtsActionableItem.class, (IAtsConfigObject)IAtsActionableItem.SENTINEL);
        if (aia.isInvalid()) {
            return RestUtil.returnBadRequest(String.format("actionableItems [%s] is not valid", actionableItems));
        }
        aias.add(aia);
        String userId = (String)form.getFirst((Object)"userId");
        if (!Strings.isValid((String)userId)) {
            return RestUtil.returnBadRequest("userId is not valid");
        }
        IAtsUser atsUser = this.atsApi.getUserService().getUserById(userId);
        if (atsUser == null) {
            return RestUtil.returnBadRequest(String.format("userId [%s] is not valid", userId));
        }
        String changeTypeStr = (String)form.getFirst((Object)"changeType");
        if (!Strings.isValid((String)changeTypeStr)) {
            return RestUtil.returnBadRequest("changeType is not valid");
        }
        IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Create Action - Server", atsUser);
        ChangeType changeType = null;
        try {
            changeType = ChangeType.valueOf((String)changeTypeStr);
        }
        catch (Exception exception) {
            return RestUtil.returnBadRequest(String.format("changeType [%s] is not valid", changeTypeStr));
        }
        String priority = (String)form.getFirst((Object)"priority");
        if (!Strings.isValid((String)priority)) {
            return RestUtil.returnBadRequest("priority is not valid");
        }
        if (!priority.matches("[0-5]{1}")) {
            return RestUtil.returnBadRequest(String.format("priority [%s] is not valid", priority));
        }
        ActionResult action = this.atsApi.getActionFactory().createAction(atsUser, title, description, changeType, priority, false, null, aias, new Date(), atsUser, null, changes);
        changes.execute();
        return RestUtil.redirect(action.getTeamWfs(), ATS_UI_ACTION_PREFIX, this.atsApi);
    }

    @Path(value="query/legacyId")
    @GET
    @Produces(value={"application/json"})
    public List<IAtsWorkItem> query(@QueryParam(value="ids") String idsStr) {
        LinkedList<IAtsWorkItem> results = new LinkedList<IAtsWorkItem>();
        LinkedList<String> ids = new LinkedList<String>();
        String[] stringArray = idsStr.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            id = id.replaceAll("^ ", "");
            if (Strings.isValid((String)(id = id.replaceAll(" $", "")))) {
                ids.add(id);
            }
            ++n2;
        }
        Collection items = this.atsApi.getQueryService().createQuery(WorkItemType.TeamWorkflow, new WorkItemType[0]).andLegacyIds(ids).getItems(IAtsTeamWorkflow.class);
        results.addAll(items);
        return results;
    }
}

