/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.notify;

import java.util.List;
import org.eclipse.osee.ats.api.notify.AtsNotificationCollector;
import org.eclipse.osee.ats.api.notify.AtsNotificationEvent;
import org.eclipse.osee.ats.api.notify.AtsWorkItemNotificationEvent;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.ats.rest.internal.notify.WorkItemNotificationProcessor;
import org.eclipse.osee.ats.rest.util.IAtsNotifierServer;
import org.eclipse.osee.framework.jdk.core.util.EmailUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AtsNotificationEventProcessor {
    private final String noReplyEmail;
    private final WorkItemNotificationProcessor workItemNotificationProcessor;
    private final IAtsUserService userService;

    public AtsNotificationEventProcessor(WorkItemNotificationProcessor workItemNotificationProcessor, IAtsUserService userService, String noReplyEmail) {
        this.workItemNotificationProcessor = workItemNotificationProcessor;
        this.userService = userService;
        this.noReplyEmail = noReplyEmail;
    }

    public void sendNotifications(AtsNotificationCollector notifications, List<IAtsNotifierServer> notifiers) {
        for (AtsWorkItemNotificationEvent workItemEvent : notifications.getWorkItemNotificationEvents()) {
            this.workItemNotificationProcessor.run(notifications, workItemEvent);
        }
        String testingUserEmail = "";
        String fromUserEmail = this.getFromUserEmail(notifications);
        for (IAtsNotifierServer notifier : notifiers) {
            notifier.sendNotifications(fromUserEmail, testingUserEmail, notifications.getSubject(), notifications.getBody(), notifications.getNotificationEvents());
        }
    }

    private String getFromUserEmail(AtsNotificationCollector notifications) {
        String email = this.noReplyEmail;
        for (AtsNotificationEvent event : notifications.getNotificationEvents()) {
            IAtsUser userById;
            if (!Strings.isValid((String)event.getFromUserId()) || !EmailUtil.isEmailValid((String)(userById = this.userService.getUserById(event.getFromUserId())).getEmail())) continue;
            email = userById.getEmail();
            break;
        }
        return email;
    }
}

