/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.demo;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.config.tx.IAtsActionableItemArtifactToken;
import org.eclipse.osee.ats.api.config.tx.IAtsConfigTx;
import org.eclipse.osee.ats.api.config.tx.IAtsConfigTxActionableItem;
import org.eclipse.osee.ats.api.config.tx.IAtsConfigTxTeamDef;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.data.AtsTaskDefToken;
import org.eclipse.osee.ats.api.data.AtsUserGroups;
import org.eclipse.osee.ats.api.demo.DemoArtifactToken;
import org.eclipse.osee.ats.api.demo.DemoArtifactTypes;
import org.eclipse.osee.ats.api.demo.DemoWorkDefinitions;
import org.eclipse.osee.ats.api.query.NextRelease;
import org.eclipse.osee.ats.api.query.ReleasedOption;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionTokens;
import org.eclipse.osee.ats.core.config.OrganizePrograms;
import org.eclipse.osee.ats.core.task.DemoTaskSetDefinitionTokens;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.IOseeBranch;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DemoBranches;
import org.eclipse.osee.framework.core.enums.DemoUsers;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.NamedId;

public class DemoDatabaseConfig {
    private final AtsApi atsApi;
    private IAtsConfigTx cfgTx;

    public DemoDatabaseConfig(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public XResultData run() {
        this.configTxDemoAisAndTeams();
        this.configureForParallelCommit();
        IAtsChangeSet changes = this.atsApi.createChangeSet("Set ATS Admin");
        changes.relate((Object)AtsUserGroups.AtsTempAdmin, CoreRelationTypes.Users_User, (Object)DemoUsers.Joe_Smith);
        changes.execute();
        new OrganizePrograms(this.atsApi).run();
        this.atsApi.setConfigValue("single_server_deployment", "true");
        return new XResultData();
    }

    private void configTxDemoAisAndTeams() {
        this.cfgTx = this.atsApi.getConfigService().createConfigTx("Create Demo Config", AtsCoreUsers.SYSTEM_USER);
        IAtsConfigTxTeamDef topTeam = this.cfgTx.createTeamDef(null, AtsArtifactToken.TopTeamDefinition).andWorkDef((NamedId)AtsWorkDefinitionTokens.WorkDef_Team_Default);
        IAtsConfigTxActionableItem topActionableItem = this.cfgTx.createActionableItem(AtsArtifactToken.TopActionableItem).andActionable(false);
        this.createSawPlTeamConfig(this.cfgTx, topTeam, topActionableItem);
        this.createSawTeamConfig(this.cfgTx, topTeam, topActionableItem);
        this.createCisTeamConfig(this.cfgTx, topTeam, topActionableItem);
        this.createFacilitiesTeamConfig(this.cfgTx, topTeam, topActionableItem);
        this.createProcessTeamConfig(this.cfgTx, topTeam, topActionableItem);
        this.createToolsTeamConfig(this.cfgTx, topTeam, topActionableItem);
        this.createSystemSafetyTeamConfig(this.cfgTx, topTeam, topActionableItem);
        this.cfgTx.execute();
    }

    private void createFacilitiesTeamConfig(IAtsConfigTx cfgTx, IAtsConfigTxTeamDef topTeam, IAtsConfigTxActionableItem topActionableItem) {
        IAtsConfigTxTeamDef facilitiesTeam = topTeam.createChildTeamDef(topTeam.getTeamDef(), DemoArtifactToken.Facilities_Team).andLeads(new UserToken[]{DemoUsers.John_Stevens}).andMembers(new UserToken[]{DemoUsers.John_Stevens, DemoUsers.Steven_Michael, DemoUsers.Michael_John, DemoUsers.Jason_Stevens}).andWorkDef((NamedId)AtsWorkDefinitionTokens.WorkDef_Team_Simple);
        facilitiesTeam.createChildTeamDef(facilitiesTeam.getTeamDef(), DemoArtifactToken.Facilities_IT_Team).andLeads(new UserToken[]{DemoUsers.Kay_Wheeler}).andMembers(new UserToken[]{DemoUsers.Kay_Wheeler, DemoUsers.Jason_Stevens, DemoUsers.Michael_John, DemoUsers.Jason_Stevens}).andWorkDef((NamedId)AtsWorkDefinitionTokens.WorkDef_Team_Simple);
        IAtsConfigTxActionableItem facilitiesAI = topActionableItem.createChildActionableItem(DemoArtifactToken.Facilities_Ai).andActionable(true).andTeamDef(DemoArtifactToken.Facilities_Team);
        facilitiesAI.createChildActionableItem("Backups").andActionable(true).andTeamDef(DemoArtifactToken.Facilities_IT_Team);
        facilitiesAI.createChildActionableItem("Break Room").andActionable(true);
        facilitiesAI.createChildActionableItem("Computers").andActionable(true).andTeamDef(DemoArtifactToken.Facilities_IT_Team);
        facilitiesAI.createChildActionableItem("Network").andActionable(true).andTeamDef(DemoArtifactToken.Facilities_IT_Team);
        facilitiesAI.createChildActionableItem("Vending Machines").andActionable(true);
    }

    private void createToolsTeamConfig(IAtsConfigTx cfgTx, IAtsConfigTxTeamDef topTeam, IAtsConfigTxActionableItem topActionableItem) {
        IAtsConfigTxTeamDef toolsTeamTeam = topTeam.createChildTeamDef(topTeam.getTeamDef(), DemoArtifactToken.Tools_Team).andLeads(new UserToken[]{DemoUsers.Jeffery_Kay}).andMembers(new UserToken[]{DemoUsers.Jeffery_Kay, DemoUsers.Roland_Stevens}).andWorkDef((NamedId)AtsWorkDefinitionTokens.WorkDef_Team_Default);
        toolsTeamTeam.createChildTeamDef(toolsTeamTeam.getTeamDef(), DemoArtifactToken.Website_Team).andLeads(new UserToken[]{DemoUsers.Karmen_John}).andMembers(new UserToken[]{DemoUsers.Karmen_John, DemoUsers.Jeffery_Kay, DemoUsers.Roland_Stevens}).andWorkDef((NamedId)AtsWorkDefinitionTokens.WorkDef_Team_Simple);
        IAtsConfigTxActionableItem toolsTeamAI = topActionableItem.createChildActionableItem(DemoArtifactToken.Tools_Ai).andActionable(true).andTeamDef(DemoArtifactToken.Tools_Team);
        toolsTeamAI.createChildActionableItem(DemoArtifactToken.Reader_AI).andActionable(true);
        toolsTeamAI.createChildActionableItem("Results Reporter").andActionable(true);
        toolsTeamAI.createChildActionableItem(DemoArtifactToken.Timesheet_AI).andActionable(true);
        toolsTeamAI.createChildActionableItem("Website").andActionable(true).andTeamDef(DemoArtifactToken.Website_Team);
    }

    private void createSystemSafetyTeamConfig(IAtsConfigTx cfgTx, IAtsConfigTxTeamDef topTeam, IAtsConfigTxActionableItem topActionableItem) {
        topTeam.createChildTeamDef(topTeam.getTeamDef(), DemoArtifactToken.System_Safety_Team).andLeads(new UserToken[]{DemoUsers.Joe_Smith}).andMembers(new UserToken[]{DemoUsers.Jeffery_Kay}).andWorkDef((NamedId)AtsWorkDefinitionTokens.WorkDef_Team_Default);
        topActionableItem.createChildActionableItem(DemoArtifactToken.System_Safety_Ai).andTeamDef(DemoArtifactToken.System_Safety_Team).andActionable(true);
    }

    private void createProcessTeamConfig(IAtsConfigTx cfgTx, IAtsConfigTxTeamDef topTeam, IAtsConfigTxActionableItem topActionableItem) {
        topTeam.createChildTeamDef(topTeam.getTeamDef(), DemoArtifactToken.Process_Team).andLeads(new UserToken[]{DemoUsers.Alex_Kay}).andMembers(new UserToken[]{DemoUsers.Keith_Johnson, DemoUsers.Michael_Alex, DemoUsers.Janice_Michael, DemoUsers.Alex_Kay}).andWorkDef((NamedId)AtsWorkDefinitionTokens.WorkDef_Team_Default);
        IAtsConfigTxActionableItem processesAI = topActionableItem.createChildActionableItem("Processes").andActionable(false).andTeamDef(DemoArtifactToken.Process_Team);
        processesAI.createChildActionableItem("Coding Standards").andActionable(true);
        processesAI.createChildActionableItem("Config Mgmt").andActionable(true);
        processesAI.createChildActionableItem("New Employee Manual").andActionable(true);
        processesAI.createChildActionableItem("Reviews").andActionable(true);
    }

    private void createSawPlTeamConfig(IAtsConfigTx cfgTx, IAtsConfigTxTeamDef topTeam, IAtsConfigTxActionableItem topActionableItem) {
        IAtsConfigTxTeamDef sawPlTeam = topTeam.createChildTeamDef(topTeam.getTeamDef(), DemoArtifactToken.SAW_PL).andLeads(new UserToken[]{DemoUsers.Kay_Jason}).andMembers(new UserToken[]{DemoUsers.Kay_Jason, DemoUsers.Michael_John, DemoUsers.Steven_Kohn}).andWorkDef((NamedId)AtsWorkDefinitionTokens.WorkDef_Team_Default).andVersion(DemoArtifactToken.SAW_Product_Line, ReleasedOption.Released, DemoBranches.SAW_PL, NextRelease.None, new IOseeBranch[0]).andVersion(DemoArtifactToken.SAW_Hardening_Branch, ReleasedOption.UnReleased, DemoBranches.SAW_PL_Hardening_Branch, NextRelease.Next, new IOseeBranch[0]);
        sawPlTeam.createChildTeamDef(sawPlTeam.getTeamDef(), DemoArtifactToken.SAW_PL_Code).andLeads(new UserToken[]{DemoUsers.Joe_Smith}).andMembers(new UserToken[]{DemoUsers.Joe_Smith}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_Code).andTeamWorkflowArtifactType(DemoArtifactTypes.DemoCodeTeamWorkflow);
        sawPlTeam.createChildTeamDef(sawPlTeam.getTeamDef(), DemoArtifactToken.SAW_PL_HW).andLeads(new UserToken[]{DemoUsers.Jason_Michael}).andMembers(new UserToken[]{DemoUsers.Jason_Michael}).andWorkDef((NamedId)AtsWorkDefinitionTokens.WorkDef_Team_Default).andTeamWorkflowArtifactType(DemoArtifactTypes.DemoReqTeamWorkflow);
        sawPlTeam.createChildTeamDef(sawPlTeam.getTeamDef(), DemoArtifactToken.SAW_PL_Requirements).andLeads(new UserToken[]{DemoUsers.Joe_Smith}).andMembers(new UserToken[]{DemoUsers.Joe_Smith}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_Req).andTeamWorkflowArtifactType(DemoArtifactTypes.DemoReqTeamWorkflow);
        sawPlTeam.createChildTeamDef(sawPlTeam.getTeamDef(), DemoArtifactToken.SAW_PL_SW_Design).andLeads(new UserToken[]{DemoUsers.Kay_Jones}).andMembers(new UserToken[]{DemoUsers.Kay_Jones}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_SwDesign);
        sawPlTeam.createChildTeamDef(sawPlTeam.getTeamDef(), DemoArtifactToken.SAW_PL_Test).andLeads(new UserToken[]{DemoUsers.Kay_Jones}).andMembers(new UserToken[]{DemoUsers.Kay_Jones}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_Test).andTeamWorkflowArtifactType(DemoArtifactTypes.DemoTestTeamWorkflow);
        IAtsConfigTxActionableItem sawPlSwAI = topActionableItem.createChildActionableItem(DemoArtifactToken.SAW_PL_CSCI_AI).andActionable(false);
        sawPlSwAI.createChildActionableItem(DemoArtifactToken.SAW_PL_Code_AI).andTeamDef(DemoArtifactToken.SAW_PL_Code).andActionable(true).andChildAis(new String[]{"COMM", "MSM", "NAV", "Test Page"});
        sawPlSwAI.createChildActionableItem(DemoArtifactToken.SAW_PL_Requirements_AI).andTeamDef(DemoArtifactToken.SAW_PL_Requirements).andActionable(true).andChildAis(new String[]{"COMM", "MSM", "NAV"});
        sawPlSwAI.createChildActionableItem(DemoArtifactToken.SAW_PL_Test_AI).andTeamDef(DemoArtifactToken.SAW_PL_Test).andActionable(true).andChildAis(new String[]{"ADT", "COMM", "MSM", "NAV", "RulLists"});
        sawPlSwAI.createChildActionableItem(DemoArtifactToken.SAW_PL_SW_Design_AI).andActionable(true).andTeamDef(DemoArtifactToken.SAW_PL_SW_Design);
        sawPlSwAI.createChildActionableItem(DemoArtifactToken.SAW_PL_HW_AI).andTeamDef(DemoArtifactToken.SAW_PL_HW).andActionable(true).andChildAis(new String[]{"Adapter", "Case", "Manual", "Screen"});
        cfgTx.createProgram(DemoArtifactToken.SAW_PL_Program).andTeamDef(DemoArtifactToken.SAW_PL).and((AttributeTypeToken)AtsAttributeTypes.Description, (Object)"Program object for SAW PL Program").and((AttributeTypeToken)AtsAttributeTypes.Namespace, (Object)"org.demo.saw.pl");
    }

    private void createSawTeamConfig(IAtsConfigTx cfgTx, IAtsConfigTxTeamDef topTeam, IAtsConfigTxActionableItem topActionableItem) {
        IAtsConfigTxTeamDef sawSwTeam = topTeam.createChildTeamDef(topTeam.getTeamDef(), DemoArtifactToken.SAW_SW).and((AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)"saw.teamDefHoldingVersions").andLeads(new UserToken[]{DemoUsers.Kay_Jason}).andMembers(new UserToken[]{DemoUsers.Steven_Kohn, DemoUsers.Michael_John, DemoUsers.Kay_Jason}).andWorkDef((NamedId)AtsWorkDefinitionTokens.WorkDef_Team_Default).andVersion(DemoArtifactToken.SAW_Bld_1, ReleasedOption.Released, DemoBranches.SAW_Bld_1, NextRelease.None, new IOseeBranch[0]).andVersion(DemoArtifactToken.SAW_Bld_2, ReleasedOption.UnReleased, DemoBranches.SAW_Bld_2, NextRelease.Next, new IOseeBranch[0]).andVersion(DemoArtifactToken.SAW_Bld_3, ReleasedOption.UnReleased, DemoBranches.SAW_Bld_3, NextRelease.None, new IOseeBranch[0]);
        sawSwTeam.createChildTeamDef(sawSwTeam.getTeamDef(), DemoArtifactToken.SAW_Code).and((AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)"saw.code").andLeads(new UserToken[]{DemoUsers.Joe_Smith}).andMembers(new UserToken[]{DemoUsers.Joe_Smith}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_Code).andTeamWorkflowArtifactType(DemoArtifactTypes.DemoCodeTeamWorkflow);
        sawSwTeam.createChildTeamDef(sawSwTeam.getTeamDef(), DemoArtifactToken.SAW_HW).andLeads(new UserToken[]{DemoUsers.Jason_Michael}).andMembers(new UserToken[]{DemoUsers.Jason_Michael}).andWorkDef((NamedId)AtsWorkDefinitionTokens.WorkDef_Team_Default).andTeamWorkflowArtifactType(DemoArtifactTypes.DemoReqTeamWorkflow);
        sawSwTeam.createChildTeamDef(sawSwTeam.getTeamDef(), DemoArtifactToken.SAW_Test).and((AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)"saw.test").andLeads(new UserToken[]{DemoUsers.Kay_Jones}).andMembers(new UserToken[]{DemoUsers.Kay_Jones}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_Test).andTeamWorkflowArtifactType(DemoArtifactTypes.DemoTestTeamWorkflow);
        sawSwTeam.createChildTeamDef(sawSwTeam.getTeamDef(), DemoArtifactToken.SAW_SW_Design).and((AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)"saw.sw.design").andLeads(new UserToken[]{DemoUsers.Kay_Jones}).andMembers(new UserToken[]{DemoUsers.Kay_Jones}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_SwDesign).andRelatedPeerWorkflowDefinition(new NamedId[]{DemoWorkDefinitions.WorkDef_Review_Demo_Peer_SwDesign}).andRelatedTaskWorkflowDefinition(new NamedId[]{DemoWorkDefinitions.WorkDef_Task_Demo_SwDesign, AtsWorkDefinitionTokens.WorkDef_Task_Default}).andTaskSet(new AtsTaskDefToken[]{DemoTaskSetDefinitionTokens.SawSwDesignTestingChecklist, DemoTaskSetDefinitionTokens.SawSwDesignProcessChecklist});
        sawSwTeam.createChildTeamDef(sawSwTeam.getTeamDef(), DemoArtifactToken.SAW_Requirements).and((AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)"saw.reqirements").andLeads(new UserToken[]{DemoUsers.Joe_Smith}).andMembers(new UserToken[]{DemoUsers.Joe_Smith}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_Req).andTeamWorkflowArtifactType(DemoArtifactTypes.DemoReqTeamWorkflow);
        IAtsConfigTxActionableItem sawSwAI = topActionableItem.createChildActionableItem(DemoArtifactToken.SAW_CSCI_AI).andActionable(false);
        sawSwAI.createChildActionableItem(DemoArtifactToken.SAW_Code_AI).andTeamDef(DemoArtifactToken.SAW_Code).andActionable(true).andChildAis(new String[]{"COMM", "MSM", "NAV", "Test Page"});
        sawSwAI.createChildActionableItem(DemoArtifactToken.SAW_HW_AI).andTeamDef(DemoArtifactToken.SAW_HW).andChildAis(new IAtsActionableItemArtifactToken[]{DemoArtifactToken.Adapter_AI}).andActionable(true).andChildAis(new String[]{"Case", "Manual", "Screen"});
        sawSwAI.createChildActionableItem(DemoArtifactToken.SAW_Requirements_AI).andTeamDef(DemoArtifactToken.SAW_Requirements).andActionable(true).andChildAis(new String[]{"COMM", "MSM", "NAV"});
        sawSwAI.createChildActionableItem(DemoArtifactToken.SAW_Test_AI).andTeamDef(DemoArtifactToken.SAW_Test).andActionable(true).andChildAis(new String[]{"ADT", "COMM", "MSM", "NAV", "RunLists"});
        sawSwAI.createChildActionableItem(DemoArtifactToken.SAW_SW_Design_AI).andTeamDef(DemoArtifactToken.SAW_SW_Design).andActionable(true);
        cfgTx.createProgram(DemoArtifactToken.SAW_Program).andTeamDef(DemoArtifactToken.SAW_SW).and((AttributeTypeToken)AtsAttributeTypes.Description, (Object)"Program object for SAW Program").and((AttributeTypeToken)AtsAttributeTypes.Namespace, (Object)"org.demo.saw");
    }

    private void createCisTeamConfig(IAtsConfigTx cfgTx, IAtsConfigTxTeamDef topTeam, IAtsConfigTxActionableItem topActionableItem) {
        IAtsConfigTxTeamDef cisSwTeam = topTeam.createChildTeamDef(topTeam.getTeamDef(), DemoArtifactToken.CIS_SW).and((AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)"cis.teamDefHoldingVersions").andLeads(new UserToken[]{DemoUsers.Kay_Jason}).andMembers(new UserToken[]{DemoUsers.Steven_Kohn, DemoUsers.Michael_John, DemoUsers.Kay_Jason}).andWorkDef((NamedId)AtsWorkDefinitionTokens.WorkDef_Team_Default).andVersion("CIS Bld 1", ReleasedOption.Released, DemoBranches.CIS_Bld_1, NextRelease.None, new IOseeBranch[0]).andVersion("CIS Bld 2", ReleasedOption.UnReleased, null, NextRelease.Next, new IOseeBranch[0]).andVersion("CIS Bld 3", ReleasedOption.UnReleased, null, NextRelease.None, new IOseeBranch[0]);
        cisSwTeam.createChildTeamDef(cisSwTeam.getTeamDef(), DemoArtifactToken.CIS_Code).and((AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)"cis.code").andLeads(new UserToken[]{DemoUsers.Jason_Michael}).andMembers(new UserToken[]{DemoUsers.Jason_Michael}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_Code).andTeamWorkflowArtifactType(DemoArtifactTypes.DemoCodeTeamWorkflow);
        cisSwTeam.createChildTeamDef(cisSwTeam.getTeamDef(), DemoArtifactToken.CIS_Test).and((AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)"cis.test").andLeads(new UserToken[]{DemoUsers.Kay_Jones}).andMembers(new UserToken[]{DemoUsers.Kay_Jones}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_Test).andTeamWorkflowArtifactType(DemoArtifactTypes.DemoTestTeamWorkflow);
        cisSwTeam.createChildTeamDef("CIS SW Design").and((AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)"cis.sw.design").andLeads(new UserToken[]{DemoUsers.Kay_Jones}).andMembers(new UserToken[]{DemoUsers.Kay_Jones}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_SwDesign);
        cisSwTeam.createChildTeamDef("CIS Requirements").and((AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)"cis.reqirements").andLeads(new UserToken[]{DemoUsers.Joe_Smith}).andMembers(new UserToken[]{DemoUsers.Joe_Smith}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_Req).andTeamWorkflowArtifactType(DemoArtifactTypes.DemoReqTeamWorkflow);
        IAtsConfigTxActionableItem cisSwAI = topActionableItem.createChildActionableItem(DemoArtifactToken.CIS_CSCI).andActionable(false);
        cisSwAI.createChildActionableItem("CIS Code").andActionable(true).andTeamDef(DemoArtifactToken.CIS_Code);
        cisSwAI.createChildActionableItem("CIS Requirements").andActionable(true).andTeamDef("CIS Requirements");
        cisSwAI.createChildActionableItem(DemoArtifactToken.CIS_Test_AI).andActionable(true).andTeamDef(DemoArtifactToken.CIS_Test);
        cisSwAI.createChildActionableItem("CIS SW Design").andActionable(true).andTeamDef("CIS SW Design");
        cfgTx.createProgram(DemoArtifactToken.CIS_Program).andTeamDef(DemoArtifactToken.CIS_SW).and((AttributeTypeToken)AtsAttributeTypes.Description, (Object)"Program object for CIS Program").and((AttributeTypeToken)AtsAttributeTypes.Namespace, (Object)"org.demo.cis");
    }

    private void configureForParallelCommit() {
        IAtsChangeSet changes = this.atsApi.createChangeSet("configureForParallelCommit");
        IAtsVersion sawBld1Ver = this.atsApi.getVersionService().getById((ArtifactId)DemoArtifactToken.SAW_Bld_1);
        IAtsVersion sawBld2Ver = this.atsApi.getVersionService().getById((ArtifactId)DemoArtifactToken.SAW_Bld_2);
        IAtsVersion sawBld3Ver = this.atsApi.getVersionService().getById((ArtifactId)DemoArtifactToken.SAW_Bld_3);
        changes.relate((Object)sawBld1Ver, AtsRelationTypes.ParallelVersion_Child, (Object)sawBld2Ver);
        changes.relate((Object)sawBld2Ver, AtsRelationTypes.ParallelVersion_Child, (Object)sawBld1Ver);
        changes.relate((Object)sawBld2Ver, AtsRelationTypes.ParallelVersion_Child, (Object)sawBld3Ver);
        changes.execute();
    }
}

