/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.HttpHeaders;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsUserGroups;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.core.users.AbstractAtsUserService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.utility.RestUtil;

public class AtsUserServiceServerImpl
extends AbstractAtsUserService {
    private OrcsApi orcsApi;
    ArtifactReadable atsAdminArt;
    private Supplier<List<IAtsUser>> usersCache = Suppliers.memoizeWithExpiration(this.getConfigurationsSupplier(), (long)5L, (TimeUnit)TimeUnit.MINUTES);

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public String getCurrentUserId() {
        return SystemUser.OseeSystem.getUserId();
    }

    public boolean isAtsAdmin(IAtsUser user) {
        if (this.atsAdminArt == null) {
            this.atsAdminArt = this.getArtifact((ArtifactId)AtsUserGroups.AtsAdmin);
        }
        return this.atsAdminArt.areRelated(CoreRelationTypes.Users_User, this.getArtifact((IAtsObject)user));
    }

    private ArtifactReadable getArtifact(IAtsObject atsObject) {
        if (atsObject.getStoreObject() instanceof ArtifactReadable) {
            return (ArtifactReadable)atsObject.getStoreObject();
        }
        return this.getArtifact(atsObject.getArtifactId());
    }

    private ArtifactReadable getArtifact(ArtifactId artifactId) {
        return (ArtifactReadable)this.getQuery().andId(artifactId).getResults().getExactlyOne();
    }

    private ArtifactReadable getArtifactOrSentinel(ArtifactId artifactId) {
        return (ArtifactReadable)this.getQuery().andId(artifactId).getResults().getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
    }

    private QueryBuilder getQuery() {
        return this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON);
    }

    public boolean isAtsAdmin(boolean useCache) {
        throw new UnsupportedOperationException();
    }

    public boolean isAtsAdmin() {
        throw new UnsupportedOperationException();
    }

    private Supplier<List<IAtsUser>> getConfigurationsSupplier() {
        return new Supplier<List<IAtsUser>>(){

            public List<IAtsUser> get() {
                ArrayList<IAtsUser> users = new ArrayList<IAtsUser>();
                for (IAtsUser atsUser : AtsUserServiceServerImpl.this.getUsersFromDb()) {
                    AtsUserServiceServerImpl.this.userIdToAtsUser.put(atsUser.getUserId(), atsUser);
                    AtsUserServiceServerImpl.this.nameToAtsUser.put(atsUser.getName(), atsUser);
                    users.add(atsUser);
                }
                return users;
            }
        };
    }

    private AtsUser createFromArtifact(ArtifactReadable userArt) {
        AtsUser atsUser = new AtsUser();
        atsUser.setName(userArt.getName());
        atsUser.setStoreObject((ArtifactToken)userArt);
        atsUser.setUserId(userArt.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.UserId, ""));
        atsUser.setEmail(userArt.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Email, ""));
        atsUser.setActive(((Boolean)userArt.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Active, (Object)true)).booleanValue());
        atsUser.setId(userArt.getId());
        return atsUser;
    }

    public List<IAtsUser> getUsers() {
        return (List)this.usersCache.get();
    }

    public List<IAtsUser> getUsersFromDb() {
        ArrayList<IAtsUser> users = new ArrayList<IAtsUser>();
        for (ArtifactId art : this.getQuery().andTypeEquals(new ArtifactTypeId[]{CoreArtifactTypes.User}).getResults()) {
            ArtifactReadable userArt = (ArtifactReadable)art;
            AtsUser atsUser = this.createFromArtifact(userArt);
            users.add((IAtsUser)atsUser);
        }
        return users;
    }

    public void reloadCache() {
        this.usersCache = Suppliers.memoizeWithExpiration(this.getConfigurationsSupplier(), (long)5L, (TimeUnit)TimeUnit.MINUTES);
        super.reloadCache();
    }

    protected IAtsUser loadUserFromDbByUserId(String userId) {
        ArtifactReadable userArt = (ArtifactReadable)this.getQuery().andTypeEquals(new ArtifactTypeId[]{CoreArtifactTypes.User}).andAttributeIs((AttributeTypeId)CoreAttributeTypes.UserId, userId).getResults().getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (userArt.isValid()) {
            return this.createFromArtifact(userArt);
        }
        return null;
    }

    protected IAtsUser loadUserFromDbByUserName(String name) {
        ArtifactReadable userArt = (ArtifactReadable)this.getQuery().andTypeEquals(new ArtifactTypeId[]{CoreArtifactTypes.User}).andNameEquals(name).getResults().getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (userArt.isValid()) {
            return this.createFromArtifact(userArt);
        }
        return null;
    }

    protected IAtsUser loadUserByAccountId(Long accountId) {
        AtsUser user = null;
        ArtifactReadable userArt = this.getArtifactOrSentinel(ArtifactId.valueOf((Long)accountId));
        if (userArt.isValid()) {
            user = this.createFromArtifact(userArt);
        }
        return user;
    }

    public IAtsUser getUserByArtifactId(ArtifactId id) {
        ArtifactReadable userArt = (ArtifactReadable)this.getQuery().andId(id).getResults().getExactlyOne();
        return this.createFromArtifact(userArt);
    }

    public IAtsUser getUserByAccountId(HttpHeaders httpHeaders) {
        IAtsUser user = null;
        String accountId = RestUtil.getAccountId((HttpHeaders)httpHeaders);
        if (Strings.isInValid((String)accountId)) {
            return null;
        }
        IAtsUser userById = this.getUserByAccountId(Long.valueOf(accountId));
        if (userById != null) {
            user = userById;
        }
        return user;
    }
}

