/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.agile.operations;

import java.util.Date;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.agile.sprint.SprintConfigurations;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.core.agile.AgileUtil;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class SprintConfigOperations {
    private final AtsApi atsApi;

    public SprintConfigOperations(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public SprintConfigurations get(ArtifactId sprintId) {
        Date endDate;
        IAgileSprint sprint = this.atsApi.getAgileService().getAgileSprint(sprintId.getId().longValue());
        SprintConfigurations configs = new SprintConfigurations();
        configs.setId(sprintId);
        Date startDate = (Date)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)sprint, (AttributeTypeToken)AtsAttributeTypes.StartDate, null);
        if (startDate != null) {
            configs.setStartDate(DateUtil.get((Date)startDate, (String)"yyyy-MM-dd"));
        }
        if ((endDate = (Date)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)sprint, (AttributeTypeToken)AtsAttributeTypes.EndDate, null)) != null) {
            configs.setEndDate(DateUtil.get((Date)endDate, (String)"yyyy-MM-dd"));
        }
        configs.setPlannedPoints(((Integer)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)sprint, (AttributeTypeToken)AtsAttributeTypes.PlannedPoints, (Object)0)).toString());
        configs.setUnPlannedPoints(((Integer)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)sprint, (AttributeTypeToken)AtsAttributeTypes.UnplannedPoints, (Object)0)).toString());
        for (Object holiday : this.atsApi.getAttributeResolver().getAttributeValues((IAtsObject)sprint, (AttributeTypeToken)AtsAttributeTypes.Holiday)) {
            if (!(holiday instanceof Date)) continue;
            configs.addHoliday(AgileUtil.getDateStr((Date)((Date)holiday)));
        }
        return configs;
    }

    public SprintConfigurations update(SprintConfigurations sprintConfig) {
        IAgileSprint sprint = this.atsApi.getAgileService().getAgileSprint(sprintConfig.getId());
        if (sprint == null) {
            sprintConfig.getResults().errorf("No sprint found with id %s", new Object[]{sprintConfig.getId()});
            return sprintConfig;
        }
        IAtsChangeSet changes = this.atsApi.createChangeSet("Update Sprint Configurations for " + sprint.toStringWithId());
        this.updateDateIfNecessary(sprintConfig.getStartDate(), sprintConfig, sprint, (AttributeTypeToken)AtsAttributeTypes.StartDate, changes);
        if (sprintConfig.getResults().isErrors()) {
            return sprintConfig;
        }
        this.updateDateIfNecessary(sprintConfig.getEndDate(), sprintConfig, sprint, (AttributeTypeToken)AtsAttributeTypes.EndDate, changes);
        if (sprintConfig.getResults().isErrors()) {
            return sprintConfig;
        }
        this.updatePointsIfNecessary(sprintConfig.getPlannedPoints(), sprintConfig, sprint, (AttributeTypeToken)AtsAttributeTypes.PlannedPoints, changes);
        if (sprintConfig.getResults().isErrors()) {
            return sprintConfig;
        }
        this.updatePointsIfNecessary(sprintConfig.getUnPlannedPoints(), sprintConfig, sprint, (AttributeTypeToken)AtsAttributeTypes.UnplannedPoints, changes);
        if (sprintConfig.getResults().isErrors()) {
            return sprintConfig;
        }
        TransactionId transaction = changes.executeIfNeeded();
        if (transaction == null) {
            sprintConfig.getResults().error("No changes made");
        }
        return sprintConfig;
    }

    private void updatePointsIfNecessary(String newPointsStr, SprintConfigurations sprintConfig, IAgileSprint sprint, AttributeTypeToken attrType, IAtsChangeSet changes) {
        if (Strings.isValid((String)newPointsStr)) {
            try {
                if (Strings.isInValid((String)newPointsStr)) {
                    changes.deleteAttributes((IAtsObject)sprint, (AttributeTypeId)attrType);
                } else if (Strings.isInValid((String)newPointsStr)) {
                    changes.deleteAttributes((IAtsObject)sprint, (AttributeTypeId)attrType);
                } else {
                    Integer storedPoints = (Integer)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)sprint, attrType, (Object)0);
                    Integer newPoints = Integer.valueOf(newPointsStr);
                    if (!newPoints.equals(storedPoints)) {
                        changes.setSoleAttributeValue((IAtsObject)sprint, attrType, (Object)newPoints);
                    }
                }
            }
            catch (Exception exception) {
                sprintConfig.getResults().errorf("Invalid %s [%s], must be [%s]", new Object[]{attrType.getName(), newPointsStr, "yyyy-MM-dd"});
            }
        }
    }

    private void updateDateIfNecessary(String newDateStr, SprintConfigurations sprintConfig, IAgileSprint sprint, AttributeTypeToken attrType, IAtsChangeSet changes) {
        if (Strings.isValid((String)newDateStr)) {
            try {
                if (Strings.isInValid((String)newDateStr)) {
                    changes.deleteAttributes((IAtsObject)sprint, (AttributeTypeId)attrType);
                } else {
                    Date storedDate = (Date)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)sprint, attrType, null);
                    Date newStartDate = DateUtil.getDate((String)"yyyy-MM-dd", (String)newDateStr);
                    if (!newStartDate.equals(storedDate)) {
                        changes.setSoleAttributeValue((IAtsObject)sprint, attrType, (Object)newStartDate);
                    }
                }
            }
            catch (Exception exception) {
                sprintConfig.getResults().errorf("Invalid %s [%s], must be [%s]", new Object[]{attrType.getName(), newDateStr, "yyyy-MM-dd"});
            }
        }
    }
}

