/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal;

import com.fasterxml.jackson.core.JsonFactory;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.eclipse.osee.ats.rest.IAtsServer;
import org.eclipse.osee.ats.rest.internal.agile.AgileEndpointImpl;
import org.eclipse.osee.ats.rest.internal.agile.operations.SprintDataUiOperation;
import org.eclipse.osee.ats.rest.internal.agile.operations.SprintSummaryOperation;
import org.eclipse.osee.ats.rest.internal.config.ActionableItemResource;
import org.eclipse.osee.ats.rest.internal.config.AtsConfigEndpointImpl;
import org.eclipse.osee.ats.rest.internal.config.ConvertAtsConfigGuidAttributes;
import org.eclipse.osee.ats.rest.internal.config.ConvertCreateUpdateAtsConfig;
import org.eclipse.osee.ats.rest.internal.config.ConvertResource;
import org.eclipse.osee.ats.rest.internal.config.CountryEndpointImpl;
import org.eclipse.osee.ats.rest.internal.config.CountryResource;
import org.eclipse.osee.ats.rest.internal.config.InsertionActivityEndpointImpl;
import org.eclipse.osee.ats.rest.internal.config.InsertionActivityResource;
import org.eclipse.osee.ats.rest.internal.config.InsertionEndpointImpl;
import org.eclipse.osee.ats.rest.internal.config.InsertionResource;
import org.eclipse.osee.ats.rest.internal.config.ProgramEndpointImpl;
import org.eclipse.osee.ats.rest.internal.config.ProgramResource;
import org.eclipse.osee.ats.rest.internal.config.ReportResource;
import org.eclipse.osee.ats.rest.internal.config.TeamResource;
import org.eclipse.osee.ats.rest.internal.config.UserResource;
import org.eclipse.osee.ats.rest.internal.config.VersionResource;
import org.eclipse.osee.ats.rest.internal.cpa.CpaResource;
import org.eclipse.osee.ats.rest.internal.cpa.CpaServiceRegistry;
import org.eclipse.osee.ats.rest.internal.notify.AtsNotifyEndpointImpl;
import org.eclipse.osee.ats.rest.internal.util.health.AtsHealthEndpointImpl;
import org.eclipse.osee.ats.rest.internal.workitem.ActionUiResource;
import org.eclipse.osee.ats.rest.internal.workitem.AtsActionEndpointImpl;
import org.eclipse.osee.ats.rest.internal.workitem.AtsAttributeEndpointImpl;
import org.eclipse.osee.ats.rest.internal.workitem.AtsTaskEndpointImpl;
import org.eclipse.osee.ats.rest.internal.workitem.AtsTeamWfEndpointImpl;
import org.eclipse.osee.ats.rest.internal.workitem.AtsWorkPackageEndpointImpl;
import org.eclipse.osee.ats.rest.internal.workitem.StateResource;
import org.eclipse.osee.ats.rest.internal.workitem.operations.ConvertWorkDefinitionToAttributes;
import org.eclipse.osee.ats.rest.internal.workitem.operations.FixWorkDefinitionToAttributeConversion;
import org.eclipse.osee.ats.rest.internal.workitem.workdef.AtsWorkDefEndpointImpl;
import org.eclipse.osee.ats.rest.internal.world.WorldResource;
import org.eclipse.osee.framework.core.executor.ExecutorAdmin;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.type.IResourceRegistry;
import org.eclipse.osee.framework.jdk.core.type.ResourceRegistry;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.template.engine.OseeTemplateTokens;

@ApplicationPath(value="ats")
public class AtsApplication
extends Application {
    private final Set<Object> singletons = new HashSet<Object>();
    private Log logger;
    private static OrcsApi orcsApi;
    private IAtsServer atsServer;
    private CpaServiceRegistry cpaRegistry;
    private JdbcService jdbcService;
    private ExecutorAdmin executorAdmin;

    public void setExecutorAdmin(ExecutorAdmin executorAdmin) {
        this.executorAdmin = executorAdmin;
    }

    public void setOrcsApi(OrcsApi orcsApi) {
        AtsApplication.orcsApi = orcsApi;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setAtsServer(IAtsServer atsServer) {
        this.atsServer = atsServer;
    }

    public void setJdbcService(JdbcService jdbcService) {
        this.jdbcService = jdbcService;
    }

    public void setCpaServiceRegistry(CpaServiceRegistry cpaRegistry) {
        this.cpaRegistry = cpaRegistry;
    }

    public void start() {
        ResourceRegistry registry = new ResourceRegistry();
        OseeTemplateTokens.register((IResourceRegistry)registry);
        JsonFactory jsonFactory = JsonUtil.getFactory();
        ConvertCreateUpdateAtsConfig atsConfgConversion = new ConvertCreateUpdateAtsConfig(orcsApi);
        this.atsServer.addAtsDatabaseConversion(atsConfgConversion);
        this.atsServer.addAtsDatabaseConversion(new ConvertAtsConfigGuidAttributes());
        this.atsServer.addAtsDatabaseConversion(new ConvertWorkDefinitionToAttributes());
        this.atsServer.addAtsDatabaseConversion(new FixWorkDefinitionToAttributeConversion());
        this.atsServer.getAgileSprintHtmlReportOperations().add(new SprintSummaryOperation(this.atsServer, (IResourceRegistry)registry));
        this.atsServer.getAgileSprintHtmlReportOperations().add(new SprintDataUiOperation(this.atsServer, (IResourceRegistry)registry));
        this.singletons.add(new VersionResource(this.atsServer, orcsApi));
        this.singletons.add(new TeamResource(this.atsServer, orcsApi));
        this.singletons.add(new ActionableItemResource(this.atsServer, orcsApi));
        this.singletons.add(new CountryResource(this.atsServer, orcsApi));
        this.singletons.add(new ProgramResource(this.atsServer, orcsApi));
        this.singletons.add(new InsertionResource(this.atsServer, orcsApi));
        this.singletons.add(new InsertionActivityResource(this.atsServer, orcsApi));
        this.singletons.add(new AtsActionEndpointImpl(this.atsServer, orcsApi, jsonFactory));
        this.singletons.add(new StateResource(this.atsServer));
        this.singletons.add(new ConvertResource(this.atsServer));
        this.singletons.add(new CpaResource(orcsApi, this.atsServer, this.cpaRegistry));
        this.singletons.add(new UserResource(this.atsServer.getUserService()));
        this.singletons.add(new WorldResource(this.atsServer));
        this.singletons.add(new AtsHealthEndpointImpl(this.atsServer, this.jdbcService));
        this.singletons.add(new AtsWorkDefEndpointImpl(this.atsServer, orcsApi));
        this.singletons.add(new AgileEndpointImpl(this.atsServer, (IResourceRegistry)registry, this.jdbcService, orcsApi));
        this.singletons.add(new CountryEndpointImpl(this.atsServer));
        this.singletons.add(new ProgramEndpointImpl(this.atsServer));
        this.singletons.add(new InsertionEndpointImpl(this.atsServer));
        this.singletons.add(new InsertionActivityEndpointImpl(this.atsServer));
        this.singletons.add(new AtsConfigEndpointImpl(this.atsServer, orcsApi, this.logger, this.executorAdmin));
        this.singletons.add(new AtsTaskEndpointImpl(this.atsServer, orcsApi));
        this.singletons.add(new AtsNotifyEndpointImpl(this.atsServer));
        this.singletons.add(new AtsWorkPackageEndpointImpl(this.atsServer, this.logger));
        this.singletons.add(new AtsTeamWfEndpointImpl(this.atsServer));
        this.singletons.add(new AtsAttributeEndpointImpl(this.atsServer, orcsApi));
        this.singletons.add(new ActionUiResource(this.atsServer, this.logger));
        this.singletons.add(new ReportResource(orcsApi, this.atsServer));
        this.logger.warn("ATS Application Started - %s", new Object[]{System.getProperty("OseeApplicationServer")});
    }

    public void stop() {
        this.singletons.clear();
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }

    public static OrcsApi getOrcsApi() {
        return orcsApi;
    }
}

