/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.account.admin.internal;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import org.eclipse.osee.account.admin.Account;
import org.eclipse.osee.account.admin.AccountPreferences;
import org.eclipse.osee.account.admin.AccountSession;
import org.eclipse.osee.account.admin.CreateAccountRequest;
import org.eclipse.osee.account.admin.ds.AccountStorage;
import org.eclipse.osee.account.rest.model.AccountWebPreferences;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.orcs.account.admin.internal.AbstractOrcsStorage;
import org.eclipse.osee.orcs.account.admin.internal.AccountSessionDatabaseStore;
import org.eclipse.osee.orcs.account.admin.internal.AccountSessionStorage;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class OrcsAccountStorage
extends AbstractOrcsStorage
implements AccountStorage {
    private JdbcService jdbcService;
    private AccountSessionStorage sessionStore;
    private final Account bootstrapAccount = null;
    private final Supplier<ResultSet<Account>> anonymousAccountSupplier = Suppliers.memoize(this.getAnonymousSupplier());

    public void setJdbcService(JdbcService jdbcService) {
        this.jdbcService = jdbcService;
    }

    @Override
    public void start() {
        super.start();
        JdbcClient jdbcClient = this.jdbcService.getClient();
        this.sessionStore = new AccountSessionDatabaseStore(this.getLogger(), jdbcClient, this.getFactory());
    }

    @Override
    public void stop() {
        super.stop();
        this.sessionStore = null;
    }

    public boolean userNameExists(String username) {
        return this.newQuery().andTypeEquals(new ArtifactTypeId[]{CoreArtifactTypes.User}).andAttributeIs((AttributeTypeId)CoreAttributeTypes.UserId, username).exists();
    }

    public boolean emailExists(String email) {
        return this.newQuery().andTypeEquals(new ArtifactTypeId[]{CoreArtifactTypes.User}).andAttributeIs((AttributeTypeId)CoreAttributeTypes.Email, email).exists();
    }

    public boolean displayNameExists(String displayName) {
        return this.newQuery().andTypeEquals(new ArtifactTypeId[]{CoreArtifactTypes.User}).andNameEquals(displayName).exists();
    }

    public ResultSet<Account> getAllAccounts() {
        ResultSet results = this.newQuery().andTypeEquals(new ArtifactTypeId[]{CoreArtifactTypes.User}).getResults();
        return this.getFactory().newAccountResultSet((ResultSet<ArtifactReadable>)results);
    }

    public ResultSet<Account> getAccountById(ArtifactId accountId) {
        ResultSet results = this.newQuery().andTypeEquals(new ArtifactTypeId[]{CoreArtifactTypes.User}).andUuid(accountId.getUuid().longValue()).getResults();
        return this.getFactory().newAccountResultSet((ResultSet<ArtifactReadable>)results);
    }

    public ResultSet<Account> getAccountByEmail(String email) {
        ResultSet results = this.newQuery().andTypeEquals(new ArtifactTypeId[]{CoreArtifactTypes.User}).andAttributeIs((AttributeTypeId)CoreAttributeTypes.Email, email).getResults();
        return this.getFactory().newAccountResultSet((ResultSet<ArtifactReadable>)results);
    }

    public AccountPreferences getAccountPreferencesById(ArtifactId accountId) {
        ArtifactReadable artifact = this.newQuery().andTypeEquals(new ArtifactTypeId[]{CoreArtifactTypes.User}).andId(accountId).getArtifact();
        return this.getFactory().newAccountPreferences(artifact);
    }

    public ArtifactId createAccount(CreateAccountRequest request) {
        TransactionBuilder tx = this.newTransaction("Create Account");
        ArtifactToken artId = tx.createArtifact(CoreArtifactTypes.User, request.getDisplayName());
        tx.setSoleAttributeFromString((ArtifactId)artId, (AttributeTypeToken)CoreAttributeTypes.Email, request.getEmail());
        tx.setSoleAttributeFromString((ArtifactId)artId, (AttributeTypeToken)CoreAttributeTypes.UserId, request.getUserName());
        tx.setSoleAttributeValue((ArtifactId)artId, (AttributeTypeToken)CoreAttributeTypes.Active, (Object)request.isActive());
        Map preferences = request.getPreferences();
        if (preferences != null && !preferences.isEmpty()) {
            String prefValue = this.asString((ArtifactId)artId, preferences);
            tx.createAttribute((ArtifactId)artId, (AttributeTypeToken)CoreAttributeTypes.UserSettings, (Object)prefValue);
        }
        tx.commit();
        return artId;
    }

    public void setActive(ArtifactId accountId, boolean active) {
        TransactionBuilder tx = this.newTransaction("Update Account Active");
        tx.setSoleAttributeValue(accountId, (AttributeTypeToken)CoreAttributeTypes.Active, (Object)active);
        tx.commit();
    }

    private String asString(ArtifactId artId, Map<String, String> preferences) {
        PropertyStore settings = new PropertyStore(artId.getIdString());
        for (Map.Entry<String, String> entry : preferences.entrySet()) {
            settings.put(entry.getKey(), entry.getValue());
        }
        StringWriter stringWriter = new StringWriter();
        try {
            settings.save((Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public void setAccountPreferences(ArtifactId accountId, Map<String, String> preferences) {
        String prefValue = this.asString(accountId, preferences);
        TransactionBuilder tx = this.newTransaction("User - Save Settings");
        tx.setSoleAttributeFromString(accountId, (AttributeTypeToken)CoreAttributeTypes.UserSettings, prefValue);
        tx.commit();
    }

    public void deleteAccount(ArtifactId accountId) {
        TransactionBuilder tx = this.newTransaction("Delete User");
        tx.deleteArtifact(accountId);
        tx.commit();
    }

    public ResultSet<AccountSession> getAccountSessionById(ArtifactId accountId) {
        try {
            return this.sessionStore.getAccountSessionByAccountId(accountId).call();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public ResultSet<AccountSession> getAccountSessionBySessionToken(String sessionToken) {
        try {
            return this.sessionStore.getAccountSessionBySessionToken(sessionToken).call();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public AccountSession createAccountSession(String sessionToken, Account account, String remoteAddress, String accessDetails) {
        ArtifactId artId = ArtifactId.valueOf((Long)account.getId());
        AccountSession session = this.getFactory().newAccountSession(artId, sessionToken, remoteAddress, accessDetails);
        try {
            this.sessionStore.createAccountSession(Collections.singleton(session)).call();
            return session;
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public void deleteAccountSessionBySessionToken(String sessionToken) {
        try {
            this.sessionStore.deleteAccountSessionBySessionToken(sessionToken).call();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public ResultSet<Account> getAnonymousAccount() {
        ResultSet toReturn = this.isInitialized() ? (ResultSet)this.anonymousAccountSupplier.get() : ResultSets.singleton((Object)this.bootstrapAccount);
        return toReturn;
    }

    private Supplier<ResultSet<Account>> getAnonymousSupplier() {
        return new Supplier<ResultSet<Account>>(){

            public ResultSet<Account> get() {
                ResultSet results = OrcsAccountStorage.this.newQuery().andTypeEquals(new ArtifactTypeId[]{CoreArtifactTypes.User}).andUuid(SystemUser.Anonymous.getUuid().longValue()).getResults();
                return OrcsAccountStorage.this.getFactory().newAccountResultSet((ResultSet<ArtifactReadable>)results);
            }
        };
    }

    public void setAccountWebPreferences(ArtifactId artifactId, String preferences) {
        TransactionBuilder tx = this.newTransaction("User - Save Web Preferences");
        tx.setSoleAttributeFromString(artifactId, (AttributeTypeToken)CoreAttributeTypes.WebPreferences, preferences);
        tx.commit();
    }

    public AccountWebPreferences getAccountWebPreferencesById(ArtifactId accountId) {
        ResultSet results = this.newQuery().andTypeEquals(new ArtifactTypeId[]{CoreArtifactTypes.User}).andUuid(accountId.getUuid().longValue()).getResults();
        return this.getFactory().newAccountWebPreferences((ArtifactReadable)results.getExactlyOne());
    }

    public ResultSet<Account> getAccountByName(String name) {
        ResultSet results = this.newQuery().andTypeEquals(new ArtifactTypeId[]{CoreArtifactTypes.User}).andAttributeIs((AttributeTypeId)CoreAttributeTypes.UserId, name).getResults();
        return this.getFactory().newAccountResultSet((ResultSet<ArtifactReadable>)results);
    }
}

