/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal;

import java.net.URI;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.eclipse.osee.disposition.rest.internal.OrcsStorageImpl;
import org.eclipse.osee.disposition.rest.internal.Storage;
import org.eclipse.osee.disposition.rest.internal.StorageProvider;
import org.eclipse.osee.framework.core.util.OseeInf;
import org.eclipse.osee.framework.jdk.core.type.LazyObject;
import org.eclipse.osee.framework.resource.management.IResource;
import org.eclipse.osee.framework.resource.management.util.Resource;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;

public class StorageProviderImpl
extends LazyObject<Storage>
implements StorageProvider {
    private static final String DISPOSITION_TYPE_DEFINITIONS = "orcsTypes/OseeTypes_Dispo.osee";
    private Log logger;
    private OrcsApi orcsApi;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public void start() {
        this.logger.trace("Starting StorageProviderImpl...", new Object[0]);
    }

    public void stop() {
        this.logger.trace("Stopping StorageProviderImpl...", new Object[0]);
        this.invalidate();
    }

    protected FutureTask<Storage> createLoaderTask() {
        Callable<Storage> callable = new Callable<Storage>(){

            @Override
            public Storage call() throws Exception {
                return StorageProviderImpl.this.createStorage();
            }
        };
        return new FutureTask<Storage>(callable);
    }

    private Storage createStorage() throws Exception {
        OrcsStorageImpl storage = new OrcsStorageImpl(this.logger, this.orcsApi);
        if (!storage.typesExist()) {
            URL resource = OseeInf.getResourceAsUrl((String)DISPOSITION_TYPE_DEFINITIONS, this.getClass());
            URI uri = resource.toURI();
            Resource typesResource = new Resource(uri, false);
            storage.storeTypes((IResource)typesResource);
        }
        return storage;
    }
}

