/*******************************************************************************
 * Copyright (c) 2013 Boeing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Boeing - initial API and implementation
 *******************************************************************************/
package org.eclipse.osee.ats.api.workflow;

import java.util.List;
import org.eclipse.osee.ats.api.user.IAtsUser;

/**
 * @author Donald G. Dunne
 */
public interface WorkState {

   void setHoursSpent(double hoursSpent);

   void setPercentComplete(int percentComplete);

   String getName();

   List<IAtsUser> getAssignees();

   double getHoursSpent();

   int getPercentComplete();

   void addAssignee(IAtsUser steve);

   void setAssignees(List<? extends IAtsUser> users);

   void setName(String name);

   void removeAssignee(IAtsUser assignee);

}
