/*
 * generated by Xtext
 */
package org.eclipse.osee.framework.core.dsl.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.osee.framework.core.dsl.oseeDsl.AccessContext;
import org.eclipse.osee.framework.core.dsl.oseeDsl.AddAttribute;
import org.eclipse.osee.framework.core.dsl.oseeDsl.AddEnum;
import org.eclipse.osee.framework.core.dsl.oseeDsl.ArtifactMatchRestriction;
import org.eclipse.osee.framework.core.dsl.oseeDsl.ArtifactTypeRestriction;
import org.eclipse.osee.framework.core.dsl.oseeDsl.AttributeTypeRestriction;
import org.eclipse.osee.framework.core.dsl.oseeDsl.CompoundCondition;
import org.eclipse.osee.framework.core.dsl.oseeDsl.HierarchyRestriction;
import org.eclipse.osee.framework.core.dsl.oseeDsl.Import;
import org.eclipse.osee.framework.core.dsl.oseeDsl.LegacyRelationTypeRestriction;
import org.eclipse.osee.framework.core.dsl.oseeDsl.OseeDsl;
import org.eclipse.osee.framework.core.dsl.oseeDsl.OseeDslPackage;
import org.eclipse.osee.framework.core.dsl.oseeDsl.ReferencedContext;
import org.eclipse.osee.framework.core.dsl.oseeDsl.RelationTypeArtifactPredicate;
import org.eclipse.osee.framework.core.dsl.oseeDsl.RelationTypeArtifactTypePredicate;
import org.eclipse.osee.framework.core.dsl.oseeDsl.RelationTypeRestriction;
import org.eclipse.osee.framework.core.dsl.oseeDsl.RemoveAttribute;
import org.eclipse.osee.framework.core.dsl.oseeDsl.RemoveEnum;
import org.eclipse.osee.framework.core.dsl.oseeDsl.Role;
import org.eclipse.osee.framework.core.dsl.oseeDsl.SimpleCondition;
import org.eclipse.osee.framework.core.dsl.oseeDsl.UpdateAttribute;
import org.eclipse.osee.framework.core.dsl.oseeDsl.UsersAndGroups;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XArtifactMatcher;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XArtifactType;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XAttributeType;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XAttributeTypeRef;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XOseeArtifactTypeOverride;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XOseeEnumEntry;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XOseeEnumOverride;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XOseeEnumType;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XRelationType;
import org.eclipse.osee.framework.core.dsl.services.OseeDslGrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class OseeDslSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private OseeDslGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == OseeDslPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case OseeDslPackage.ACCESS_CONTEXT:
				sequence_AccessContext(context, (AccessContext) semanticObject); 
				return; 
			case OseeDslPackage.ADD_ATTRIBUTE:
				sequence_AddAttribute(context, (AddAttribute) semanticObject); 
				return; 
			case OseeDslPackage.ADD_ENUM:
				sequence_AddEnum(context, (AddEnum) semanticObject); 
				return; 
			case OseeDslPackage.ARTIFACT_MATCH_RESTRICTION:
				sequence_ArtifactMatchRestriction(context, (ArtifactMatchRestriction) semanticObject); 
				return; 
			case OseeDslPackage.ARTIFACT_TYPE_RESTRICTION:
				sequence_ArtifactTypeRestriction(context, (ArtifactTypeRestriction) semanticObject); 
				return; 
			case OseeDslPackage.ATTRIBUTE_TYPE_RESTRICTION:
				sequence_AttributeTypeRestriction(context, (AttributeTypeRestriction) semanticObject); 
				return; 
			case OseeDslPackage.COMPOUND_CONDITION:
				sequence_CompoundCondition(context, (CompoundCondition) semanticObject); 
				return; 
			case OseeDslPackage.HIERARCHY_RESTRICTION:
				sequence_HierarchyRestriction(context, (HierarchyRestriction) semanticObject); 
				return; 
			case OseeDslPackage.IMPORT:
				sequence_Import(context, (Import) semanticObject); 
				return; 
			case OseeDslPackage.LEGACY_RELATION_TYPE_RESTRICTION:
				sequence_LegacyRelationTypeRestriction(context, (LegacyRelationTypeRestriction) semanticObject); 
				return; 
			case OseeDslPackage.OSEE_DSL:
				sequence_OseeDsl(context, (OseeDsl) semanticObject); 
				return; 
			case OseeDslPackage.REFERENCED_CONTEXT:
				sequence_ReferencedContext(context, (ReferencedContext) semanticObject); 
				return; 
			case OseeDslPackage.RELATION_TYPE_ARTIFACT_PREDICATE:
				sequence_RelationTypeArtifactPredicate(context, (RelationTypeArtifactPredicate) semanticObject); 
				return; 
			case OseeDslPackage.RELATION_TYPE_ARTIFACT_TYPE_PREDICATE:
				sequence_RelationTypeArtifactTypePredicate(context, (RelationTypeArtifactTypePredicate) semanticObject); 
				return; 
			case OseeDslPackage.RELATION_TYPE_RESTRICTION:
				sequence_RelationTypeRestriction(context, (RelationTypeRestriction) semanticObject); 
				return; 
			case OseeDslPackage.REMOVE_ATTRIBUTE:
				sequence_RemoveAttribute(context, (RemoveAttribute) semanticObject); 
				return; 
			case OseeDslPackage.REMOVE_ENUM:
				sequence_RemoveEnum(context, (RemoveEnum) semanticObject); 
				return; 
			case OseeDslPackage.ROLE:
				sequence_Role(context, (Role) semanticObject); 
				return; 
			case OseeDslPackage.SIMPLE_CONDITION:
				sequence_SimpleCondition(context, (SimpleCondition) semanticObject); 
				return; 
			case OseeDslPackage.UPDATE_ATTRIBUTE:
				sequence_UpdateAttribute(context, (UpdateAttribute) semanticObject); 
				return; 
			case OseeDslPackage.USERS_AND_GROUPS:
				sequence_UsersAndGroups(context, (UsersAndGroups) semanticObject); 
				return; 
			case OseeDslPackage.XARTIFACT_MATCHER:
				sequence_XArtifactMatcher(context, (XArtifactMatcher) semanticObject); 
				return; 
			case OseeDslPackage.XARTIFACT_TYPE:
				sequence_XArtifactType(context, (XArtifactType) semanticObject); 
				return; 
			case OseeDslPackage.XATTRIBUTE_TYPE:
				sequence_XAttributeType(context, (XAttributeType) semanticObject); 
				return; 
			case OseeDslPackage.XATTRIBUTE_TYPE_REF:
				sequence_XAttributeTypeRef(context, (XAttributeTypeRef) semanticObject); 
				return; 
			case OseeDslPackage.XOSEE_ARTIFACT_TYPE_OVERRIDE:
				sequence_XOseeArtifactTypeOverride(context, (XOseeArtifactTypeOverride) semanticObject); 
				return; 
			case OseeDslPackage.XOSEE_ENUM_ENTRY:
				sequence_XOseeEnumEntry(context, (XOseeEnumEntry) semanticObject); 
				return; 
			case OseeDslPackage.XOSEE_ENUM_OVERRIDE:
				sequence_XOseeEnumOverride(context, (XOseeEnumOverride) semanticObject); 
				return; 
			case OseeDslPackage.XOSEE_ENUM_TYPE:
				sequence_XOseeEnumType(context, (XOseeEnumType) semanticObject); 
				return; 
			case OseeDslPackage.XRELATION_TYPE:
				sequence_XRelationType(context, (XRelationType) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Contexts:
	 *     AccessContext returns AccessContext
	 *
	 * Constraint:
	 *     (
	 *         name=STRING 
	 *         superAccessContexts+=[AccessContext|STRING]? 
	 *         id=WHOLE_NUM_STR 
	 *         (accessRules+=ObjectRestriction | hierarchyRestrictions+=HierarchyRestriction)+
	 *     )
	 */
	protected void sequence_AccessContext(ISerializationContext context, AccessContext semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AttributeOverrideOption returns AddAttribute
	 *     AddAttribute returns AddAttribute
	 *
	 * Constraint:
	 *     attribute=XAttributeTypeRef
	 */
	protected void sequence_AddAttribute(ISerializationContext context, AddAttribute semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, OseeDslPackage.Literals.ADD_ATTRIBUTE__ATTRIBUTE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OseeDslPackage.Literals.ADD_ATTRIBUTE__ATTRIBUTE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getAddAttributeAccess().getAttributeXAttributeTypeRefParserRuleCall_1_0(), semanticObject.getAttribute());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     OverrideOption returns AddEnum
	 *     AddEnum returns AddEnum
	 *
	 * Constraint:
	 *     (enumEntry=STRING ordinal=WHOLE_NUM_STR? description=STRING?)
	 */
	protected void sequence_AddEnum(ISerializationContext context, AddEnum semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ObjectRestriction returns ArtifactMatchRestriction
	 *     ArtifactMatchRestriction returns ArtifactMatchRestriction
	 *
	 * Constraint:
	 *     (permission=AccessPermissionEnum artifactMatcherRef=[XArtifactMatcher|STRING])
	 */
	protected void sequence_ArtifactMatchRestriction(ISerializationContext context, ArtifactMatchRestriction semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, OseeDslPackage.Literals.OBJECT_RESTRICTION__PERMISSION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OseeDslPackage.Literals.OBJECT_RESTRICTION__PERMISSION));
			if (transientValues.isValueTransient(semanticObject, OseeDslPackage.Literals.ARTIFACT_MATCH_RESTRICTION__ARTIFACT_MATCHER_REF) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OseeDslPackage.Literals.ARTIFACT_MATCH_RESTRICTION__ARTIFACT_MATCHER_REF));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getArtifactMatchRestrictionAccess().getPermissionAccessPermissionEnumEnumRuleCall_0_0(), semanticObject.getPermission());
		feeder.accept(grammarAccess.getArtifactMatchRestrictionAccess().getArtifactMatcherRefXArtifactMatcherSTRINGTerminalRuleCall_3_0_1(), semanticObject.getArtifactMatcherRef());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     ObjectRestriction returns ArtifactTypeRestriction
	 *     ArtifactTypeRestriction returns ArtifactTypeRestriction
	 *
	 * Constraint:
	 *     (permission=AccessPermissionEnum artifactTypeRef=[XArtifactType|STRING])
	 */
	protected void sequence_ArtifactTypeRestriction(ISerializationContext context, ArtifactTypeRestriction semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, OseeDslPackage.Literals.OBJECT_RESTRICTION__PERMISSION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OseeDslPackage.Literals.OBJECT_RESTRICTION__PERMISSION));
			if (transientValues.isValueTransient(semanticObject, OseeDslPackage.Literals.ARTIFACT_TYPE_RESTRICTION__ARTIFACT_TYPE_REF) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OseeDslPackage.Literals.ARTIFACT_TYPE_RESTRICTION__ARTIFACT_TYPE_REF));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getArtifactTypeRestrictionAccess().getPermissionAccessPermissionEnumEnumRuleCall_0_0(), semanticObject.getPermission());
		feeder.accept(grammarAccess.getArtifactTypeRestrictionAccess().getArtifactTypeRefXArtifactTypeSTRINGTerminalRuleCall_3_0_1(), semanticObject.getArtifactTypeRef());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     ObjectRestriction returns AttributeTypeRestriction
	 *     AttributeTypeRestriction returns AttributeTypeRestriction
	 *
	 * Constraint:
	 *     (permission=AccessPermissionEnum attributeTypeRef=[XAttributeType|STRING] artifactTypeRef=[XArtifactType|STRING]?)
	 */
	protected void sequence_AttributeTypeRestriction(ISerializationContext context, AttributeTypeRestriction semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Condition returns CompoundCondition
	 *     CompoundCondition returns CompoundCondition
	 *
	 * Constraint:
	 *     (conditions+=SimpleCondition (operators+=XLogicOperator conditions+=SimpleCondition)+)
	 */
	protected void sequence_CompoundCondition(ISerializationContext context, CompoundCondition semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     HierarchyRestriction returns HierarchyRestriction
	 *
	 * Constraint:
	 *     (artifactMatcherRef=[XArtifactMatcher|STRING] accessRules+=ObjectRestriction+)
	 */
	protected void sequence_HierarchyRestriction(ISerializationContext context, HierarchyRestriction semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Import returns Import
	 *
	 * Constraint:
	 *     importURI=STRING
	 */
	protected void sequence_Import(ISerializationContext context, Import semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, OseeDslPackage.Literals.IMPORT__IMPORT_URI) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OseeDslPackage.Literals.IMPORT__IMPORT_URI));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getImportAccess().getImportURISTRINGTerminalRuleCall_1_0(), semanticObject.getImportURI());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     LegacyRelationTypeRestriction returns LegacyRelationTypeRestriction
	 *
	 * Constraint:
	 *     (
	 *         permission=AccessPermissionEnum 
	 *         relationTypeRef=[XRelationType|STRING] 
	 *         restrictedToSide=XRelationSideEnum 
	 *         artifactMatcherRef=[XArtifactMatcher|STRING]?
	 *     )
	 */
	protected void sequence_LegacyRelationTypeRestriction(ISerializationContext context, LegacyRelationTypeRestriction semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     OseeDsl returns OseeDsl
	 *
	 * Constraint:
	 *     (
	 *         imports+=Import+ | 
	 *         (imports+=Import+ (artifactMatchRefs+=XArtifactMatcher | accessDeclarations+=AccessContext | roleDeclarations+=Role)*) | 
	 *         (
	 *             imports+=Import+ 
	 *             (
	 *                 artifactTypes+=XArtifactType | 
	 *                 relationTypes+=XRelationType | 
	 *                 attributeTypes+=XAttributeType | 
	 *                 enumTypes+=XOseeEnumType | 
	 *                 enumOverrides+=XOseeEnumOverride | 
	 *                 artifactTypeOverrides+=XOseeArtifactTypeOverride
	 *             )+ 
	 *             (artifactMatchRefs+=XArtifactMatcher | accessDeclarations+=AccessContext | roleDeclarations+=Role)*
	 *         )
	 *     )?
	 */
	protected void sequence_OseeDsl(ISerializationContext context, OseeDsl semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ReferencedContext returns ReferencedContext
	 *
	 * Constraint:
	 *     accessContextRef=STRING
	 */
	protected void sequence_ReferencedContext(ISerializationContext context, ReferencedContext semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, OseeDslPackage.Literals.REFERENCED_CONTEXT__ACCESS_CONTEXT_REF) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OseeDslPackage.Literals.REFERENCED_CONTEXT__ACCESS_CONTEXT_REF));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getReferencedContextAccess().getAccessContextRefSTRINGTerminalRuleCall_1_0(), semanticObject.getAccessContextRef());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     RelationTypeArtifactPredicate returns RelationTypeArtifactPredicate
	 *     RelationTypePredicate returns RelationTypeArtifactPredicate
	 *
	 * Constraint:
	 *     artifactMatcherRef=[XArtifactMatcher|STRING]
	 */
	protected void sequence_RelationTypeArtifactPredicate(ISerializationContext context, RelationTypeArtifactPredicate semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, OseeDslPackage.Literals.RELATION_TYPE_ARTIFACT_PREDICATE__ARTIFACT_MATCHER_REF) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OseeDslPackage.Literals.RELATION_TYPE_ARTIFACT_PREDICATE__ARTIFACT_MATCHER_REF));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getRelationTypeArtifactPredicateAccess().getArtifactMatcherRefXArtifactMatcherSTRINGTerminalRuleCall_1_0_1(), semanticObject.getArtifactMatcherRef());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     RelationTypeArtifactTypePredicate returns RelationTypeArtifactTypePredicate
	 *     RelationTypePredicate returns RelationTypeArtifactTypePredicate
	 *
	 * Constraint:
	 *     artifactTypeRef=[XArtifactType|STRING]
	 */
	protected void sequence_RelationTypeArtifactTypePredicate(ISerializationContext context, RelationTypeArtifactTypePredicate semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, OseeDslPackage.Literals.RELATION_TYPE_ARTIFACT_TYPE_PREDICATE__ARTIFACT_TYPE_REF) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OseeDslPackage.Literals.RELATION_TYPE_ARTIFACT_TYPE_PREDICATE__ARTIFACT_TYPE_REF));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getRelationTypeArtifactTypePredicateAccess().getArtifactTypeRefXArtifactTypeSTRINGTerminalRuleCall_1_0_1(), semanticObject.getArtifactTypeRef());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     ObjectRestriction returns RelationTypeRestriction
	 *     RelationTypeRestriction returns RelationTypeRestriction
	 *
	 * Constraint:
	 *     (
	 *         permission=AccessPermissionEnum 
	 *         (relationTypeMatch?=RelationTypeMatch | relationTypeRef=[XRelationType|STRING]) 
	 *         restrictedToSide=XRelationSideEnum 
	 *         predicate=RelationTypePredicate?
	 *     )
	 */
	protected void sequence_RelationTypeRestriction(ISerializationContext context, RelationTypeRestriction semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AttributeOverrideOption returns RemoveAttribute
	 *     RemoveAttribute returns RemoveAttribute
	 *
	 * Constraint:
	 *     attribute=[XAttributeType|STRING]
	 */
	protected void sequence_RemoveAttribute(ISerializationContext context, RemoveAttribute semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, OseeDslPackage.Literals.REMOVE_ATTRIBUTE__ATTRIBUTE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OseeDslPackage.Literals.REMOVE_ATTRIBUTE__ATTRIBUTE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getRemoveAttributeAccess().getAttributeXAttributeTypeSTRINGTerminalRuleCall_2_0_1(), semanticObject.getAttribute());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     OverrideOption returns RemoveEnum
	 *     RemoveEnum returns RemoveEnum
	 *
	 * Constraint:
	 *     enumEntry=[XOseeEnumEntry|STRING]
	 */
	protected void sequence_RemoveEnum(ISerializationContext context, RemoveEnum semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, OseeDslPackage.Literals.REMOVE_ENUM__ENUM_ENTRY) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OseeDslPackage.Literals.REMOVE_ENUM__ENUM_ENTRY));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getRemoveEnumAccess().getEnumEntryXOseeEnumEntrySTRINGTerminalRuleCall_1_0_1(), semanticObject.getEnumEntry());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Role returns Role
	 *
	 * Constraint:
	 *     (name=STRING superRoles+=[Role|STRING]? (usersAndGroups+=UsersAndGroups | referencedContexts+=ReferencedContext)+)
	 */
	protected void sequence_Role(ISerializationContext context, Role semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Condition returns SimpleCondition
	 *     SimpleCondition returns SimpleCondition
	 *
	 * Constraint:
	 *     (field=MatchField op=CompareOp expression=STRING)
	 */
	protected void sequence_SimpleCondition(ISerializationContext context, SimpleCondition semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, OseeDslPackage.Literals.SIMPLE_CONDITION__FIELD) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OseeDslPackage.Literals.SIMPLE_CONDITION__FIELD));
			if (transientValues.isValueTransient(semanticObject, OseeDslPackage.Literals.SIMPLE_CONDITION__OP) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OseeDslPackage.Literals.SIMPLE_CONDITION__OP));
			if (transientValues.isValueTransient(semanticObject, OseeDslPackage.Literals.SIMPLE_CONDITION__EXPRESSION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OseeDslPackage.Literals.SIMPLE_CONDITION__EXPRESSION));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getSimpleConditionAccess().getFieldMatchFieldEnumRuleCall_0_0(), semanticObject.getField());
		feeder.accept(grammarAccess.getSimpleConditionAccess().getOpCompareOpEnumRuleCall_1_0(), semanticObject.getOp());
		feeder.accept(grammarAccess.getSimpleConditionAccess().getExpressionSTRINGTerminalRuleCall_2_0(), semanticObject.getExpression());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     AttributeOverrideOption returns UpdateAttribute
	 *     UpdateAttribute returns UpdateAttribute
	 *
	 * Constraint:
	 *     attribute=XAttributeTypeRef
	 */
	protected void sequence_UpdateAttribute(ISerializationContext context, UpdateAttribute semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, OseeDslPackage.Literals.UPDATE_ATTRIBUTE__ATTRIBUTE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OseeDslPackage.Literals.UPDATE_ATTRIBUTE__ATTRIBUTE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getUpdateAttributeAccess().getAttributeXAttributeTypeRefParserRuleCall_1_0(), semanticObject.getAttribute());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     UsersAndGroups returns UsersAndGroups
	 *
	 * Constraint:
	 *     userOrGroupId=WHOLE_NUM_STR
	 */
	protected void sequence_UsersAndGroups(ISerializationContext context, UsersAndGroups semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, OseeDslPackage.Literals.USERS_AND_GROUPS__USER_OR_GROUP_ID) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OseeDslPackage.Literals.USERS_AND_GROUPS__USER_OR_GROUP_ID));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getUsersAndGroupsAccess().getUserOrGroupIdWHOLE_NUM_STRTerminalRuleCall_1_0(), semanticObject.getUserOrGroupId());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     XArtifactMatcher returns XArtifactMatcher
	 *
	 * Constraint:
	 *     (name=STRING conditions+=Condition (operators+=XLogicOperator conditions+=Condition)*)
	 */
	protected void sequence_XArtifactMatcher(ISerializationContext context, XArtifactMatcher semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     OseeElement returns XArtifactType
	 *     OseeType returns XArtifactType
	 *     XArtifactType returns XArtifactType
	 *
	 * Constraint:
	 *     (
	 *         abstract?='abstract'? 
	 *         name=STRING 
	 *         (superArtifactTypes+=[XArtifactType|STRING] superArtifactTypes+=[XArtifactType|STRING]*)? 
	 *         id=WHOLE_NUM_STR 
	 *         validAttributeTypes+=XAttributeTypeRef*
	 *     )
	 */
	protected void sequence_XArtifactType(ISerializationContext context, XArtifactType semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     XAttributeTypeRef returns XAttributeTypeRef
	 *
	 * Constraint:
	 *     (validAttributeType=[XAttributeType|STRING] branchUuid=WHOLE_NUM_STR?)
	 */
	protected void sequence_XAttributeTypeRef(ISerializationContext context, XAttributeTypeRef semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     OseeElement returns XAttributeType
	 *     OseeType returns XAttributeType
	 *     XAttributeType returns XAttributeType
	 *
	 * Constraint:
	 *     (
	 *         name=STRING 
	 *         baseAttributeType=AttributeBaseType 
	 *         override=[XAttributeType|STRING]? 
	 *         id=WHOLE_NUM_STR 
	 *         (dataProvider='DefaultAttributeDataProvider' | dataProvider='UriAttributeDataProvider' | dataProvider=QUALIFIED_NAME) 
	 *         min=WHOLE_NUM_STR 
	 *         (max=WHOLE_NUM_STR | max='unlimited') 
	 *         taggerId='DefaultAttributeTaggerProvider'? 
	 *         (
	 *             (
	 *                 taggerId=QUALIFIED_NAME | 
	 *                 enumType=[XOseeEnumType|STRING] | 
	 *                 description=STRING | 
	 *                 defaultValue=STRING | 
	 *                 fileExtension=STRING | 
	 *                 mediaType=STRING
	 *             )? 
	 *             taggerId='DefaultAttributeTaggerProvider'?
	 *         )*
	 *     )
	 */
	protected void sequence_XAttributeType(ISerializationContext context, XAttributeType semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     XOseeArtifactTypeOverride returns XOseeArtifactTypeOverride
	 *
	 * Constraint:
	 *     (overridenArtifactType=[XArtifactType|STRING] inheritAll?='inheritAll'? overrideOptions+=AttributeOverrideOption+)
	 */
	protected void sequence_XOseeArtifactTypeOverride(ISerializationContext context, XOseeArtifactTypeOverride semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     XOseeEnumEntry returns XOseeEnumEntry
	 *
	 * Constraint:
	 *     (name=STRING ordinal=WHOLE_NUM_STR? description=STRING?)
	 */
	protected void sequence_XOseeEnumEntry(ISerializationContext context, XOseeEnumEntry semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     OseeElement returns XOseeEnumOverride
	 *     XOseeEnumOverride returns XOseeEnumOverride
	 *
	 * Constraint:
	 *     (overridenEnumType=[XOseeEnumType|STRING] inheritAll?='inheritAll'? overrideOptions+=OverrideOption*)
	 */
	protected void sequence_XOseeEnumOverride(ISerializationContext context, XOseeEnumOverride semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     OseeElement returns XOseeEnumType
	 *     OseeType returns XOseeEnumType
	 *     XOseeEnumType returns XOseeEnumType
	 *
	 * Constraint:
	 *     (name=STRING id=WHOLE_NUM_STR enumEntries+=XOseeEnumEntry*)
	 */
	protected void sequence_XOseeEnumType(ISerializationContext context, XOseeEnumType semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     OseeElement returns XRelationType
	 *     OseeType returns XRelationType
	 *     XRelationType returns XRelationType
	 *
	 * Constraint:
	 *     (
	 *         name=STRING 
	 *         id=WHOLE_NUM_STR 
	 *         sideAName=STRING 
	 *         sideAArtifactType=[XArtifactType|STRING] 
	 *         sideBName=STRING 
	 *         sideBArtifactType=[XArtifactType|STRING] 
	 *         defaultOrderType=RelationOrderType 
	 *         multiplicity=RelationMultiplicityEnum
	 *     )
	 */
	protected void sequence_XRelationType(ISerializationContext context, XRelationType semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, OseeDslPackage.Literals.OSEE_TYPE__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OseeDslPackage.Literals.OSEE_TYPE__NAME));
			if (transientValues.isValueTransient(semanticObject, OseeDslPackage.Literals.OSEE_TYPE__ID) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OseeDslPackage.Literals.OSEE_TYPE__ID));
			if (transientValues.isValueTransient(semanticObject, OseeDslPackage.Literals.XRELATION_TYPE__SIDE_ANAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OseeDslPackage.Literals.XRELATION_TYPE__SIDE_ANAME));
			if (transientValues.isValueTransient(semanticObject, OseeDslPackage.Literals.XRELATION_TYPE__SIDE_AARTIFACT_TYPE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OseeDslPackage.Literals.XRELATION_TYPE__SIDE_AARTIFACT_TYPE));
			if (transientValues.isValueTransient(semanticObject, OseeDslPackage.Literals.XRELATION_TYPE__SIDE_BNAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OseeDslPackage.Literals.XRELATION_TYPE__SIDE_BNAME));
			if (transientValues.isValueTransient(semanticObject, OseeDslPackage.Literals.XRELATION_TYPE__SIDE_BARTIFACT_TYPE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OseeDslPackage.Literals.XRELATION_TYPE__SIDE_BARTIFACT_TYPE));
			if (transientValues.isValueTransient(semanticObject, OseeDslPackage.Literals.XRELATION_TYPE__DEFAULT_ORDER_TYPE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OseeDslPackage.Literals.XRELATION_TYPE__DEFAULT_ORDER_TYPE));
			if (transientValues.isValueTransient(semanticObject, OseeDslPackage.Literals.XRELATION_TYPE__MULTIPLICITY) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, OseeDslPackage.Literals.XRELATION_TYPE__MULTIPLICITY));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getXRelationTypeAccess().getNameSTRINGTerminalRuleCall_1_0(), semanticObject.getName());
		feeder.accept(grammarAccess.getXRelationTypeAccess().getIdWHOLE_NUM_STRTerminalRuleCall_4_0(), semanticObject.getId());
		feeder.accept(grammarAccess.getXRelationTypeAccess().getSideANameSTRINGTerminalRuleCall_6_0(), semanticObject.getSideAName());
		feeder.accept(grammarAccess.getXRelationTypeAccess().getSideAArtifactTypeXArtifactTypeSTRINGTerminalRuleCall_8_0_1(), semanticObject.getSideAArtifactType());
		feeder.accept(grammarAccess.getXRelationTypeAccess().getSideBNameSTRINGTerminalRuleCall_10_0(), semanticObject.getSideBName());
		feeder.accept(grammarAccess.getXRelationTypeAccess().getSideBArtifactTypeXArtifactTypeSTRINGTerminalRuleCall_12_0_1(), semanticObject.getSideBArtifactType());
		feeder.accept(grammarAccess.getXRelationTypeAccess().getDefaultOrderTypeRelationOrderTypeParserRuleCall_14_0(), semanticObject.getDefaultOrderType());
		feeder.accept(grammarAccess.getXRelationTypeAccess().getMultiplicityRelationMultiplicityEnumEnumRuleCall_16_0(), semanticObject.getMultiplicity());
		feeder.finish();
	}
	
	
}
