/*******************************************************************************
 * Copyright (c) 2004, 2007 Boeing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Boeing - initial API and implementation
 *******************************************************************************/
package org.eclipse.osee.framework.core.data;

import org.eclipse.osee.framework.jdk.core.type.NamedId;

/**
 * @author Roberto E. Escobar
 */
public interface IAccessContextId extends NamedId {

   public static IAccessContextId valueOf(Long id, String name) {
      return new AccessContextIdToken(id, name);
   }

   public static IAccessContextId valueOf(String idStr) {
      return valueOf(Long.valueOf(idStr), "");
   }

}