/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc.internal.osgi;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.jdbc.JdbcConstants;
import org.eclipse.osee.jdbc.internal.osgi.JdbcServiceConfig;
import org.eclipse.osee.jdbc.internal.osgi.JdbcServiceConfigParser;
import org.eclipse.osee.jdbc.internal.osgi.JdbcServiceImpl;
import org.eclipse.osee.jdbc.internal.osgi.JdbcSvcCfgChangeType;
import org.eclipse.osee.logger.Log;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;

public class JdbcComponentFactory {
    private final ConcurrentHashMap<String, JdbcServiceComponent> services = new ConcurrentHashMap();
    private JdbcServiceConfigParser parser;
    private Log logger;
    private ComponentFactory componentFactory;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setComponentFactory(ComponentFactory componentFactory) {
        this.componentFactory = componentFactory;
    }

    public void start(Map<String, Object> props) {
        this.parser = new JdbcServiceConfigParser();
        this.update(props);
    }

    public void stop() {
        Iterator<JdbcServiceComponent> iterator = this.services.values().iterator();
        while (iterator.hasNext()) {
            JdbcServiceComponent component = iterator.next();
            component.stop();
            iterator.remove();
        }
        this.parser = null;
    }

    public void update(Map<String, Object> props) {
        this.logger.trace("Configuring [%s]...", new Object[]{this.getClass().getSimpleName()});
        String newJsonConfig = (String)props.get(JdbcConstants.JDBC_SERVICE__CONFIGS);
        if (newJsonConfig != null) {
            JdbcServiceComponent component;
            Map<String, JdbcServiceConfig> newConfigs = this.parser.parse(newJsonConfig);
            for (JdbcServiceConfig config : newConfigs.values()) {
                JdbcServiceComponent newComponent = new JdbcServiceComponent(config.getId());
                component = this.services.putIfAbsent(newComponent.getId(), newComponent);
                if (component == null) {
                    component = newComponent;
                }
                component.update(config);
            }
            Iterable<String> removed = JdbcComponentFactory.difference(this.services.keySet(), newConfigs.keySet());
            for (String id : removed) {
                component = this.services.remove(id);
                if (component == null) continue;
                component.stop();
            }
        } else {
            this.logger.trace("No configuration with [%s] found for [%s]", new Object[]{JdbcConstants.JDBC_SERVICE__CONFIGS, this.getClass().getSimpleName()});
        }
    }

    public Map<String, JdbcServiceComponent> getServices() {
        return java.util.Collections.unmodifiableMap(this.services);
    }

    private static Iterable<String> difference(Set<String> setA, Set<String> setB) {
        return Collections.setComplement(setA, setB);
    }

    public final class JdbcServiceComponent {
        private final String id;
        private ComponentInstance instance;
        private Map<String, Object> lastConfig;

        public JdbcServiceComponent(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public Map<String, Object> getConfig() {
            return this.lastConfig;
        }

        public void update(JdbcServiceConfig config) {
            Map<String, Object> newConfig = config.asMap();
            JdbcSvcCfgChangeType changeType = JdbcSvcCfgChangeType.getChangeType(this.lastConfig, newConfig);
            if (this.instance == null) {
                this.instance = JdbcComponentFactory.this.componentFactory.newInstance(config.asDictionary());
            } else {
                switch (changeType) {
                    case NO_CHANGE: {
                        break;
                    }
                    case JDBC_PROPERTY: {
                        JdbcServiceImpl object = (JdbcServiceImpl)this.instance.getInstance();
                        object.update(config.asMap());
                        break;
                    }
                    default: {
                        this.instance.dispose();
                        this.instance = JdbcComponentFactory.this.componentFactory.newInstance(config.asDictionary());
                    }
                }
            }
            this.lastConfig = newConfig;
        }

        public void stop() {
            if (this.instance != null) {
                this.instance.dispose();
            }
        }
    }
}

