/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.util.annotation.FieldAnnotationHandler;

public class AnnotationProcessor {
    private final Map<Class<? extends Annotation>, FieldAnnotationHandler<?>> annotationHandlers;

    public AnnotationProcessor(Map<Class<? extends Annotation>, FieldAnnotationHandler<? extends Annotation>> annotationHandlers) {
        this.annotationHandlers = annotationHandlers;
    }

    public void initAnnotations(Object ... objects) throws Exception {
        if (objects == null) {
            throw new Exception("objects cannot be null");
        }
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            this.initAnnotations(object);
            ++n2;
        }
    }

    public void initAnnotations(Object object) throws Exception {
        if (object == null) {
            throw new Exception("object cannot be null");
        }
        Class<?> clazz = object.getClass();
        while (clazz != Object.class) {
            this.scan(object, clazz);
            clazz = clazz.getSuperclass();
        }
    }

    private void scan(Object object, Class<?> clazz) throws Exception {
        Field[] fields;
        Field[] fieldArray = fields = clazz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation[] annotations;
            Field field = fieldArray[n2];
            Annotation[] annotationArray = annotations = field.getAnnotations();
            int n3 = annotations.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation annotation = annotationArray[n4];
                this.processAnnotation(object, field, annotation);
                ++n4;
            }
            ++n2;
        }
    }

    private <A extends Annotation> void processAnnotation(Object object, Field field, A annotation) throws Exception {
        A handler = this.getHandler(annotation);
        if (handler != null) {
            handler.handleAnnotation(annotation, object, field);
        }
    }

    private <T extends FieldAnnotationHandler<? extends Annotation>> T getHandler(Annotation annotation) {
        return (T)this.annotationHandlers.get(annotation.annotationType());
    }
}

