/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.text.change;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.regex.Matcher;
import org.eclipse.osee.framework.jdk.core.text.change.CharArrayChange;
import org.eclipse.osee.framework.jdk.core.text.change.CharChange;
import org.eclipse.osee.framework.jdk.core.text.change.CharacterChanger;
import org.eclipse.osee.framework.jdk.core.text.change.DeleteChange;

public class ChangeSet {
    private CharacterChanger firstChange;
    private CharacterChanger lastChange;
    private char[] sourceChars;
    private CharSequence source;

    public ChangeSet() {
        this("");
    }

    public ChangeSet(CharSequence source) {
        CharBuffer charBuf;
        if (source instanceof CharBuffer && (charBuf = (CharBuffer)source).hasArray()) {
            this.sourceChars = charBuf.array();
            return;
        }
        if (source instanceof String) {
            this.sourceChars = ((String)source).toCharArray();
        }
        this.source = source;
    }

    private int copyFromSource(int srcStrartIndex, int srcEndIndex, char[] dest, int destPos) {
        if (this.sourceChars != null) {
            int length = srcEndIndex - srcStrartIndex;
            System.arraycopy(this.sourceChars, srcStrartIndex, dest, destPos, length);
            return destPos + length;
        }
        int i = srcStrartIndex;
        while (i < srcEndIndex) {
            dest[destPos++] = this.source.charAt(i);
            ++i;
        }
        return destPos;
    }

    private void writeFromSource(int srcStrartIndex, int srcEndIndex, Writer writer) throws IOException {
        if (this.sourceChars != null) {
            writer.write(this.sourceChars, srcStrartIndex, srcEndIndex - srcStrartIndex);
        } else {
            int i = srcStrartIndex;
            while (i < srcEndIndex) {
                writer.write(this.source.charAt(i));
                ++i;
            }
        }
    }

    public int getSourceLength() {
        if (this.sourceChars == null) {
            return this.source.length();
        }
        return this.sourceChars.length;
    }

    public void applyChanges(char[] dest, int destPos) {
        int lastEndIndex = 0;
        CharacterChanger change = this.firstChange;
        while (change != null) {
            destPos = this.copyFromSource(lastEndIndex, change.getStartIndex(), dest, destPos);
            lastEndIndex = change.getEndIndex();
            destPos = change.applyChange(dest, destPos);
            change = change.next();
        }
        this.copyFromSource(lastEndIndex, this.getSourceLength(), dest, destPos);
    }

    public void applyChanges(Writer writer) throws IOException {
        int lastEndIndex = 0;
        CharacterChanger change = this.firstChange;
        while (change != null) {
            this.writeFromSource(lastEndIndex, change.getStartIndex(), writer);
            lastEndIndex = change.getEndIndex();
            change.applyChange(writer);
            change = change.next();
        }
        this.writeFromSource(lastEndIndex, this.getSourceLength(), writer);
    }

    public void applyChanges(File outFile) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
        this.applyChanges(writer);
        writer.close();
    }

    public void insertBefore(int index, char[] newChars, int offset, int length, boolean copy) {
        this.addChanger(new CharArrayChange(index, index, newChars, offset, length, copy));
    }

    public void insertBefore(int index, char[] newChars, int offset, int length) {
        this.addChanger(new CharArrayChange(index, index, newChars, offset, length));
    }

    public void insertBefore(int index, char[] newChars) {
        this.addChanger(new CharArrayChange(index, index, newChars));
    }

    public void insertBefore(int index, char newChar) {
        this.addChanger(new CharChange(index, index, newChar));
    }

    public void insertBefore(int index, String newChar) {
        this.insertBefore(index, newChar.toCharArray());
    }

    public void replace(int srcStartIndex, int srcEndIndex, char[] newChars, int offset, int length) {
        this.addChanger(new CharArrayChange(srcStartIndex, srcEndIndex, newChars, offset, length));
    }

    public void replace(int srcStartIndex, int srcEndIndex, char[] newChars) {
        this.addChanger(new CharArrayChange(srcStartIndex, srcEndIndex, newChars));
    }

    public void replace(int srcStartIndex, int srcEndIndex, char newChar) {
        this.addChanger(new CharChange(srcStartIndex, srcEndIndex, newChar));
    }

    public void replace(int srcStartIndex, int srcEndIndex, String newChar) {
        this.replace(srcStartIndex, srcEndIndex, newChar.toCharArray());
    }

    public void delete(int srcStartIndex, int srcEndIndex) {
        this.addChanger(new DeleteChange(srcStartIndex, srcEndIndex));
    }

    private void addChanger(CharacterChanger changer) {
        if (this.firstChange == null) {
            this.lastChange = this.firstChange = changer;
        } else if (changer.getStartIndex() < this.lastChange.getStartIndex()) {
            CharacterChanger current = this.firstChange;
            CharacterChanger previous = null;
            while (current.getStartIndex() <= changer.getStartIndex()) {
                previous = current;
                current = current.next();
            }
            this.addNormalized(previous, changer, current);
        } else {
            this.addNormalized(this.lastChange, changer, null);
        }
    }

    private void addNormalized(CharacterChanger previous, CharacterChanger changer, CharacterChanger next) {
        if (this.lastChange instanceof DeleteChange) {
            boolean cfr_ignored_0 = next instanceof DeleteChange;
        }
        if (previous == null) {
            this.firstChange = changer;
        } else {
            this.overlapping(previous.getEndIndex(), changer.getStartIndex());
            previous.setNext(changer);
        }
        if (next == null) {
            this.lastChange = changer;
        } else {
            this.overlapping(changer.getEndIndex(), next.getStartIndex());
            changer.setNext(next);
        }
    }

    private void overlapping(int a, int b) {
        if (a > b) {
            throw new IllegalArgumentException("Overlapping changes are not currently allowed " + a + " > " + b + " " + new String(this.sourceChars, b - 4, 20));
        }
    }

    public int getLengthDelta() {
        int lengthDelta = 0;
        CharacterChanger change = this.firstChange;
        while (change != null) {
            lengthDelta += change.getLengthDelta();
            change = change.next();
        }
        return lengthDelta;
    }

    public CharSequence applyChangesToSelf() {
        this.sourceChars = this.toCharArray();
        this.source = CharBuffer.wrap(this.sourceChars);
        this.firstChange = null;
        this.lastChange = null;
        return this.source;
    }

    public char[] toCharArray() {
        char[] chars = new char[this.getLengthDelta() + this.getSourceLength()];
        this.applyChanges(chars, 0);
        return chars;
    }

    public String toString() {
        return new String(this.toCharArray());
    }

    public void replaceAll(Matcher matcher, String replacement) {
        matcher.reset(this.source);
        while (matcher.find()) {
            this.replace(matcher.start(), matcher.end(), replacement);
        }
    }
}

