/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.tokens.hawk;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.oauth2.client.HttpRequestProperties;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenValidation;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenValidator;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.tokens.hawk.HawkAccessToken;
import org.apache.cxf.rs.security.oauth2.tokens.hawk.HawkAuthorizationScheme;
import org.apache.cxf.rs.security.oauth2.tokens.hawk.HmacAlgorithm;
import org.apache.cxf.rs.security.oauth2.tokens.hawk.NonceVerifier;
import org.apache.cxf.rs.security.oauth2.utils.AuthorizationUtils;
import org.apache.cxf.rs.security.oauth2.utils.crypto.HmacUtils;

public class HawkAccessTokenValidator
implements AccessTokenValidator {
    private OAuthDataProvider dataProvider;
    private NonceVerifier nonceVerifier;

    @Override
    public List<String> getSupportedAuthorizationSchemes() {
        return Collections.singletonList("Hawk");
    }

    @Override
    public AccessTokenValidation validateAccessToken(MessageContext mc, String authScheme, String authSchemeData) throws OAuthServiceException {
        HttpRequestProperties httpProps = new HttpRequestProperties(mc.getUriInfo().getRequestUri(), mc.getHttpServletRequest().getMethod());
        Map<String, String> schemeParams = HawkAccessTokenValidator.getSchemeParameters(authSchemeData);
        HawkAuthorizationScheme macAuthInfo = new HawkAuthorizationScheme(httpProps, schemeParams);
        HawkAccessToken macAccessToken = this.validateSchemeData(macAuthInfo, schemeParams.get("mac"));
        this.validateTimestampNonce(macAccessToken, macAuthInfo.getTimestamp(), macAuthInfo.getNonce());
        return new AccessTokenValidation(macAccessToken);
    }

    private static Map<String, String> getSchemeParameters(String authData) {
        String[] attributePairs = authData.split(",");
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        for (String pair : attributePairs) {
            String[] pairValues = pair.trim().split("=", 2);
            attributeMap.put(pairValues[0].trim(), pairValues[1].trim().replaceAll("\"", ""));
        }
        return attributeMap;
    }

    protected void validateTimestampNonce(HawkAccessToken token, String ts, String nonce) {
        if (this.nonceVerifier != null) {
            this.nonceVerifier.verifyNonce(token.getTokenKey(), nonce, ts);
        }
    }

    private HawkAccessToken validateSchemeData(HawkAuthorizationScheme macAuthInfo, String clientMacString) {
        String macKey = macAuthInfo.getMacKey();
        ServerAccessToken accessToken = this.dataProvider.getAccessToken(macKey);
        if (!(accessToken instanceof HawkAccessToken)) {
            throw new OAuthServiceException("server_error");
        }
        HawkAccessToken macAccessToken = (HawkAccessToken)accessToken;
        String normalizedString = macAuthInfo.getNormalizedRequestString();
        try {
            HmacAlgorithm hmacAlgo = HmacAlgorithm.toHmacAlgorithm(macAccessToken.getMacAlgorithm());
            byte[] serverMacData = HmacUtils.computeHmac(macAccessToken.getMacKey(), hmacAlgo.getJavaName(), normalizedString);
            byte[] clientMacData = Base64Utility.decode((String)clientMacString);
            boolean validMac = Arrays.equals(serverMacData, clientMacData);
            if (!validMac) {
                AuthorizationUtils.throwAuthorizationFailure(Collections.singleton("Hawk"));
            }
        }
        catch (Base64Exception e) {
            throw new OAuthServiceException("server_error", (Throwable)e);
        }
        return macAccessToken;
    }

    public void setDataProvider(OAuthDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public void setNonceVerifier(NonceVerifier nonceVerifier) {
        this.nonceVerifier = nonceVerifier;
    }
}

