/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.type;

import org.eclipse.osee.framework.core.model.cache.AttributeTypeCache;
import org.eclipse.osee.framework.core.model.cache.IOseeTypeFactory;
import org.eclipse.osee.framework.core.model.type.AttributeType;
import org.eclipse.osee.framework.core.model.type.OseeEnumType;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AttributeTypeFactory
implements IOseeTypeFactory {
    public AttributeType create(long guid, String name, String baseAttributeTypeId, String attributeProviderNameId, String fileTypeExtension, String defaultValue, int minOccurrences, int maxOccurrences, String tipText, String taggerId, String mediaType) {
        Conditions.checkNotNullOrEmpty((String)name, (String)"attribute type name");
        Conditions.checkNotNullOrEmpty((String)baseAttributeTypeId, (String)"attribute base type id");
        Conditions.checkNotNullOrEmpty((String)attributeProviderNameId, (String)"attribute provider id");
        Conditions.checkExpressionFailOnTrue((minOccurrences > 0 && !Strings.isValid((String)defaultValue) ? 1 : 0) != 0, (String)"DefaultValue must be set for attribute [%s] with minOccurrences ", (Object[])new Object[]{name, minOccurrences});
        Conditions.checkExpressionFailOnTrue((minOccurrences < 0 ? 1 : 0) != 0, (String)"minOccurrences must be greater than or equal to zero", (Object[])new Object[0]);
        Conditions.checkExpressionFailOnTrue((maxOccurrences < minOccurrences ? 1 : 0) != 0, (String)"maxOccurences can not be less than minOccurences", (Object[])new Object[0]);
        return new AttributeType(guid, name, Strings.intern((String)baseAttributeTypeId), Strings.intern((String)attributeProviderNameId), Strings.intern((String)fileTypeExtension), defaultValue, minOccurrences, maxOccurrences, tipText, Strings.intern((String)taggerId), Strings.intern((String)mediaType));
    }

    public AttributeType createOrUpdate(AttributeTypeCache cache, long guid, String typeName, String baseAttributeTypeId, String attributeProviderNameId, String fileTypeExtension, String defaultValue, OseeEnumType oseeEnumType, int minOccurrences, int maxOccurrences, String description, String taggerId, String mediaType) {
        Conditions.checkNotNull((Object)cache, (String)"AttributeTypeCache");
        AttributeType attributeType = (AttributeType)cache.getByGuid(guid);
        if (attributeType == null) {
            attributeType = this.create(guid, typeName, baseAttributeTypeId, attributeProviderNameId, fileTypeExtension, defaultValue, minOccurrences, maxOccurrences, description, taggerId, mediaType);
            attributeType.setOseeEnumType(oseeEnumType);
            cache.cache(attributeType);
        } else {
            attributeType.setFields(typeName, baseAttributeTypeId, attributeProviderNameId, fileTypeExtension, defaultValue, oseeEnumType, minOccurrences, maxOccurrences, description, taggerId, mediaType);
        }
        return attributeType;
    }
}

