/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.type;

import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.model.AbstractOseeType;
import org.eclipse.osee.framework.core.model.OseeField;
import org.eclipse.osee.framework.core.model.type.OseeEnumType;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AttributeType
extends AbstractOseeType
implements AttributeTypeToken {
    private static final String ATTRIBUTE_BASE_TYPE_ID_FIELD_KEY = "osee.base.attribute.type.id.field";
    private static final String ATTRIBUTE_PROVIDER_ID_FIELD_KEY = "osee.attribute.provider.id.field";
    private static final String ATTRIBUTE_DEFAULT_VALUE_FIELD_KEY = "osee.attribute.default.value.field";
    private static final String ATTRIBUTE_ENUM_TYPE_ID_FIELD_KEY = "osee.attribute.enum.type.field";
    private static final String ATTRIBUTE_MAX_OCCURRENCE_FIELD_KEY = "osee.attribute.max.occurrence.field";
    private static final String ATTRIBUTE_MIN_OCCURRENCE_FIELD_KEY = "osee.attribute.min.occurrence.field";
    private static final String ATTRIBUTE_DESCRIPTION_FIELD_KEY = "osee.attribute.description.field";
    private static final String ATTRIBUTE_FILE_EXTENSION_FIELD_KEY = "osee.attribute.file.type.extension.field";
    private static final String ATTRIBUTE_TAGGER_ID_FIELD_KEY = "osee.attribute.tagger.id.field";
    private static final String ATTRIBUTE_MEDIA_TYPE_FIELD_KEY = "osee.attribute.media.type.field";

    public AttributeType(Long guid, String typeName, String baseAttributeTypeId, String attributeProviderNameId, String fileTypeExtension, String defaultValue, int minOccurrences, int maxOccurrences, String description, String taggerId, String mediaType) {
        super(guid, typeName);
        this.initializeFields();
        this.setFields(typeName, baseAttributeTypeId, attributeProviderNameId, fileTypeExtension, defaultValue, null, minOccurrences, maxOccurrences, description, taggerId, mediaType);
    }

    protected void initializeFields() {
        this.addField(ATTRIBUTE_BASE_TYPE_ID_FIELD_KEY, new OseeField());
        this.addField(ATTRIBUTE_PROVIDER_ID_FIELD_KEY, new OseeField());
        this.addField(ATTRIBUTE_DEFAULT_VALUE_FIELD_KEY, new OseeField());
        this.addField(ATTRIBUTE_ENUM_TYPE_ID_FIELD_KEY, new OseeField());
        this.addField(ATTRIBUTE_MAX_OCCURRENCE_FIELD_KEY, new OseeField());
        this.addField(ATTRIBUTE_MIN_OCCURRENCE_FIELD_KEY, new OseeField());
        this.addField(ATTRIBUTE_DESCRIPTION_FIELD_KEY, new OseeField());
        this.addField(ATTRIBUTE_FILE_EXTENSION_FIELD_KEY, new OseeField());
        this.addField(ATTRIBUTE_TAGGER_ID_FIELD_KEY, new OseeField());
        this.addField(ATTRIBUTE_MEDIA_TYPE_FIELD_KEY, new OseeField());
    }

    public void setFields(String name, String baseAttributeTypeId, String attributeProviderNameId, String fileTypeExtension, String defaultValue, OseeEnumType oseeEnumType, int minOccurrences, int maxOccurrences, String description, String taggerId, String mediaType) {
        String fileExtensionToSet = fileTypeExtension != null ? fileTypeExtension : "";
        this.setName(name);
        this.setFieldLogException(ATTRIBUTE_BASE_TYPE_ID_FIELD_KEY, baseAttributeTypeId);
        this.setFieldLogException(ATTRIBUTE_PROVIDER_ID_FIELD_KEY, attributeProviderNameId);
        this.setFieldLogException(ATTRIBUTE_DEFAULT_VALUE_FIELD_KEY, defaultValue);
        this.setFieldLogException(ATTRIBUTE_ENUM_TYPE_ID_FIELD_KEY, oseeEnumType);
        this.setFieldLogException(ATTRIBUTE_MAX_OCCURRENCE_FIELD_KEY, maxOccurrences);
        this.setFieldLogException(ATTRIBUTE_MIN_OCCURRENCE_FIELD_KEY, minOccurrences);
        this.setFieldLogException(ATTRIBUTE_DESCRIPTION_FIELD_KEY, description);
        this.setFieldLogException(ATTRIBUTE_FILE_EXTENSION_FIELD_KEY, fileExtensionToSet);
        this.setFieldLogException(ATTRIBUTE_TAGGER_ID_FIELD_KEY, taggerId);
        this.setFieldLogException(ATTRIBUTE_MEDIA_TYPE_FIELD_KEY, mediaType);
    }

    public String getBaseAttributeTypeId() {
        return this.getFieldValueLogException("", ATTRIBUTE_BASE_TYPE_ID_FIELD_KEY);
    }

    public String getAttributeProviderId() {
        return this.getFieldValueLogException("", ATTRIBUTE_PROVIDER_ID_FIELD_KEY);
    }

    public String getDefaultValue() {
        return this.getFieldValueLogException(null, ATTRIBUTE_DEFAULT_VALUE_FIELD_KEY);
    }

    public int getMaxOccurrences() {
        return this.getFieldValueLogException(0, ATTRIBUTE_MAX_OCCURRENCE_FIELD_KEY);
    }

    public int getMinOccurrences() {
        return this.getFieldValueLogException(0, ATTRIBUTE_MIN_OCCURRENCE_FIELD_KEY);
    }

    public String getDescription() {
        return this.getFieldValueLogException("", ATTRIBUTE_DESCRIPTION_FIELD_KEY);
    }

    public long getOseeEnumTypeId() {
        OseeEnumType oseeEnumType = this.getOseeEnumType();
        return oseeEnumType == null ? -1L : oseeEnumType.getId();
    }

    public OseeEnumType getOseeEnumType() {
        return this.getFieldValueLogException(null, ATTRIBUTE_ENUM_TYPE_ID_FIELD_KEY);
    }

    public void setOseeEnumType(OseeEnumType enumType) {
        this.setField(ATTRIBUTE_ENUM_TYPE_ID_FIELD_KEY, enumType);
    }

    public String getFileTypeExtension() {
        return this.getFieldValueLogException("", ATTRIBUTE_FILE_EXTENSION_FIELD_KEY);
    }

    public String getTaggerId() {
        return this.getFieldValueLogException("", ATTRIBUTE_TAGGER_ID_FIELD_KEY);
    }

    public String getMediaType() {
        return this.getFieldValueLogException("", ATTRIBUTE_MEDIA_TYPE_FIELD_KEY);
    }

    public boolean hasMediaType() {
        boolean toReturn = false;
        String format = this.getMediaType();
        if (format != null) {
            toReturn = Strings.isValid((String)format.trim());
        }
        return toReturn;
    }

    public boolean isTaggable() {
        boolean toReturn = false;
        String taggerId = this.getTaggerId();
        if (taggerId != null) {
            toReturn = Strings.isValid((String)taggerId.trim());
        }
        return toReturn;
    }

    public boolean isEnumerated() {
        return this.getOseeEnumTypeId() != -1L;
    }
}

