/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.change;

import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public final class ChangeVersion {
    private GammaId gammaId;
    private ModificationType modType;
    private ApplicabilityToken appId;
    private String value;

    public ChangeVersion() {
        this(null, null, ModificationType.SENTINEL, null);
    }

    public ChangeVersion(GammaId gammaId, ModificationType modType, ApplicabilityToken appId) {
        this(null, gammaId, modType, appId);
    }

    public ChangeVersion(String value, GammaId gammaId, ModificationType modType, ApplicabilityToken appId) {
        this.value = value;
        this.gammaId = gammaId;
        this.modType = modType;
        this.appId = appId;
    }

    public GammaId getGammaId() {
        return this.gammaId;
    }

    public ModificationType getModType() {
        return this.modType;
    }

    public ApplicabilityToken getApplicabilityToken() {
        return this.appId;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setGammaId(GammaId gammaId) {
        this.gammaId = gammaId;
    }

    public void setModType(ModificationType modType) {
        this.modType = modType;
    }

    public void setApplicabilityToken(ApplicabilityToken appId) {
        this.appId = appId;
    }

    public boolean isValid() {
        return this.getModType().isValid() && this.getGammaId() != null;
    }

    public void copy(ChangeVersion item) {
        Conditions.checkNotNull((Object)item, (String)"ChangeVersion");
        this.setGammaId(item.getGammaId());
        this.setModType(item.getModType());
        this.setValue(item.getValue());
        this.setApplicabilityToken(item.getApplicabilityToken());
    }

    public String toString() {
        ApplicabilityToken token = this.getApplicabilityToken();
        String tokenName = token != null ? token.getName() : "null";
        return String.format("[%s,%s,%s]", this.getGammaId(), this.getModType(), tokenName);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.gammaId == null ? 0 : this.gammaId.hashCode());
        result = 31 * result + (this.modType == null ? 0 : this.modType.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.appId == null ? 0 : this.appId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeVersion other = (ChangeVersion)obj;
        if (this.gammaId == null ? other.gammaId != null : this.gammaId.notEqual((Id)other.gammaId)) {
            return false;
        }
        if (this.modType == null ? other.modType != null : !this.modType.equals(other.modType)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.appId == null ? other.appId != null : !this.appId.equals((Object)other.appId));
    }
}

