/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.access;

import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.core.model.access.Scope;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AccessDetail<T> {
    private final T accessObject;
    private PermissionEnum permission;
    private Scope scope;
    private String reason;

    public AccessDetail(T accessObject, PermissionEnum permission, Scope scope) {
        this(accessObject, permission, scope, Strings.emptyString());
    }

    public AccessDetail(T accessObject, PermissionEnum permission, Scope scope, String reason) {
        this.accessObject = accessObject;
        this.permission = permission;
        this.reason = reason;
        this.scope = scope;
    }

    public String getReason() {
        return Strings.isValid((String)this.reason) ? this.reason : this.scope.getPath();
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public PermissionEnum getPermission() {
        return this.permission;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public T getAccessObject() {
        return this.accessObject;
    }

    public void setPermission(PermissionEnum permission) {
        this.permission = permission;
    }

    public int hashCode() {
        int hashCode = 11;
        return hashCode * 37 + (this.accessObject != null ? this.accessObject.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AccessDetail) {
            AccessDetail other = (AccessDetail)obj;
            T object1 = this.getAccessObject();
            T object2 = other.getAccessObject();
            boolean result = false;
            if (object1 == null && object2 == null) {
                result = true;
            } else if (object1 != null && object2 != null) {
                result = this.getAccessObject().equals(other.getAccessObject());
            }
            return result;
        }
        return false;
    }

    public String toString() {
        return "AccessDetail [permission=" + this.getPermission() + ", scope=" + this.getScope() + ", accessObject=" + this.getAccessObject() + ", reason=" + this.getReason() + "]";
    }

    public static AccessDetail<?> resolveAccess(AccessDetail<?> original, AccessDetail<?> data) {
        AccessDetail<?> toReturn = data;
        if (original != null) {
            Scope origScope = original.getScope();
            Scope dataScope = data.getScope();
            toReturn = origScope.isLegacy() || dataScope.isLegacy() || origScope.getPath().equals(dataScope.getPath()) ? AccessDetail.getMostRestrictive(original, data) : (dataScope.getScopeDepth() > origScope.getScopeDepth() ? data : original);
        }
        return toReturn;
    }

    private static AccessDetail<?> getMostRestrictive(AccessDetail<?> original, AccessDetail<?> data) {
        PermissionEnum origPermission = original.getPermission();
        PermissionEnum newPermission = data.getPermission();
        AccessDetail<?> toReturn = original;
        if (!origPermission.equals((Object)newPermission)) {
            PermissionEnum netPermission = PermissionEnum.getMostRestrictive((PermissionEnum)origPermission, (PermissionEnum)newPermission);
            if (netPermission.equals((Object)newPermission)) {
                toReturn = data;
            }
        } else {
            String netReason = AccessDetail.merge(toReturn.getReason(), data.getReason());
            toReturn.setReason(netReason);
        }
        return toReturn;
    }

    public static String merge(String reason1, String reason2) {
        StringBuilder builder = new StringBuilder();
        builder.append(reason1);
        if (!reason1.equals(reason2)) {
            builder.append(", ");
            builder.append(reason2);
        }
        return builder.toString();
    }
}

