/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem.operations;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeString;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;

public class ConvertWorkDefinitionOperations {
    private final AtsApi atsApi;
    private final OrcsApi orcsApi;

    public ConvertWorkDefinitionOperations(AtsApi atsApi, OrcsApi orcsApi) {
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
    }

    public void convert(XResultData rd) {
        this.convertMissingWorkItemWorkDefRefAttribute(rd);
        this.convertMissingWorkItemWorkDefNameAttribute(rd);
        this.convertMissingTeamDefinitionWorkDefAttributes(rd);
        this.convertMissingTeamWorkFlowWorkDefAttributes(rd);
    }

    private void convertMissingWorkItemWorkDefNameAttribute(XResultData rd) {
        if (!this.orcsApi.getOrcsTypes().getAttributeTypes().typeExists((AttributeTypeId)AtsAttributeTypes.WorkflowDefinition)) {
            return;
        }
        LinkedList artIdList = new LinkedList();
        artIdList.addAll(this.atsApi.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andAttr((AttributeTypeId)AtsAttributeTypes.CurrentStateType, StateType.Working.name(), new QueryOption[0]).andNotExists((AttributeTypeId)AtsAttributeTypes.WorkflowDefinition).getItemIds());
        List subDivide = Collections.subDivide(artIdList, (int)500);
        int size = subDivide.size();
        int count = 1;
        int updatedCount = 0;
        for (Collection artIds : subDivide) {
            System.err.println(String.format("WorkItem Set: Processing %s / %s\n", count, size));
            rd.logf(String.format("WorkItem Set: Processing %s / %s\n", count++, size), new Object[0]);
            LinkedList<Long> ids = new LinkedList<Long>();
            for (ArtifactId art : artIds) {
                ids.add(art.getId());
            }
            Collection allArtifacts = this.atsApi.getQueryService().getArtifacts(ids);
            IAtsChangeSet changes = this.atsApi.createChangeSet("Update Workflow Definition Name");
            for (ArtifactToken art : allArtifacts) {
                ArtifactId workDefArt;
                IAtsWorkItem workItem = this.atsApi.getWorkItemService().getWorkItem(art);
                boolean deleted = this.atsApi.getStoreService().isDeleted((IAtsObject)workItem);
                if (deleted || !(workDefArt = (ArtifactId)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)art, (AttributeTypeToken)AtsAttributeTypes.WorkflowDefinitionReference, (Object)ArtifactId.SENTINEL)).isValid()) continue;
                IAtsWorkDefinition workDefinition = this.atsApi.getWorkDefinitionService().getWorkDefinition((Id)workDefArt);
                if (workDefinition == null || workDefinition.isInvalid()) {
                    rd.error(String.format("null Work Definition for %s", workItem.toStringWithId()));
                    continue;
                }
                changes.setSoleAttributeValue(workItem, (AttributeTypeToken)AtsAttributeTypes.WorkflowDefinition, workDefinition.getName());
                ++updatedCount;
            }
            changes.executeIfNeeded();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        rd.logf("Updtated %s Work Items\n", new Object[]{updatedCount});
    }

    private void convertMissingWorkItemWorkDefAttribute(XResultData rd) {
        LinkedList artIdList = new LinkedList();
        artIdList.addAll(this.atsApi.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andNotExists((AttributeTypeId)AtsAttributeTypes.WorkflowDefinitionReference).getItemIds());
        List subDivide = Collections.subDivide(artIdList, (int)500);
        int size = subDivide.size();
        int count = 1;
        int updatedCount = 0;
        for (Collection artIds : subDivide) {
            rd.logf(String.format("WorkItem Set: Processing %s / %s\n", count++, size), new Object[0]);
            LinkedList<Long> ids = new LinkedList<Long>();
            for (ArtifactId art : artIds) {
                ids.add(art.getId());
            }
            Collection allArtifacts = this.atsApi.getQueryService().getArtifacts(ids);
            IAtsChangeSet changes = this.atsApi.createChangeSet("Update Workflow Definition Ref");
            for (ArtifactToken art : allArtifacts) {
                ArtifactId workDefArt;
                IAtsWorkItem workItem = this.atsApi.getWorkItemService().getWorkItem(art);
                boolean deleted = this.atsApi.getStoreService().isDeleted((IAtsObject)workItem);
                if (deleted || !(workDefArt = (ArtifactId)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)art, (AttributeTypeToken)AtsAttributeTypes.WorkflowDefinitionReference, (Object)ArtifactId.SENTINEL)).isInvalid()) continue;
                IAtsWorkDefinition workDefinition = workItem.getWorkDefinition();
                if (workDefinition == null) {
                    rd.error(String.format("null Work Definition for %s", workItem.toStringWithId()));
                    continue;
                }
                changes.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.WorkflowDefinitionReference, (Object)workDefinition);
                ++updatedCount;
            }
            changes.executeIfNeeded();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        rd.logf("Updtated %s Work Items\n", new Object[]{updatedCount});
    }

    private void convertMissingWorkItemWorkDefRefAttribute(XResultData rd) {
        LinkedList artIdList = new LinkedList();
        artIdList.addAll(this.atsApi.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andNotExists((AttributeTypeId)AtsAttributeTypes.WorkflowDefinitionReference).getItemIds());
        List subDivide = Collections.subDivide(artIdList, (int)500);
        int size = subDivide.size();
        int count = 1;
        int updatedCount = 0;
        for (Collection artIds : subDivide) {
            rd.logf(String.format("WorkItem Set: Processing %s / %s\n", count++, size), new Object[0]);
            LinkedList<Long> ids = new LinkedList<Long>();
            for (ArtifactId art : artIds) {
                ids.add(art.getId());
            }
            Collection allArtifacts = this.atsApi.getQueryService().getArtifacts(ids);
            IAtsChangeSet changes = this.atsApi.createChangeSet("Update Workflow Definition");
            for (ArtifactToken art : allArtifacts) {
                ArtifactId workDefArt;
                IAtsWorkItem workItem = this.atsApi.getWorkItemService().getWorkItem(art);
                boolean deleted = this.atsApi.getStoreService().isDeleted((IAtsObject)workItem);
                if (deleted || !(workDefArt = (ArtifactId)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)art, (AttributeTypeToken)AtsAttributeTypes.WorkflowDefinitionReference, (Object)ArtifactId.SENTINEL)).isInvalid()) continue;
                IAtsWorkDefinition workDefinition = workItem.getWorkDefinition();
                if (workDefinition == null) {
                    rd.error(String.format("null Work Definition for %s", workItem.toStringWithId()));
                    continue;
                }
                changes.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.WorkflowDefinitionReference, (Object)workDefinition);
                ++updatedCount;
            }
            changes.executeIfNeeded();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        rd.logf("Updtated %s Work Items\n", new Object[]{updatedCount});
    }

    private void convertMissingTeamWorkFlowWorkDefAttributes(XResultData rd) {
        int updatedCount = 0;
        int count = 0;
        IAtsChangeSet changes = this.atsApi.createChangeSet("Update Team Workflow Related Task WorkDef");
        Collection workItems = this.atsApi.getQueryService().createQuery(WorkItemType.TeamWorkflow, new WorkItemType[0]).andExists((AttributeTypeToken)AtsAttributeTypes.RelatedTaskWorkflowDefinition).getItems();
        int size = workItems.size();
        for (IAtsWorkItem workItem : workItems) {
            boolean deleted = this.atsApi.getStoreService().isDeleted((IAtsObject)workItem);
            if (deleted) continue;
            rd.logf(String.format("TeamWfs TaskRel: Processing WorkItem WorkDef Set %s / %s", count++, size), new Object[0]);
            updatedCount = this.setNewWorkDefRefIfNecessary(rd, updatedCount, changes, workItem.getStoreObject(), (AttributeTypeToken)AtsAttributeTypes.RelatedTaskWorkflowDefinition, (AttributeTypeToken)AtsAttributeTypes.RelatedTaskWorkflowDefinitionReference);
        }
        changes.executeIfNeeded();
        rd.logf("Updtated %s Work Items for Related Task Work Def\n", new Object[]{updatedCount});
    }

    private void convertMissingTeamDefinitionWorkDefAttributes(XResultData rd) {
        HashMap<AttributeTypeString, AttributeTypeArtifactId> oldAttrTypeToNewTypeMap = new HashMap<AttributeTypeString, AttributeTypeArtifactId>();
        oldAttrTypeToNewTypeMap.put(AtsAttributeTypes.WorkflowDefinition, AtsAttributeTypes.WorkflowDefinitionReference);
        oldAttrTypeToNewTypeMap.put(AtsAttributeTypes.RelatedTaskWorkflowDefinition, AtsAttributeTypes.RelatedTaskWorkflowDefinitionReference);
        oldAttrTypeToNewTypeMap.put(AtsAttributeTypes.RelatedPeerWorkflowDefinition, AtsAttributeTypes.RelatedPeerWorkflowDefinitionReference);
        HashSet artifacts = new HashSet();
        for (Map.Entry entry : oldAttrTypeToNewTypeMap.entrySet()) {
            artifacts.addAll(this.orcsApi.getQueryFactory().fromBranch((BranchId)this.atsApi.getAtsBranch()).andIsOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamDefinition}).andExists(new AttributeTypeId[]{(AttributeTypeId)entry.getKey()}).getResults().getList());
        }
        int size = artifacts.size();
        int count = 1;
        int updatedCount = 0;
        IAtsChangeSet changes = this.atsApi.createChangeSet("Update Team Def Workflow Definition");
        for (ArtifactToken teamDefArt : artifacts) {
            boolean deleted = this.atsApi.getStoreService().isDeleted((ArtifactId)teamDefArt);
            if (deleted) continue;
            System.err.println(String.format("TeamDef: Processing %s / %s", count++, size));
            for (Map.Entry entry : oldAttrTypeToNewTypeMap.entrySet()) {
                AttributeTypeToken oldAttrType = (AttributeTypeToken)entry.getKey();
                AttributeTypeToken newAttrType = (AttributeTypeToken)entry.getValue();
                updatedCount = this.setNewWorkDefRefIfNecessary(rd, updatedCount, changes, teamDefArt, oldAttrType, newAttrType);
            }
        }
        changes.executeIfNeeded();
        rd.logf("Updtated %s Team Def Attributes\n", new Object[]{updatedCount});
        System.gc();
    }

    private int setNewWorkDefRefIfNecessary(XResultData rd, int updatedCount, IAtsChangeSet changes, ArtifactToken artifact, AttributeTypeToken oldAttrType, AttributeTypeToken newAttrType) {
        ArtifactId newWorkDefArt;
        String oldWorkDefName = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)artifact, oldAttrType, (Object)"");
        if (Strings.isValid((String)oldWorkDefName) && (newWorkDefArt = (ArtifactId)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)artifact, newAttrType, (Object)ArtifactId.SENTINEL)).isInvalid()) {
            IAtsWorkDefinition workDefinition = this.atsApi.getWorkDefinitionService().getWorkDefinitionByName(oldWorkDefName);
            if (workDefinition == null || workDefinition.isInvalid()) {
                rd.error(String.format("null/invalid Work Definition for work def name [%s] and art %s", oldWorkDefName, artifact));
            } else {
                changes.setSoleAttributeValue((ArtifactId)artifact, newAttrType, (Object)workDefinition);
                ++updatedCount;
            }
        }
        return updatedCount;
    }
}

