/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.notify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.ats.api.notify.AtsNotificationEvent;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.ats.core.users.AtsUsersUtility;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.mail.api.MailMessage;
import org.eclipse.osee.mail.api.MailService;

public class SendNotificationEvents {
    private final Log logger;
    private final Collection<? extends AtsNotificationEvent> notificationEvents;
    private final String subject;
    private final String body;
    private final MailService mailService;
    private final String fromUserEmail;
    private final String testingUserEmail;
    private final IAtsUserService userService;

    protected SendNotificationEvents(Log logger, MailService mailService, String fromUserEmail, String testingUserEmail, String subject, String body, Collection<? extends AtsNotificationEvent> notificationEvents, IAtsUserService userService) {
        this.logger = logger;
        this.mailService = mailService;
        this.fromUserEmail = fromUserEmail;
        this.testingUserEmail = testingUserEmail;
        this.subject = subject;
        this.body = body;
        this.notificationEvents = notificationEvents;
        this.userService = userService;
        if (this.isTesting()) {
            logger.error("OseeNotifyUsersJob: testing is enabled....turn off for production.", new Object[0]);
        }
    }

    public Result run() {
        try {
            HashSet uniqueUusers = new HashSet();
            for (AtsNotificationEvent atsNotificationEvent : this.notificationEvents) {
                uniqueUusers.addAll(AtsUsersUtility.getUsers((Collection)atsNotificationEvent.getUserIds(), (IAtsUserService)this.userService));
            }
            XResultData xResultData = new XResultData();
            if (this.isTesting()) {
                xResultData.errorf("Testing Results Report for Osee Notification; Email to user [%s].<br>", new Object[]{this.testingUserEmail});
            }
            for (IAtsUser user : AtsUsersUtility.getValidEmailUsers(uniqueUusers)) {
                ArrayList<AtsNotificationEvent> notifyEvents = new ArrayList<AtsNotificationEvent>();
                for (AtsNotificationEvent atsNotificationEvent : this.notificationEvents) {
                    if (!this.isTesting() && !AtsUsersUtility.getUsers((Collection)atsNotificationEvent.getUserIds(), (IAtsUserService)this.userService).contains(user)) continue;
                    notifyEvents.add(atsNotificationEvent);
                }
                this.notifyUser(user, notifyEvents, xResultData);
            }
            Set<String> uniqueEmailAddresses = this.getUniqueEmailAddresses(this.notificationEvents);
            if (!uniqueEmailAddresses.isEmpty()) {
                for (String email : uniqueEmailAddresses) {
                    ArrayList<AtsNotificationEvent> arrayList = new ArrayList<AtsNotificationEvent>();
                    for (AtsNotificationEvent atsNotificationEvent : this.notificationEvents) {
                        if (!atsNotificationEvent.getEmailAddresses().contains(email)) continue;
                        arrayList.add(atsNotificationEvent);
                    }
                    this.notifyUser(email, arrayList);
                }
            }
            return Result.TrueResult;
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex, "Error notifying users", new Object[0]);
            return new Result("Error notifying users [%s]", new Object[]{ex.getMessage()});
        }
    }

    private Set<String> getUniqueEmailAddresses(Collection<? extends AtsNotificationEvent> notificationEvents) {
        HashSet<String> uniqueEmails = new HashSet<String>();
        for (AtsNotificationEvent atsNotificationEvent : notificationEvents) {
            uniqueEmails.addAll(atsNotificationEvent.getEmailAddresses());
        }
        return uniqueEmails;
    }

    private String notificationEventsToHtml(List<AtsNotificationEvent> notificationEvents) {
        StringBuffer sb = new StringBuffer();
        sb.append(AHTML.beginMultiColumnTable((int)100, (int)1));
        boolean anyCancelable = this.isAnyCancelable(notificationEvents);
        if (anyCancelable) {
            sb.append(AHTML.addHeaderRowMultiColumnTable((String[])new String[]{"Reason", "Description", "Id", "Cancel"}));
        } else {
            sb.append(AHTML.addHeaderRowMultiColumnTable((String[])new String[]{"Reason", "Description", "Id"}));
        }
        for (AtsNotificationEvent notificationEvent : notificationEvents) {
            if (anyCancelable) {
                sb.append(AHTML.addRowMultiColumnTable((String[])new String[]{notificationEvent.getType(), notificationEvent.getDescription(), this.getHyperlink(notificationEvent), this.getCancelHyperlink(notificationEvent)}));
                continue;
            }
            sb.append(AHTML.addRowMultiColumnTable((String[])new String[]{notificationEvent.getType(), notificationEvent.getDescription(), this.getHyperlink(notificationEvent)}));
        }
        sb.append(AHTML.endMultiColumnTable());
        return sb.toString().replaceAll("\n", "");
    }

    private boolean isAnyCancelable(List<AtsNotificationEvent> notificationEvents) {
        for (AtsNotificationEvent notificationEvent : notificationEvents) {
            if (!Strings.isValid((String)notificationEvent.getCancelUrl())) continue;
            return true;
        }
        return false;
    }

    private String getHyperlink(AtsNotificationEvent notificationEvent) {
        return Strings.isValid((String)notificationEvent.getUrl()) ? AHTML.getHyperlink((String)notificationEvent.getUrl(), (String)notificationEvent.getId()) : "";
    }

    private String getCancelHyperlink(AtsNotificationEvent notificationEvent) {
        return Strings.isValid((String)notificationEvent.getCancelUrl()) ? AHTML.getHyperlink((String)notificationEvent.getCancelUrl(), (String)"Cancel") : "";
    }

    private void notifyUser(IAtsUser user, List<AtsNotificationEvent> notificationEvents, XResultData resultData) {
        if (AtsCoreUsers.isAtsCoreUser((IAtsUser)user)) {
            return;
        }
        String email = user.getEmail();
        this.notifyUser(email, notificationEvents);
    }

    private void notifyUser(String email, List<AtsNotificationEvent> notificationEvents) {
        if (!AtsUsersUtility.isEmailValid((String)email)) {
            return;
        }
        String html = "";
        if (Strings.isValid((String)this.body)) {
            html = String.valueOf(html) + "<pre>" + this.body + "</pre>";
        }
        html = String.valueOf(html) + this.notificationEventsToHtml(notificationEvents);
        if (!Strings.isValid((String)email)) {
            return;
        }
        String useEmail = this.isTesting() ? this.testingUserEmail : email;
        MailMessage msg = MailMessage.newBuilder().from(this.fromUserEmail).recipients(Arrays.asList(useEmail)).subject(this.getNotificationEmailSubject(notificationEvents)).addHtml(html).build();
        List sendMessages = this.mailService.sendMessages(new MailMessage[]{msg});
        System.out.println(sendMessages);
    }

    private boolean isTesting() {
        return Strings.isValid((String)this.testingUserEmail);
    }

    private String getNotificationEmailSubject(List<AtsNotificationEvent> notificationEvents) {
        String result = this.subject;
        if (!Strings.isValid((String)result)) {
            if (notificationEvents.size() == 1) {
                AtsNotificationEvent event = notificationEvents.iterator().next();
                result = Strings.truncate((String)("OSEE Notification - " + event.getType() + " - " + event.getDescription()), (int)128);
            } else {
                result = "OSEE Notification";
            }
        }
        return result;
    }
}

