/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.convert;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.rest.internal.convert.AbstractConvertGuidToId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class ConvertFavoriteBranchGuidToId
extends AbstractConvertGuidToId {
    private int numChanges = 0;

    public ConvertFavoriteBranchGuidToId(Log logger, JdbcClient jdbcClient, OrcsApi orcsApi, AtsApi atsApi) {
        super(logger, jdbcClient, orcsApi, atsApi);
    }

    public String getName() {
        return "FavoriteBranchGuidToId";
    }

    public String getDescription() {
        StringBuffer data = new StringBuffer();
        data.append("ConvertFavoriteBranchGuidToId (required conversion)\n\n");
        data.append("Necessary for upgrading from OSEE 0.16.2 to 0.17.0\n");
        data.append("-- Converts a User's Favorite Branch Guid(s) to Id(s).\n\n");
        data.append("NOTE: This operation can be run multiple times\n");
        return data.toString();
    }

    public void run(XResultData data, boolean reportOnly, AtsApi atsApi) {
        if (reportOnly) {
            data.log("REPORT ONLY - Changes not persisted\n");
        }
        try {
            QueryFactory queryFactory = this.getOrcsApi().getQueryFactory();
            TransactionBuilder tx = this.createTransactionBuilder();
            for (ArtifactReadable art : this.getUsersFavoriteBranch(queryFactory)) {
                this.convertAttributeToId(data, reportOnly, tx, art, art.getAttributes((AttributeTypeId)CoreAttributeTypes.FavoriteBranch));
            }
            if (reportOnly) {
                data.log("\n" + this.numChanges + " Need to be Changed");
            } else {
                data.log("\n" + this.numChanges + " Changes Persisted");
                if (this.numChanges > 0) {
                    tx.commit();
                }
            }
            this.numChanges = 0;
        }
        catch (OseeCoreException ex) {
            this.getLogger().error((Throwable)ex, "Exception occurred while trying to convert branch guid to id", new Object[0]);
        }
    }

    private void convertAttributeToId(XResultData data, boolean reportOnly, TransactionBuilder tx, ArtifactReadable art, ResultSet<? extends AttributeReadable<?>> favBranchAttrValues) {
        for (AttributeReadable attr : favBranchAttrValues) {
            String value = attr.toString();
            if (GUID.isValid((String)value)) {
                this.convert(data, reportOnly, tx, art, attr, value);
                continue;
            }
            data.logf("Not a guid attribute value.  Actual value [%s] for artifact type [%s] name [%s] id [%s] NOT converted to id.\n \n", new Object[]{value, art.getArtifactType(), art.getName(), art.getId()});
        }
    }

    private void convert(XResultData data, boolean reportOnly, TransactionBuilder tx, ArtifactReadable art, AttributeReadable<?> attr, String value) {
        BranchId branch = null;
        try {
            branch = this.getBranch(value);
        }
        catch (OseeCoreException ex) {
            this.getLogger().warn((Throwable)ex, "No Branch found with value: [%s]", new Object[]{value});
        }
        if (branch != null) {
            this.addId(data, reportOnly, tx, art, attr, branch);
        } else {
            this.removeAttrForNonExistentBranch(data, reportOnly, tx, art, attr, value);
        }
    }

    private void addId(XResultData data, boolean reportOnly, TransactionBuilder tx, ArtifactReadable art, AttributeReadable<?> attr, BranchId branch) {
        ++this.numChanges;
        data.logf("Adding id attribute of value %s to artifact type [%s] name [%s] id [%s]\n", new Object[]{branch, art.getArtifactType(), art.getName(), art.getId()});
        if (!reportOnly) {
            try {
                tx.setAttributeById((ArtifactId)art, attr, branch.getIdString());
            }
            catch (OseeCoreException oseeCoreException) {
                data.errorf("Error building transaction for convert to id attribute of value %s for artifact type [%s] name [%s] id [%s]\n", new Object[]{branch, art.getArtifactType(), art.getName(), art.getId()});
            }
        }
    }

    private void removeAttrForNonExistentBranch(XResultData data, boolean reportOnly, TransactionBuilder tx, ArtifactReadable art, AttributeReadable<?> attr, String value) {
        try {
            data.logf("No Branch found with value [%s]. Recommend removing attribute.\n", new Object[]{value});
            if (!reportOnly) {
                tx.deleteByAttributeId((ArtifactId)art, attr);
            }
        }
        catch (OseeCoreException oseeCoreException) {
            data.errorf("Error building transaction to remove guid [%s] for branch that no longer exists\n", new Object[]{value});
        }
    }

    private ResultSet<ArtifactReadable> getUsersFavoriteBranch(QueryFactory queryFactory) {
        return queryFactory.fromBranch((BranchId)this.atsApi.getAtsBranch()).andTypeEquals(new ArtifactTypeId[]{CoreArtifactTypes.User}).andExists(new AttributeTypeId[]{CoreAttributeTypes.FavoriteBranch}).getResults();
    }
}

