/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="user")
public final class UserResource {
    private final IAtsUserService userService;

    public UserResource(IAtsUserService userService) {
        this.userService = userService;
    }

    @GET
    @Produces(value={"application/json"})
    public String get(@QueryParam(value="active") String activeStr) throws Exception {
        Active active = Active.Both;
        if (Strings.isValid((String)activeStr)) {
            active = Active.valueOf((String)activeStr);
        }
        JSONArray arr = new JSONArray();
        for (IAtsUser user : this.userService.getUsers(active)) {
            JSONObject obj = new JSONObject();
            obj.put("id", (Object)user.getUserId());
            obj.put("name", (Object)user.getName());
            obj.put("email", (Object)user.getEmail());
            obj.put("active", user.isActive());
            obj.put("accountId", (Object)user.getStoreObject().getId());
            arr.put((Object)obj);
        }
        return arr.toString();
    }
}

