/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.config.AtsAttributeValueColumn;
import org.eclipse.osee.ats.api.config.AtsConfigEndpointApi;
import org.eclipse.osee.ats.api.config.AtsConfiguration;
import org.eclipse.osee.ats.api.config.AtsConfigurations;
import org.eclipse.osee.ats.api.config.ColumnAlign;
import org.eclipse.osee.ats.api.data.AtsArtifactImages;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.rest.internal.config.UpdateAtsConfiguration;
import org.eclipse.osee.ats.rest.internal.demo.DemoDatabaseConfig;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactImage;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IOseeBranch;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.executor.ExecutorAdmin;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.type.ViewModel;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public final class AtsConfigEndpointImpl
implements AtsConfigEndpointApi {
    private final OrcsApi orcsApi;
    private final AtsApi atsApi;
    private final Log logger;
    private final ExecutorAdmin executorAdmin;
    private List<ArtifactImage> images;
    private final Runnable getConfigService = new Runnable(){

        @Override
        public void run() {
            AtsConfigEndpointImpl.this.atsApi.getConfigService().getConfigurationsWithPend();
        }
    };

    public AtsConfigEndpointImpl(AtsApi atsApi, OrcsApi orcsApi, Log logger, ExecutorAdmin executorAdmin) {
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
        this.logger = logger;
        this.executorAdmin = executorAdmin;
    }

    public String requestCacheReload() {
        this.executorAdmin.submit("REST requested ATS configuration cache reload", this.getConfigService);
        return "ATS configuration cache reload request submitted.";
    }

    public AtsConfigurations get() {
        return this.atsApi.getConfigService().getConfigurations();
    }

    public List<ArtifactImage> getArtifactImages() {
        if (this.images == null) {
            this.images = new LinkedList<ArtifactImage>();
            this.images.addAll(AtsArtifactImages.getImages());
            for (ArtifactTypeToken artifactType : this.atsApi.getStoreService().getTeamWorkflowArtifactTypes()) {
                this.images.add(ArtifactImage.construct((ArtifactTypeToken)artifactType, (String)AtsArtifactImages.AGILE_TASK.getImageName(), (String)AtsArtifactImages.AGILE_TASK.getBaseUrl()));
            }
        }
        return this.images;
    }

    public AtsConfigurations getWithPend() {
        return this.atsApi.getConfigService().getConfigurationsWithPend();
    }

    public ViewModel getNewSource() {
        return new ViewModel("templates/newConfigBranch.html");
    }

    public AtsConfiguration createConfig(MultivaluedMap<String, String> form) {
        BranchId fromBranchId = BranchId.valueOf((String)((String)form.getFirst((Object)"fromBranchid")));
        String newBranchName = (String)form.getFirst((Object)"newBranchName");
        Conditions.checkNotNullOrEmpty((String)newBranchName, (String)"newBranchName");
        String userId = (String)form.getFirst((Object)"userId");
        Conditions.checkNotNullOrEmpty((String)userId, (String)"UserId");
        IAtsUser user = this.atsApi.getUserService().getUserById(userId);
        if (user == null) {
            this.logger.error("User by id [%s] does not exist", new Object[]{userId});
        }
        BranchId fromBranch = (BranchId)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(fromBranchId)).getResults().getExactlyOne();
        IOseeBranch newBranch = this.orcsApi.getBranchOps().createTopLevelBranch(IOseeBranch.create((String)newBranchName), (ArtifactId)user);
        this.introduceAtsHeadingArtifacts(fromBranch, (BranchId)newBranch, (UserId)user);
        AtsConfiguration config = this.createConfigArtifactOnCommon(newBranchName, (UserId)user, (BranchId)newBranch);
        return config;
    }

    private void introduceAtsHeadingArtifacts(BranchId fromBranch, BranchId newBranch, UserId userId) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(newBranch, userId, "Add ATS Configuration");
        ArtifactId headingArt = this.introduceAndRelateTo(tx, fromBranch, AtsArtifactToken.HeadingFolder, newBranch, CoreArtifactTokens.OseeConfiguration, null);
        this.introduceAndRelateTo(tx, fromBranch, (ArtifactToken)AtsArtifactToken.TopActionableItem, newBranch, null, headingArt);
        this.introduceAndRelateTo(tx, fromBranch, (ArtifactToken)AtsArtifactToken.TopTeamDefinition, newBranch, null, headingArt);
        ArtifactId configArt = this.introduceAndRelateTo(tx, fromBranch, AtsArtifactToken.HeadingFolder, newBranch, null, headingArt);
        this.introduceAndRelateTo(tx, fromBranch, AtsArtifactToken.ConfigsFolder, newBranch, null, configArt);
        this.introduceAndRelateTo(tx, fromBranch, AtsArtifactToken.Users, newBranch, null, configArt);
        tx.commit();
    }

    private ArtifactId introduceAndRelateTo(TransactionBuilder tx, BranchId fromBranch, ArtifactToken introToken, BranchId newBranch, ArtifactToken parentToken, ArtifactId parentArt) {
        ArtifactReadable introArt = (ArtifactReadable)this.orcsApi.getQueryFactory().fromBranch(fromBranch).andId((ArtifactId)introToken).getResults().getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (introArt.getId().equals(ArtifactReadable.SENTINEL.getId())) {
            introArt = (ArtifactReadable)this.orcsApi.getQueryFactory().fromBranch(fromBranch).andTypeEquals(new ArtifactTypeId[]{introToken.getArtifactType()}).andNameEquals(introToken.getName()).getResults().getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
        }
        Conditions.assertNotSentinel((Id)introArt);
        ArtifactToken artifact = tx.introduceArtifact(fromBranch, (ArtifactId)introArt);
        if (parentToken != null && !parentToken.getId().equals(Id.SENTINEL) && (parentArt = (ArtifactId)this.orcsApi.getQueryFactory().fromBranch(newBranch).andId((ArtifactId)parentToken).getResults().getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL)).getId().equals(ArtifactReadable.SENTINEL.getId())) {
            parentArt = (ArtifactId)this.orcsApi.getQueryFactory().fromBranch(newBranch).andTypeEquals(new ArtifactTypeId[]{parentToken.getArtifactType()}).andNameEquals(parentToken.getName()).getResults().getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
        }
        tx.addChild(parentArt, (ArtifactId)artifact);
        return artifact;
    }

    private AtsConfiguration createConfigArtifactOnCommon(String branchName, UserId userId, BranchId branch) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, userId, "Add ATS Configuration");
        AtsConfiguration config = new AtsConfiguration();
        config.setName(branchName);
        config.setBranchId(branch);
        config.setIsDefault(false);
        ArtifactToken configArt = tx.createArtifact(AtsArtifactTypes.Configuration, branchName);
        config.setArtifactId((ArtifactId)configArt);
        tx.createAttribute((ArtifactId)configArt, (AttributeTypeToken)AtsAttributeTypes.AtsConfiguredBranch, (Object)branch.getIdString());
        XResultData rd = new XResultData();
        UpdateAtsConfiguration update = new UpdateAtsConfiguration(this.atsApi, this.orcsApi);
        ArtifactId configsFolderArt = update.getOrCreateConfigsFolder(userId, rd);
        if (rd.isErrors()) {
            throw new OseeStateException(rd.toString(), new Object[0]);
        }
        tx.relate(configsFolderArt, (RelationTypeToken)CoreRelationTypes.Default_Hierarchical__Child, (ArtifactId)configArt);
        tx.commit();
        return config;
    }

    public XResultData createUpdateConfig() {
        XResultData resultData = new XResultData(false);
        UpdateAtsConfiguration update = new UpdateAtsConfiguration(this.atsApi, this.orcsApi);
        update.createUpdateConfig(resultData);
        if (resultData.isEmpty()) {
            resultData.log("Nothing to update");
        }
        return resultData;
    }

    public List<AtsAttributeValueColumn> generateAttrTypeViews() throws Exception {
        HashMap<String, AttributeTypeToken> idToToken = new HashMap<String, AttributeTypeToken>();
        for (AttributeTypeToken attrType : this.orcsApi.getOrcsTypes().getAttributeTypes().getAll()) {
            idToToken.put(attrType.getName(), attrType);
        }
        LinkedList sortedIds = new LinkedList();
        sortedIds.addAll(idToToken.keySet());
        Collections.sort(sortedIds);
        LinkedList<AtsAttributeValueColumn> columns = new LinkedList<AtsAttributeValueColumn>();
        for (String id : sortedIds) {
            AttributeTypeToken attrType = (AttributeTypeToken)idToToken.get(id);
            ColumnAlign columnAlign = ColumnAlign.Left;
            SortDataType sortDataType = SortDataType.String;
            int width = 60;
            boolean isBoolean = this.orcsApi.getOrcsTypes().getAttributeTypes().isBooleanType((AttributeTypeId)attrType);
            if (this.orcsApi.getOrcsTypes().getAttributeTypes().isEnumerated((AttributeTypeId)attrType)) {
                width = 40;
            } else if (isBoolean) {
                width = 50;
            } else if (this.orcsApi.getOrcsTypes().getAttributeTypes().isIntegerType((AttributeTypeId)attrType)) {
                width = 45;
                sortDataType = SortDataType.Integer;
                columnAlign = ColumnAlign.Center;
            } else if (this.orcsApi.getOrcsTypes().getAttributeTypes().isFloatingType((AttributeTypeId)attrType)) {
                width = 40;
                sortDataType = SortDataType.Float;
                columnAlign = ColumnAlign.Center;
            } else if (this.orcsApi.getOrcsTypes().getAttributeTypes().isDateType((AttributeTypeId)attrType)) {
                width = 80;
                sortDataType = SortDataType.Date;
            }
            AtsAttributeValueColumn valueColumn = new AtsAttributeValueColumn();
            valueColumn.setAttrTypeId(attrType.getId().longValue());
            valueColumn.setAttrTypeName(attrType.getName());
            valueColumn.setWidth(width);
            valueColumn.setAlign(columnAlign);
            valueColumn.setVisible(true);
            valueColumn.setSortDataType(sortDataType.name());
            valueColumn.setColumnMultiEdit(true);
            valueColumn.setDescription(attrType.getDescription());
            valueColumn.setNamespace("org.eclipse.osee.ats.WorldXViewer");
            String name = attrType.getName().replaceAll("^.*\\.", "");
            valueColumn.setName(name);
            valueColumn.setId(this.generateId(attrType.getName(), name));
            if (isBoolean) {
                valueColumn.setBooleanNotSetShow("");
                valueColumn.setBooleanOnFalseShow("false");
                valueColumn.setBooleanOnTrueShow("true");
            }
            columns.add(valueColumn);
        }
        return columns;
    }

    private String generateId(String id, String name) {
        System.err.println(String.format("\nid [%s] name [%s]", id, name));
        String cleanName = name.replaceAll("-", " ");
        cleanName = cleanName.replaceAll("\\(", " ");
        cleanName = cleanName.replaceAll("\\)", " ");
        cleanName = cleanName.replaceAll("/", " ");
        cleanName = cleanName.replaceAll(" +", " ");
        cleanName = cleanName.replaceAll("^ ", "");
        System.err.println(String.format("cleanName [%s]", cleanName));
        String replaceValue = Lib.toCamelCaseFromStringsWithSpaces((String)cleanName);
        System.err.println(String.format("replaceValue [%s]", replaceValue));
        String result = id.replaceFirst(Lib.escapeForRegex((String)name), replaceValue);
        System.err.println(String.format("result [%s]", result));
        return result;
    }

    public XResultData alive() {
        XResultData results = new XResultData();
        results.logf("Alive", new Object[0]);
        return results;
    }

    public XResultData demoDbInit() {
        XResultData rd = new XResultData();
        try {
            DemoDatabaseConfig config = new DemoDatabaseConfig(this.atsApi);
            config.run();
        }
        catch (Exception ex) {
            rd.error(Lib.exceptionToString((Exception)ex));
        }
        return rd;
    }

    public XResultData atsDbInit() {
        XResultData rd = new XResultData();
        try {
            rd = this.atsApi.getConfigService().configAtsDatabase(this.atsApi);
        }
        catch (Exception ex) {
            rd.error(Lib.exceptionToString((Exception)ex));
        }
        return rd;
    }
}

