/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osee.define.rest.internal.SafetyCriticalityLookup;
import org.eclipse.osee.define.rest.internal.SafetyReportGenerator;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ISheetWriter;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;

public final class SafetyInformationAccumulator {
    private final ISheetWriter writer;
    private final SafetyReportGenerator safetyReport;
    private String functionalCategory;
    private List<ArtifactReadable> subsystemFunctions;
    private final HashMap<ArtifactReadable, List<ArtifactReadable>> subsystemRequirements = Maps.newHashMap();
    private final HashMap<ArtifactReadable, List<ArtifactReadable>> softwareRequirements = Maps.newHashMap();
    private static final Predicate<ArtifactReadable> notSoftwareRequirement = new Predicate<ArtifactReadable>(){

        public boolean apply(ArtifactReadable input) {
            boolean toReturn = true;
            try {
                toReturn = !input.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.SoftwareRequirement});
            }
            catch (OseeCoreException oseeCoreException) {}
            return toReturn;
        }
    };

    public SafetyInformationAccumulator(SafetyReportGenerator providedSafetyReport, ISheetWriter providedWriter) {
        this.safetyReport = providedSafetyReport;
        this.writer = providedWriter;
    }

    public String calculateBoeingEquivalentSWQualLevel(String softwareReqDAL, int partitionCount) {
        String toReturn = "";
        if (this.functionalCategory.equals("IFR/IMC")) {
            toReturn = this.checkLevel(softwareReqDAL) ? (partitionCount > 1 ? "C*" : "C") : "BP";
        } else if (this.functionalCategory.equals("Tactical")) {
            toReturn = "BP";
        }
        return toReturn;
    }

    public void reset(ArtifactReadable systemFunction) {
        this.functionalCategory = systemFunction.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.FunctionalCategory, "");
        this.subsystemRequirements.clear();
        this.softwareRequirements.clear();
    }

    public void buildSubsystemsRequirementsMap(ArtifactReadable systemFunction) {
        this.subsystemFunctions = Lists.newArrayList((Iterable)systemFunction.getRelated(CoreRelationTypes.Dependency__Dependency));
        Iterator<ArtifactReadable> sfIter = this.subsystemFunctions.iterator();
        while (sfIter.hasNext()) {
            ArtifactReadable subsystemFunction = sfIter.next();
            List<ArtifactReadable> localSubsystemRequirements = this.checkSubsystemRequirements(subsystemFunction);
            if (localSubsystemRequirements.isEmpty()) {
                sfIter.remove();
                continue;
            }
            this.subsystemRequirements.put(subsystemFunction, localSubsystemRequirements);
        }
    }

    private List<ArtifactReadable> checkSubsystemRequirements(ArtifactReadable subsystemFunction) {
        ArrayList localSubsystemRequirements = Lists.newArrayList((Iterable)subsystemFunction.getRelated(CoreRelationTypes.Design__Requirement));
        Iterator ssrIter = localSubsystemRequirements.iterator();
        while (ssrIter.hasNext()) {
            ArtifactReadable subsystemRequirement = (ArtifactReadable)ssrIter.next();
            ArrayList localSoftwareRequirements = Lists.newArrayList((Iterable)subsystemRequirement.getRelated(CoreRelationTypes.Requirement_Trace__Lower_Level));
            Iterables.removeIf((Iterable)localSoftwareRequirements, notSoftwareRequirement);
            if (localSoftwareRequirements.isEmpty()) {
                ssrIter.remove();
                continue;
            }
            this.softwareRequirements.put(subsystemRequirement, localSoftwareRequirements);
        }
        return localSubsystemRequirements;
    }

    public void output() throws IOException {
        for (ArtifactReadable subsystemFunction : this.subsystemFunctions) {
            this.processSubsystemFunction(subsystemFunction);
            this.writer.endRow();
        }
    }

    private boolean checkLevel(String input) {
        boolean toReturn = false;
        if (input.equals("A") || input.equals("B") || input.equals("C")) {
            toReturn = true;
        }
        return toReturn;
    }

    private String convertSafetyCriticalityToDAL(String inputSafetyCriticality) {
        if (inputSafetyCriticality.length() > 4) {
            return "Error";
        }
        return SafetyCriticalityLookup.getDALLevelFromSeverityCategory(inputSafetyCriticality);
    }

    private void processSubsystemFunction(ArtifactReadable subsystemFunction) throws IOException {
        this.writer.writeCell((Object)subsystemFunction.getName(), SafetyReportGenerator.SUBSYSTEM_FUNCTION_INDEX);
        String sevCat = subsystemFunction.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.SeverityCategory, "Error: not available");
        this.writer.writeCell((Object)sevCat);
        this.writer.writeCell((Object)subsystemFunction.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.FDAL, ""));
        this.writer.writeCell((Object)subsystemFunction.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.FdalRationale, ""));
        for (ArtifactReadable subsystemRequirement : this.subsystemRequirements.get(subsystemFunction)) {
            this.processSubsystemRequirement(subsystemRequirement, this.convertSafetyCriticalityToDAL(sevCat));
        }
        this.writer.endRow();
    }

    private void processSubsystemRequirement(ArtifactReadable subsystemRequirement, String criticality) throws IOException {
        this.writer.writeCell((Object)subsystemRequirement.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Subsystem, ""), SafetyReportGenerator.SUBSYSTEM_INDEX);
        this.writer.writeCell(subsystemRequirement.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber, (Object)""));
        this.writer.writeCell((Object)subsystemRequirement.getName());
        this.writer.writeCell((Object)subsystemRequirement.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.IDAL, ""));
        this.writer.writeCell((Object)subsystemRequirement.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.IdalRationale, ""));
        for (ArtifactReadable softwareRequirement : this.softwareRequirements.get(subsystemRequirement)) {
            this.processSoftwareRequirement(softwareRequirement);
        }
        this.writer.endRow();
    }

    private String writeCriticality(ArtifactReadable art, AttributeTypeToken thisType) throws IOException {
        String current = art.getSoleAttributeAsString(thisType, "Error");
        if ("Unspecified".equals(current)) {
            this.writer.writeCell((Object)"Unspecified");
        }
        this.writer.writeCell((Object)current);
        return current;
    }

    private void processSoftwareRequirement(ArtifactReadable softwareRequirement) throws IOException {
        this.writer.writeCell((Object)softwareRequirement.getName(), SafetyReportGenerator.SOFTWARE_REQUIREMENT_INDEX);
        String softwareRequirementDAL = this.writeCriticality(softwareRequirement, (AttributeTypeToken)CoreAttributeTypes.IDAL);
        this.writer.writeCell((Object)softwareRequirement.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.IdalRationale, ""));
        this.writer.writeCell((Object)this.calculateBoeingEquivalentSWQualLevel(softwareRequirementDAL, softwareRequirement.getAttributeCount((AttributeTypeToken)CoreAttributeTypes.Partition)));
        this.writer.writeCell((Object)this.functionalCategory);
        this.writer.writeCell((Object)Collections.toString((String)",", this.getAttributesToStringList(softwareRequirement, (AttributeTypeToken)CoreAttributeTypes.Partition)));
        this.writer.writeCell((Object)this.safetyReport.getComponentUtil().getQualifiedComponentNames(softwareRequirement));
        Collection<String> codeUnits = this.safetyReport.getRequirementToCodeUnitsValues(softwareRequirement);
        if (Conditions.hasValues(codeUnits)) {
            for (String codeUnit : codeUnits) {
                this.writer.writeCell((Object)codeUnit, SafetyReportGenerator.CODE_UNIT_INDEX);
                this.writer.endRow();
            }
        } else {
            this.writer.endRow();
        }
    }

    public List<String> getAttributesToStringList(ArtifactReadable artifact, AttributeTypeToken attributeType) {
        ArrayList<String> items = new ArrayList<String>();
        for (AttributeReadable attribute : artifact.getAttributes((AttributeTypeId)attributeType)) {
            items.add(attribute.getDisplayableString());
        }
        return items;
    }
}

