/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.app.OseeAppResourceTokens;
import org.eclipse.osee.define.api.DefineApi;
import org.eclipse.osee.define.rest.DataRightsEndpointImpl;
import org.eclipse.osee.define.rest.GitEndpointImpl;
import org.eclipse.osee.define.rest.ImportEndpointImpl;
import org.eclipse.osee.define.rest.MSWordEndpointImpl;
import org.eclipse.osee.define.rest.TraceabilityEndpointImpl;
import org.eclipse.osee.define.rest.internal.DataRightsSwReqAndCodeResource;
import org.eclipse.osee.define.rest.internal.DefineBranchEndpointImpl;
import org.eclipse.osee.define.rest.internal.SystemSafetyResource;
import org.eclipse.osee.framework.jdk.core.type.IResourceRegistry;
import org.eclipse.osee.framework.jdk.core.type.ResourceRegistry;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.orcs.OrcsApi;

@ApplicationPath(value="define")
public final class DefineApplication
extends Application {
    private final Set<Object> singletons = new HashSet<Object>();
    private OrcsApi orcsApi;
    private DefineApi defineApi;
    private ActivityLog activityLog;
    private JdbcService jdbcService;

    public void setDefineApi(DefineApi defineApi) {
        this.defineApi = defineApi;
    }

    public void setActivityLog(ActivityLog activityLog) {
        this.activityLog = activityLog;
    }

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public void setJdbcService(JdbcService jdbcService) {
        this.jdbcService = jdbcService;
    }

    public void start(Map<String, Object> properties) {
        ResourceRegistry resourceRegistry = new ResourceRegistry();
        OseeAppResourceTokens.register((IResourceRegistry)resourceRegistry);
        JdbcClient jdbcClient = this.jdbcService.getClient();
        this.singletons.add(new SystemSafetyResource(this.activityLog, (IResourceRegistry)resourceRegistry, this.orcsApi));
        this.singletons.add(new TraceabilityEndpointImpl(this.activityLog, (IResourceRegistry)resourceRegistry, this.orcsApi, this.defineApi));
        this.singletons.add(new GitEndpointImpl(this.activityLog, this.orcsApi, this.defineApi));
        this.singletons.add(new DataRightsSwReqAndCodeResource(this.activityLog, (IResourceRegistry)resourceRegistry, this.orcsApi));
        this.singletons.add(new DataRightsEndpointImpl(this.defineApi));
        this.singletons.add(new MSWordEndpointImpl(this.defineApi));
        this.singletons.add(new DefineBranchEndpointImpl(jdbcClient, this.orcsApi));
        this.singletons.add(new ImportEndpointImpl(this.defineApi));
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

