/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.util;

import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.db.internal.IdentityManager;

public class IdentityManagerImpl
implements IdentityManager {
    private final JdbcClient client;

    public IdentityManagerImpl(JdbcClient client) {
        this.client = client;
    }

    @Override
    public TransactionId getNextTransactionId() {
        return TransactionId.valueOf((Long)this.client.getNextSequence("SKYNET_TRANSACTION_ID_SEQ", false));
    }

    @Override
    public int getNextArtifactId() {
        return (int)this.client.getNextSequence("SKYNET_ART_ID_SEQ", true);
    }

    @Override
    public int getNextAttributeId() {
        return (int)this.client.getNextSequence("SKYNET_ATTR_ID_SEQ", true);
    }

    @Override
    public int getNextRelationId() {
        return (int)this.client.getNextSequence("SKYNET_REL_LINK_ID_SEQ", true);
    }

    @Override
    public GammaId getNextGammaId() {
        return GammaId.valueOf((Long)this.client.getNextSequence("SKYNET_GAMMA_ID_SEQ", true));
    }

    @Override
    public String getUniqueGuid(String guid) {
        String toReturn = guid;
        if (toReturn == null) {
            toReturn = GUID.create();
        }
        return toReturn;
    }

    @Override
    public Long parseToLocalId(String value) {
        return Long.valueOf(value);
    }

    @Override
    public void invalidateIds() {
        this.client.invalidateSequences();
    }
}

