/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import org.eclipse.osee.framework.core.enums.TableEnum;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelatedRecursive;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;

public class RelatedRecursiveHandler
extends SqlHandler<CriteriaRelatedRecursive> {
    private CriteriaRelatedRecursive criteria;
    private String cteAlias;
    private String artAlias;

    @Override
    public void writeCommonTableExpression(AbstractSqlWriter writer) {
        this.cteAlias = writer.startRecursiveCommonTableExpression("recurse", "(id, child_level)");
        writer.write("SELECT b_art_id, 1 FROM osee_relation_link WHERE ");
        writer.writeEqualsParameterAnd("a_art_id", this.criteria.getStartArtifact());
        writer.writeEqualsParameter("rel_link_type_id", this.criteria.getRelationType());
        writer.write(" UNION ALL\n");
        writer.write(" SELECT b_art_id, child_level + 1 FROM " + this.cteAlias);
        writer.write(", osee_relation_link rel, osee_txs txs");
        writer.write(" WHERE a_art_id = id AND rel_link_type_id = ? AND rel.gamma_id = txs.gamma_id AND ");
        writer.addParameter(this.criteria.getRelationType());
        writer.writeTxBranchFilter("txs");
    }

    @Override
    public void setData(CriteriaRelatedRecursive criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        writer.addTable(this.cteAlias);
        this.artAlias = writer.getMainTableAlias(TableEnum.ARTIFACT_TABLE);
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        writer.writeEquals(this.cteAlias, "id", this.artAlias, "art_id");
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.ARTIFACT_ID.ordinal();
    }
}

