/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.proxy;

import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.core.ds.DataProxy;
import org.eclipse.osee.orcs.data.AttributeTypes;
import org.eclipse.osee.orcs.db.internal.proxy.AbstractDataProxy;
import org.eclipse.osee.orcs.db.internal.proxy.Storage;
import org.eclipse.osee.orcs.db.internal.proxy.UriDataProxy;
import org.eclipse.osee.orcs.db.internal.proxy.VarCharDataProxy;

public class AttributeDataProxyFactory {
    private final AttributeTypes attributeTypeCache;
    private final IResourceManager resourceManager;
    private final Log logger;

    public AttributeDataProxyFactory(AttributeTypes attributeTypes, IResourceManager resourceManager, Log logger) {
        this.attributeTypeCache = attributeTypes;
        this.resourceManager = resourceManager;
        this.logger = logger;
    }

    public DataProxy createProxy(AttributeTypeId attributeType, Object value, String uri) {
        String attributeProviderId = this.attributeTypeCache.getAttributeProviderId(attributeType);
        Object checkedValue = this.intern(attributeType, value);
        AbstractDataProxy dataProxy = attributeProviderId.equals("UriAttributeDataProvider") || attributeProviderId.equals("MappedAttributeDataProvider") ? new UriDataProxy() : new VarCharDataProxy();
        dataProxy.setLogger(this.logger);
        dataProxy.setStorage(new Storage(this.resourceManager, dataProxy));
        dataProxy.setData(checkedValue, uri);
        return dataProxy;
    }

    private Object intern(AttributeTypeId attributeType, Object original) {
        Object value = original;
        if (this.attributeTypeCache.isEnumerated(attributeType) && value instanceof String) {
            value = Strings.intern((String)((String)value));
        }
        return value;
    }
}

