/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader.handlers;

import org.eclipse.osee.framework.core.enums.ObjectType;
import org.eclipse.osee.framework.core.enums.TableEnum;
import org.eclipse.osee.orcs.db.internal.loader.criteria.CriteriaArtifact;
import org.eclipse.osee.orcs.db.internal.loader.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;

public class ArtifactSqlHandler
extends SqlHandler<CriteriaArtifact> {
    private CriteriaArtifact criteria;
    private String jArtAlias;
    private String artAlias;
    private String txsAlias;

    @Override
    public int getPriority() {
        return SqlHandlerPriority.ARTIFACT_LOADER.ordinal();
    }

    @Override
    public void setData(CriteriaArtifact criteria) {
        this.criteria = criteria;
    }

    @Override
    public void writeSelectFields(AbstractSqlWriter writer) {
        writer.writeCommaIfNotFirst();
        writer.write("%s.art_type_id, %s.guid", this.artAlias, this.artAlias);
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        this.jArtAlias = writer.addTable(TableEnum.JOIN_ID4_TABLE);
        this.artAlias = writer.addTable(TableEnum.ARTIFACT_TABLE);
        this.txsAlias = writer.addTable(TableEnum.TXS_TABLE, ObjectType.ARTIFACT);
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        writer.writeEqualsAnd(this.artAlias, "art_id", this.jArtAlias, "id2");
        writer.writeEqualsParameterAnd(this.jArtAlias, "query_id", this.criteria.getQueryId());
        writer.writeEqualsAnd(this.artAlias, this.txsAlias, "gamma_id");
        writer.writeTxBranchFilter(this.txsAlias);
    }
}

