/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import com.google.common.base.Supplier;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcMigrationOptions;
import org.eclipse.osee.jdbc.JdbcMigrationResource;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.SystemPreferences;
import org.eclipse.osee.orcs.core.ds.DataStoreInfo;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreCallable;
import org.eclipse.osee.orcs.db.internal.callable.FetchDatastoreInfoCallable;

public class MigrateDatastoreCallable
extends AbstractDatastoreCallable<DataStoreInfo> {
    private final SystemPreferences preferences;
    private final Supplier<Iterable<JdbcMigrationResource>> schemaProvider;
    private final JdbcMigrationOptions options;

    public MigrateDatastoreCallable(OrcsSession session, Log logger, JdbcClient jdbcClient, SystemPreferences preferences, Supplier<Iterable<JdbcMigrationResource>> schemaProvider, JdbcMigrationOptions options) {
        super(logger, session, jdbcClient);
        this.preferences = preferences;
        this.schemaProvider = schemaProvider;
        this.options = options;
    }

    public DataStoreInfo call() throws Exception {
        this.getJdbcClient().migrate(this.options, (Iterable)this.schemaProvider.get());
        FetchDatastoreInfoCallable fetchCallable = new FetchDatastoreInfoCallable(this.getLogger(), this.getJdbcClient(), this.schemaProvider, this.preferences);
        DataStoreInfo dataStoreInfo = (DataStoreInfo)this.callAndCheckForCancel(fetchCallable);
        return dataStoreInfo;
    }
}

