/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.eclipse.osee.ats.api.config.JaxAtsObject;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.user.IUserArtLoader;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;

@JsonSerialize(as=AtsUser.class)
public class AtsUser
extends JaxAtsObject
implements IAtsUser {
    private String userId;
    private String email;
    private ArtifactToken storeObject;
    private IUserArtLoader userArtLoader;

    public AtsUser() {
    }

    public AtsUser(UserToken user) {
        this(user.getId(), user.getName(), user.getUserId(), user.getEmail(), user.isActive());
    }

    public AtsUser(Long id, String name, String userId, String email, boolean active) {
        this.userId = userId;
        this.email = email;
        this.active = active;
        this.id = id;
        this.setName(name);
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @JsonIgnore
    public String toStringWithId() {
        return String.format("[%s]-[%s]", this.getName(), this.getUserId());
    }

    @Override
    @JsonIgnore
    public ArtifactToken getStoreObject() {
        if (this.storeObject == null && this.userArtLoader != null) {
            this.storeObject = this.userArtLoader.loadUser(this);
        }
        return this.storeObject;
    }

    @Override
    public void setStoreObject(ArtifactToken artifact) {
        this.storeObject = artifact;
    }

    @JsonIgnore
    public void setUserArtLoader(IUserArtLoader userArtLoader) {
        this.userArtLoader = userArtLoader;
    }

    public Long getId() {
        return super.getId();
    }

    @Override
    @JsonIgnore
    public ArtifactTypeId getArtifactType() {
        return CoreArtifactTypes.User;
    }

    @Override
    public String toString() {
        return String.format("User [%s - %s - %s]", this.getName(), this.getUserId(), this.getEmail());
    }

    @JsonIgnore
    public Long getUuid() {
        return super.getId();
    }

    @Override
    @JsonIgnore
    public ArtifactId getArtifactId() {
        return ArtifactId.valueOf((Long)this.getId());
    }
}

