/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.review;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.framework.jdk.core.util.AXml;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class ReviewDefectItem {
    private Date date = new Date();
    private String description = "";
    private String location = "";
    private String resolution = "";
    private String userId;
    private Long id = Lib.generateId();
    private Severity severity = Severity.None;
    private Disposition disposition = Disposition.None;
    private InjectionActivity injectionActivity = InjectionActivity.None;
    private boolean closed = false;
    private final Pattern guidPattern = Pattern.compile("<guid>(.*)</guid>");

    public ReviewDefectItem(IAtsUser user, Severity severity, Disposition disposition, InjectionActivity injectionActivity, String description, String resolution, String location, Date date) {
        this(user.getUserId(), severity, disposition, injectionActivity, description, resolution, location, date);
    }

    public ReviewDefectItem(String userId, Severity severity, Disposition disposition, InjectionActivity injectionActivity, String description, String resolution, String location, Date date) {
        this.userId = userId;
        if (severity != null) {
            this.severity = severity;
        }
        if (disposition != null) {
            this.disposition = disposition;
        }
        if (injectionActivity != null) {
            this.injectionActivity = injectionActivity;
        }
        if (description != null) {
            this.description = description;
        }
        if (resolution != null) {
            this.resolution = resolution;
        }
        if (location != null) {
            this.location = location;
        }
        if (date != null) {
            this.date = date;
        }
    }

    public ReviewDefectItem(String xml) {
        this.fromXml(xml);
    }

    public ReviewDefectItem() {
    }

    public void update(ReviewDefectItem dItem) {
        this.fromXml(dItem.toXml());
    }

    public String getDate(String pattern) {
        if (pattern != null) {
            return new SimpleDateFormat(pattern).format(this.date);
        }
        return this.date.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ReviewDefectItem) {
            ReviewDefectItem di = (ReviewDefectItem)obj;
            return di.id.equals(this.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toXml() {
        return "<severity>" + this.severity.name() + "</severity><disposition>" + this.disposition.name() + "</disposition><injectionActivity>" + this.injectionActivity.name() + "</injectionActivity><date>" + this.date.getTime() + "</date><user>" + this.userId + "</user><description>" + this.description + "</description><location>" + this.location + "</location><resolution>" + this.resolution + "</resolution><closed>" + this.closed + "</closed><id>" + this.id + "</id>";
    }

    private void fromXml(String xml) {
        Matcher m = this.guidPattern.matcher(xml);
        if (m.find()) {
            String guid = m.group(1);
            int id = guid.hashCode();
            xml = m.replaceAll(String.format("<id>%s</id>", id));
        }
        this.severity = Severity.valueOf(AXml.getTagData((String)xml, (String)"severity"));
        this.disposition = Disposition.valueOf(AXml.getTagData((String)xml, (String)"disposition"));
        this.injectionActivity = InjectionActivity.valueOf(AXml.getTagData((String)xml, (String)"injectionActivity"));
        Date date = new Date();
        date.setTime(new Long(AXml.getTagData((String)xml, (String)"date")));
        this.date = date;
        this.userId = AXml.getTagData((String)xml, (String)"user");
        this.description = AXml.getTagData((String)xml, (String)"description");
        this.location = AXml.getTagData((String)xml, (String)"location");
        this.resolution = AXml.getTagData((String)xml, (String)"resolution");
        this.closed = AXml.getTagBooleanData((String)xml, (String)"closed");
        this.id = Long.valueOf(AXml.getTagData((String)xml, (String)"id"));
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String toString() {
        return (Object)((Object)this.severity) + " - " + (Object)((Object)this.disposition) + " - " + (Object)((Object)this.injectionActivity) + " - " + this.userId + " on " + DateUtil.getMMDDYYHHMM((Date)this.date) + "\n";
    }

    public String getUserId() {
        return this.userId;
    }

    public String toHTML(String labelFont) {
        return "DEFECT (" + (Object)((Object)this.severity) + "): " + this.description + " (" + this.userId + ")";
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getResolution() {
        return this.resolution;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public Disposition getDisposition() {
        return this.disposition;
    }

    public void setDisposition(Disposition disposition) {
        this.disposition = disposition;
    }

    public InjectionActivity getInjectionActivity() {
        return this.injectionActivity;
    }

    public void setInjectionActivity(InjectionActivity injectionActivity) {
        this.injectionActivity = injectionActivity;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUser(IAtsUser user) {
        this.userId = user.getUserId();
    }

    public static enum Disposition {
        None,
        Accept,
        Reject,
        Duplicate;


        public static Collection<String> strValues() {
            HashSet<String> values = new HashSet<String>();
            Disposition[] dispositionArray = Disposition.values();
            int n = dispositionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Disposition e = dispositionArray[n2];
                values.add(e.name());
                ++n2;
            }
            return values;
        }
    }

    public static enum InjectionActivity {
        None,
        Planning,
        System_Level_Requirements,
        System_Design,
        Software_Requirements,
        Software_Design,
        Code,
        Test,
        Other;


        public static Collection<String> strValues() {
            HashSet<String> values = new HashSet<String>();
            InjectionActivity[] injectionActivityArray = InjectionActivity.values();
            int n = injectionActivityArray.length;
            int n2 = 0;
            while (n2 < n) {
                InjectionActivity e = injectionActivityArray[n2];
                values.add(e.name());
                ++n2;
            }
            return values;
        }
    }

    public static enum Severity {
        None,
        Major,
        Minor,
        Issue;


        public static Collection<String> strValues() {
            HashSet<String> values = new HashSet<String>();
            Severity[] severityArray = Severity.values();
            int n = severityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Severity e = severityArray[n2];
                values.add(e.name());
                ++n2;
            }
            return values;
        }
    }
}

