/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.script.dsl.typesystem;

import com.google.inject.Singleton;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osee.orcs.script.dsl.OrcsScriptUtil;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsStringLiteral;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

@Singleton
public class TimestampConverter {
    public boolean isTimestampType(Class<?> type) {
        return this.getType().isAssignableFrom(type);
    }

    public boolean isTimestampType(OsStringLiteral object) {
        String rawValue;
        boolean canParse = false;
        if (object != null && (rawValue = object.getValue()) != null) {
            try {
                OrcsScriptUtil.parseDate(rawValue);
                canParse = true;
            }
            catch (ParseException parseException) {
                canParse = false;
            }
        }
        return canParse;
    }

    public Class<?> getType() {
        return Date.class;
    }

    public Date toValue(OsStringLiteral literal) {
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)literal);
        return this.toValue(literal.getValue(), (INode)node);
    }

    public Date toValue(String rawValue, INode node) throws ValueConverterException {
        Date toReturn = null;
        if (rawValue != null) {
            try {
                toReturn = OrcsScriptUtil.parseDate(rawValue);
            }
            catch (ParseException ex) {
                String errorMsg = this.newBadTimestampFormatErrorMsg();
                throw new ValueConverterException(errorMsg, node, (Exception)new TimestampFormatException(ex));
            }
        }
        return toReturn;
    }

    private String newBadTimestampFormatErrorMsg() {
        String defaultFormat;
        DateFormat fmt = DateFormat.getDateTimeInstance();
        if (fmt instanceof SimpleDateFormat) {
            SimpleDateFormat sdfmt = (SimpleDateFormat)fmt;
            defaultFormat = sdfmt.toLocalizedPattern();
        } else {
            defaultFormat = "Default format for the locale";
        }
        return String.format("Invalid timestamp format - format should be [%s] or [%s]", "MM/dd/yyyy hh:mm:ss a", defaultFormat);
    }

    public static class TimestampFormatException
    extends Exception {
        private static final long serialVersionUID = -1056825990595244386L;

        public TimestampFormatException(Throwable cause) {
            super(cause);
        }
    }
}

