/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.script.dsl.typesystem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.script.dsl.OrcsScriptUtil;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsAssignment;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsBooleanLiteral;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsExpression;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsListLiteral;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsNullLiteral;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsNumberLiteral;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsStringLiteral;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsTemplateLiteral;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsVariable;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsVariableDeclaration;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OsVariableReference;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.util.OrcsScriptDslSwitch;
import org.eclipse.osee.orcs.script.dsl.typesystem.TimestampConverter;

public class ExpressionTypeResolver<R>
extends OrcsScriptDslSwitch<Object> {
    private final TimestampConverter tsConverter;
    private final boolean isCycleProtected;
    private Set<EObject> visited;

    public ExpressionTypeResolver(TimestampConverter tsConverter, boolean isCycleProtected) {
        this.tsConverter = tsConverter;
        this.isCycleProtected = isCycleProtected;
    }

    public List<R> resolve(EObject expression) {
        List<Object> toReturn = null;
        Object result = this.doSwitch(expression);
        toReturn = result instanceof Collection ? (List<Object>)result : Collections.singletonList(result);
        return toReturn;
    }

    public Object doSwitch(EObject object) {
        Object result = null;
        if (object != null && !this.wasVisited(object)) {
            result = super.doSwitch(object);
        }
        return result;
    }

    private boolean wasVisited(EObject object) {
        boolean result = false;
        if (this.isCycleProtected) {
            if (this.visited == null) {
                this.visited = new HashSet<EObject>();
            }
            result = !this.visited.add(object);
        }
        return result;
    }

    @Override
    public Object caseOsVariableReference(OsVariableReference object) {
        return this.doSwitch(object.getRef());
    }

    @Override
    public Object caseOsAssignment(OsAssignment object) {
        return this.doSwitch(object.getRight());
    }

    @Override
    public Object caseOsVariable(OsVariable object) {
        OsExpression assignment = object.getRight();
        return this.doSwitch(assignment);
    }

    @Override
    public Object caseOsNullLiteral(OsNullLiteral object) {
        return null;
    }

    @Override
    public Object caseOsVariableDeclaration(OsVariableDeclaration object) {
        ArrayList<Object> values = new ArrayList<Object>();
        EList<OsExpression> elements = object.getElements();
        for (OsExpression variable : elements) {
            values.add(this.doSwitch(variable));
        }
        return values;
    }

    @Override
    public Object caseOsListLiteral(OsListLiteral object) {
        ArrayList<Object> values = new ArrayList<Object>();
        EList<OsExpression> elements = object.getElements();
        for (OsExpression expression : elements) {
            values.add(this.doSwitch(expression));
        }
        return values;
    }

    @Override
    public Object caseOsBooleanLiteral(OsBooleanLiteral object) {
        return Boolean.class;
    }

    @Override
    public Object caseOsNumberLiteral(OsNumberLiteral object) {
        return Number.class;
    }

    @Override
    public Object caseOsStringLiteral(OsStringLiteral object) {
        Class toReturn = this.tsConverter.isTimestampType(object) ? this.tsConverter.getType() : String.class;
        return toReturn;
    }

    @Override
    public Object caseOsTemplateLiteral(OsTemplateLiteral object) {
        String templateId;
        Map<String, Object> data = this.getTemplateBindings(object);
        Object value = data.get(templateId = object.getValue());
        Class toReturn = value instanceof String ? (Strings.isNumeric((String)((String)value)) ? Number.class : String.class) : (value != null ? value.getClass() : Void.class);
        return toReturn;
    }

    protected Map<String, Object> getTemplateBindings(OsTemplateLiteral object) {
        return OrcsScriptUtil.getBinding(object);
    }
}

