/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.script.dsl.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.script.dsl.OrcsScriptDslResource;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OrcsScript;

public class OrcsScriptResourceImpl
implements OrcsScriptDslResource {
    private final Resource resource;
    private List<String> additionalErrors;

    public OrcsScriptResourceImpl(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void error(Throwable th, String message, Object ... args) {
        String error;
        StringBuilder builder = new StringBuilder();
        if (args != null && args.length > 0) {
            try {
                builder.append(String.format(message, args));
            }
            catch (Exception ex) {
                builder.append(Lib.exceptionToString((Exception)ex));
            }
        } else {
            builder.append(message);
        }
        if (th != null) {
            builder.append(" ");
            builder.append(Lib.exceptionToString((Throwable)th));
        }
        if (Strings.isValid((String)(error = builder.toString()))) {
            if (this.additionalErrors == null) {
                this.additionalErrors = new ArrayList<String>();
            }
            this.additionalErrors.add(error);
        }
    }

    @Override
    public Collection<String> getErrors() {
        List<String> errors = null;
        if (this.additionalErrors != null && !this.additionalErrors.isEmpty()) {
            errors = new LinkedList<String>(this.additionalErrors);
        }
        if (this.resource != null) {
            if (errors == null) {
                errors = new LinkedList<String>();
            }
            for (Resource.Diagnostic diagnostic : this.resource.getErrors()) {
                errors.add(diagnostic.toString());
            }
        } else if (errors == null) {
            errors = Collections.emptyList();
        }
        return errors;
    }

    @Override
    public OrcsScript getModel() {
        EList contents;
        OrcsScript script = null;
        if (this.resource != null && (contents = this.resource.getContents()) != null && !contents.isEmpty()) {
            script = (OrcsScript)contents.get(0);
        }
        return script;
    }

    @Override
    public boolean hasErrors() {
        boolean result;
        boolean bl = result = this.additionalErrors != null && !this.additionalErrors.isEmpty();
        if (!result) {
            EList errors = this.resource.getErrors();
            result = errors != null && !errors.isEmpty();
        }
        return result;
    }
}

