/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.script.dsl;

import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.script.dsl.IExpressionResolver;
import org.eclipse.osee.orcs.script.dsl.IFieldResolver;
import org.eclipse.osee.orcs.script.dsl.OrcsScriptDslResource;
import org.eclipse.osee.orcs.script.dsl.OrcsScriptDslStandaloneSetup;
import org.eclipse.osee.orcs.script.dsl.orcsScriptDsl.OrcsScript;
import org.eclipse.osee.orcs.script.dsl.resource.OrcsScriptResourceImpl;
import org.eclipse.osee.orcs.script.dsl.typesystem.TemplateBinding;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;

public final class OrcsScriptUtil {
    private static final int BINDINGS_DATA__RESOURCE_INDEX = 1;
    private static Injector INJECTOR_INSTANCE;

    private OrcsScriptUtil() {
    }

    private static Injector getInjector() {
        if (INJECTOR_INSTANCE == null) {
            OrcsScriptDslStandaloneSetup setup = new OrcsScriptDslStandaloneSetup();
            INJECTOR_INSTANCE = setup.createInjectorAndDoEMFRegistration();
        }
        return INJECTOR_INSTANCE;
    }

    private static void initializeXtextRuntime() {
        OrcsScriptUtil.getInjector();
    }

    public static IExpressionResolver getExpressionResolver() {
        return (IExpressionResolver)OrcsScriptUtil.getInjector().getInstance(IExpressionResolver.class);
    }

    public static IFieldResolver getFieldResolver() {
        return (IFieldResolver)OrcsScriptUtil.getInjector().getInstance(IFieldResolver.class);
    }

    public static Map<String, Object> getBinding(EObject element) {
        EObject eObject;
        Resource eResource = element.eResource();
        EList contents = eResource.getContents();
        Map<String, Object> toReturn = null;
        if (1 < contents.size() && (eObject = (EObject)contents.get(1)) != null) {
            TemplateBinding container = (TemplateBinding)eObject;
            toReturn = container.map();
        }
        if (toReturn == null) {
            toReturn = Collections.emptyMap();
        }
        return toReturn;
    }

    public static void bind(EObject element, Map<String, Object> binding) {
        TemplateBinding container = new TemplateBinding();
        container.setValue(binding);
        Resource eResource = element.eResource();
        EList contents = eResource.getContents();
        contents.add(1, (Object)container);
    }

    public static void unbind(EObject element) {
        Resource eResource = element.eResource();
        EList contents = eResource.getContents();
        if (1 < contents.size()) {
            contents.remove(1);
        }
    }

    public static OrcsScriptDslResource loadModel(InputStream inputStream, String uri) {
        OrcsScriptDslResource resource = OrcsScriptUtil.loadModelSafely(inputStream, uri);
        if (resource == null) {
            throw new OseeCoreException("Error loading resource [%s] - resource was null", new Object[]{uri});
        }
        Iterator<String> iterator = resource.getErrors().iterator();
        if (iterator.hasNext()) {
            String error = iterator.next();
            throw new OseeCoreException("Error loading resource [%s] - %s", new Object[]{uri, error});
        }
        return resource;
    }

    public static OrcsScriptDslResource loadModelSafely(InputStream inputStream, String uri) {
        OrcsScriptResourceImpl toReturn = null;
        try {
            XtextResourceSet set = (XtextResourceSet)OrcsScriptUtil.getInjector().getInstance(XtextResourceSet.class);
            set.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
            Resource resource = set.createResource(URI.createURI((String)uri));
            Map loadOptions = set.getLoadOptions();
            resource.load(inputStream, loadOptions);
            toReturn = new OrcsScriptResourceImpl(resource);
        }
        catch (Exception ex) {
            toReturn = new OrcsScriptResourceImpl(null);
            toReturn.error(ex, "Error loading [%s]", uri);
        }
        return toReturn;
    }

    public static void saveModel(OrcsScriptDslResource dslResource, OutputStream outputStream, OsStorageOption ... options) {
        if (!(dslResource instanceof OrcsScriptResourceImpl)) {
            throw new OseeCoreException("Unsupported dslResource class [%s]", new Object[]{dslResource != null ? dslResource.getClass() : null});
        }
        OrcsScriptResourceImpl resourceImpl = (OrcsScriptResourceImpl)dslResource;
        Resource resource = resourceImpl.getResource();
        OrcsScriptUtil.saveResource(resource, outputStream, options);
    }

    public static void saveModel(OrcsScript model, String uri, OutputStream outputStream, OsStorageOption ... options) {
        if (model != null && model.eAllContents().hasNext()) {
            OrcsScriptUtil.initializeXtextRuntime();
            URI storageUri = URI.createURI((String)uri);
            Resource resource = model.eResource();
            if (resource != null) {
                resource.setURI(storageUri);
            } else {
                XtextResourceSet resourceSet = new XtextResourceSet();
                resource = resourceSet.createResource(storageUri);
                resource.getContents().add((Object)model);
            }
            OrcsScriptUtil.saveResource(resource, outputStream, options);
        }
    }

    private static void saveResource(Resource resource, OutputStream outputStream, OsStorageOption ... options) {
        SaveOptions.Builder builder = SaveOptions.newBuilder();
        OsStorageOption[] osStorageOptionArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            OsStorageOption option = osStorageOptionArray[n2];
            switch (option) {
                case FORMAT_ON_SAVE: {
                    builder.format();
                    break;
                }
                case NO_VALIDATION_ON_SAVE: {
                    builder.noValidation();
                    break;
                }
            }
            ++n2;
        }
        SaveOptions saveOptions = builder.getOptions();
        try {
            resource.save(outputStream, saveOptions.toOptionsMap());
        }
        catch (IOException ex) {
            throw new OseeCoreException((Throwable)ex, "Error saving resource [%s]", new Object[]{resource.getURI()});
        }
    }

    public static Date parseDate(String rawValue) throws ParseException {
        Date toReturn = null;
        String unQuotedValue = OrcsScriptUtil.unquote(rawValue);
        try {
            SimpleDateFormat fmt = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a");
            fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
            toReturn = fmt.parse(unQuotedValue);
        }
        catch (ParseException parseException) {}
        if (toReturn == null) {
            toReturn = DateFormat.getDateTimeInstance().parse(unQuotedValue);
        }
        return toReturn;
    }

    public static String asDateString(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        return fmt.format(date);
    }

    public static String asQuotedDateString(Date date) {
        return OrcsScriptUtil.quote(OrcsScriptUtil.asDateString(date));
    }

    public static String quote(String value) {
        String toReturn = value;
        if (value != null) {
            StringBuilder builder = new StringBuilder();
            builder.append("\"");
            builder.append(value);
            builder.append("\"");
            toReturn = builder.toString();
        }
        return toReturn;
    }

    public static String unquote(String value) {
        String toReturn = value;
        if (toReturn != null) {
            int startAt = 0;
            int endAt = value.length();
            if (toReturn.startsWith("\"") || toReturn.startsWith("'")) {
                startAt = 1;
            }
            if (toReturn.endsWith("\"") || toReturn.endsWith("'")) {
                endAt = toReturn.length() - 1;
            }
            toReturn = toReturn.substring(startAt, endAt);
        }
        return toReturn;
    }

    public static enum OsStorageOption {
        FORMAT_ON_SAVE,
        NO_VALIDATION_ON_SAVE;

    }
}

