/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.types.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XArtifactType;
import org.eclipse.osee.orcs.core.internal.types.BranchHierarchyProvider;
import org.eclipse.osee.orcs.core.internal.types.impl.TokenTypeIndex;

public class ArtifactTypeIndex
extends TokenTypeIndex<ArtifactTypeToken, XArtifactType> {
    private final Map<ArtifactTypeId, ArtifactTypeMetaData> tokenToTypeData = Maps.newHashMap();
    private final BranchHierarchyProvider hierarchyProvider;

    public ArtifactTypeIndex(BranchHierarchyProvider hierarchyProvider) {
        this.hierarchyProvider = hierarchyProvider;
    }

    @Override
    public void put(ArtifactTypeToken type, Set<ArtifactTypeToken> superTypes) {
        ArtifactTypeMetaData metaData = this.getOrCreateData(type);
        metaData.setSuperTypes(superTypes);
    }

    @Override
    public void put(ArtifactTypeToken type, Map<BranchId, Collection<AttributeTypeToken>> attributes) {
        ArtifactTypeMetaData metaData = this.getOrCreateData(type);
        metaData.setAttributeTypes(attributes);
    }

    private ArtifactTypeMetaData getOrCreateData(ArtifactTypeToken type) {
        ArtifactTypeMetaData metaData = this.tokenToTypeData.get(type);
        if (metaData == null) {
            metaData = new ArtifactTypeMetaData(type);
            this.tokenToTypeData.put((ArtifactTypeId)type, metaData);
        }
        return metaData;
    }

    public Map<BranchId, Collection<AttributeTypeToken>> getAllAttributeTypes(ArtifactTypeId artifactType) {
        ArtifactTypeMetaData metaData = this.tokenToTypeData.get(artifactType);
        return metaData.attributeTypes;
    }

    public Collection<ArtifactTypeToken> getSuperTypes(ArtifactTypeId artifactType) {
        ArtifactTypeMetaData metaData = this.tokenToTypeData.get(artifactType);
        return metaData != null ? metaData.getSuperTypes() : Collections.emptyList();
    }

    public Collection<ArtifactTypeToken> getDescendantTypes(ArtifactTypeId artifactType) {
        ArtifactTypeMetaData metaData = this.tokenToTypeData.get(artifactType);
        return metaData != null ? metaData.getDescendantTypes() : Collections.emptyList();
    }

    public boolean hasSuperArtifactTypes(ArtifactTypeId artType) {
        return !this.getSuperTypes(artType).isEmpty();
    }

    public boolean inheritsFrom(ArtifactTypeId thisType, ArtifactTypeId ... otherTypes) {
        boolean result = false;
        ArtifactTypeId[] artifactTypeIdArray = otherTypes;
        int n = otherTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ArtifactTypeId otherType = artifactTypeIdArray[n2];
            if (this.inheritsFromSingle(thisType, otherType)) {
                result = true;
                break;
            }
            ++n2;
        }
        return result;
    }

    private boolean inheritsFromSingle(ArtifactTypeId thisType, ArtifactTypeId otherType) {
        boolean result = false;
        if (thisType.equals(otherType)) {
            result = true;
        } else {
            for (ArtifactTypeId artifactTypeId : this.getSuperTypes(thisType)) {
                if (!this.inheritsFrom(artifactTypeId, otherType)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public Collection<AttributeTypeToken> getAttributeTypes(ArtifactTypeId artType, BranchId branch) {
        LinkedHashSet attributeTypes = Sets.newLinkedHashSet();
        this.getAttributeTypes(attributeTypes, artType, branch);
        return attributeTypes;
    }

    private void getAttributeTypes(Set<AttributeTypeToken> attributeTypes, ArtifactTypeId artifactType, BranchId branch) {
        ArtifactTypeMetaData metaData = this.tokenToTypeData.get(artifactType);
        if (metaData != null) {
            Map<BranchId, Collection<AttributeTypeToken>> map = metaData.getAttributeTypes();
            Iterable<? extends BranchId> branches = this.hierarchyProvider.getParentHierarchy(branch);
            for (BranchId branchId : branches) {
                Collection<AttributeTypeToken> items = map.get(branchId);
                if (items == null) continue;
                attributeTypes.addAll(items);
            }
        }
        for (ArtifactTypeId artifactTypeId : this.getSuperTypes(artifactType)) {
            this.getAttributeTypes(attributeTypes, artifactTypeId, branch);
        }
    }

    private final class ArtifactTypeMetaData {
        private final ArtifactTypeToken type;
        private Set<ArtifactTypeToken> superTypes;
        private final Set<ArtifactTypeToken> descendantTypes;
        private Map<BranchId, Collection<AttributeTypeToken>> attributeTypes;

        public ArtifactTypeMetaData(ArtifactTypeToken type) {
            this.type = type;
            this.superTypes = Collections.emptySet();
            this.descendantTypes = Sets.newLinkedHashSet();
            this.attributeTypes = Collections.emptyMap();
        }

        public void setSuperTypes(Set<ArtifactTypeToken> newSuperTypes) {
            ArtifactTypeMetaData metaData;
            HashSet originals = Sets.newHashSet(this.superTypes);
            this.superTypes = Sets.newHashSet(newSuperTypes);
            for (ArtifactTypeToken superType : this.superTypes) {
                metaData = ArtifactTypeIndex.this.getOrCreateData(superType);
                if (metaData == null) continue;
                metaData.getDescendantTypes().add(this.type);
            }
            for (ArtifactTypeToken oldValue : originals) {
                metaData = ArtifactTypeIndex.this.getOrCreateData(oldValue);
                if (metaData == null) continue;
                metaData.getDescendantTypes().remove(this.type);
            }
        }

        public void setAttributeTypes(Map<BranchId, Collection<AttributeTypeToken>> attributes) {
            this.attributeTypes = attributes;
        }

        public Set<ArtifactTypeToken> getSuperTypes() {
            return this.superTypes;
        }

        public Set<ArtifactTypeToken> getDescendantTypes() {
            return this.descendantTypes;
        }

        public Map<BranchId, Collection<AttributeTypeToken>> getAttributeTypes() {
            return this.attributeTypes;
        }
    }
}

