/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.search;

import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.OrcsTypes;
import org.eclipse.osee.orcs.core.ds.ApplicabilityDsQuery;
import org.eclipse.osee.orcs.core.ds.QueryEngine;
import org.eclipse.osee.orcs.core.internal.HasStatistics;
import org.eclipse.osee.orcs.core.internal.graph.GraphBuilderFactory;
import org.eclipse.osee.orcs.core.internal.graph.GraphProvider;
import org.eclipse.osee.orcs.core.internal.proxy.ExternalArtifactManager;
import org.eclipse.osee.orcs.core.internal.search.BranchCriteriaFactory;
import org.eclipse.osee.orcs.core.internal.search.CallableQueryFactory;
import org.eclipse.osee.orcs.core.internal.search.QueryFactoryImpl;
import org.eclipse.osee.orcs.core.internal.search.QueryStatisticsImpl;
import org.eclipse.osee.orcs.core.internal.search.QueryStatsCollectorImpl;
import org.eclipse.osee.orcs.core.internal.search.TransactionCriteriaFactory;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TupleQuery;
import org.eclipse.osee.orcs.statistics.QueryStatistics;

public class QueryModule
implements HasStatistics<QueryStatistics> {
    private final QueryStatisticsImpl statistics = new QueryStatisticsImpl();
    private final CallableQueryFactory artQueryFactory;
    private final BranchCriteriaFactory branchCriteriaFactory;
    private final TransactionCriteriaFactory txCriteriaFactory;
    private final TupleQuery tupleQuery;
    private final ApplicabilityDsQuery applicabilityDsQuery;
    private final QueryEngine queryEngine;
    private final OrcsTypes orcsTypes;

    public QueryModule(Log logger, QueryEngine queryEngine, GraphBuilderFactory builderFactory, GraphProvider provider, OrcsTypes orcsTypes, ExternalArtifactManager proxyManager) {
        this.queryEngine = queryEngine;
        QueryStatsCollectorImpl queryStatsCollector = new QueryStatsCollectorImpl(this.statistics);
        this.artQueryFactory = new CallableQueryFactory(logger, queryEngine, queryStatsCollector, builderFactory, provider, proxyManager);
        this.branchCriteriaFactory = new BranchCriteriaFactory();
        this.txCriteriaFactory = new TransactionCriteriaFactory();
        this.tupleQuery = queryEngine.createTupleQuery();
        this.applicabilityDsQuery = queryEngine.createApplicabilityDsQuery();
        this.orcsTypes = orcsTypes;
    }

    public QueryFactory createQueryFactory(OrcsSession session) {
        return new QueryFactoryImpl(this.artQueryFactory, this.branchCriteriaFactory, this.txCriteriaFactory, this.tupleQuery, this.applicabilityDsQuery, this.queryEngine, this.orcsTypes);
    }

    public CallableQueryFactory getArtQueryFactory() {
        return this.artQueryFactory;
    }

    @Override
    public QueryStatistics getStatistics(OrcsSession session) {
        return this.statistics.clone();
    }

    @Override
    public void clearStatistics(OrcsSession session) {
        this.statistics.clear();
    }

    public static interface QueryModuleProvider {
        public QueryFactory getQueryFactory(OrcsSession var1);
    }
}

