/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.attribute;

import java.lang.ref.WeakReference;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.exception.AttributeDoesNotExist;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.Attribute;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.AttributeDataFactory;
import org.eclipse.osee.orcs.core.ds.DataProxy;
import org.eclipse.osee.orcs.core.ds.ResourceNameResolver;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeContainer;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeManager;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeResourceNameResolver;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.ArtifactReferenceAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.AttributeImpl;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.BooleanAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.BranchReferenceAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.CompressedContentAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.DateAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.EnumeratedAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.FloatingPointAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.IntegerAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.JavaObjectAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.StringAttribute;
import org.eclipse.osee.orcs.data.AttributeTypes;

public class AttributeFactory {
    private final AttributeDataFactory dataFactory;
    private final AttributeTypes cache;

    public AttributeFactory(AttributeDataFactory dataFactory, AttributeTypes cache) {
        this.dataFactory = dataFactory;
        this.cache = cache;
    }

    public <T> Attribute<T> createAttributeWithDefaults(AttributeContainer container, ArtifactData artifactData, AttributeTypeToken attributeType) {
        AttributeData data = this.dataFactory.create(artifactData, attributeType);
        return this.createAttribute(container, data, true, true);
    }

    public <T> Attribute<T> createAttribute(AttributeContainer container, AttributeData<T> data) {
        return this.createAttribute(container, data, false, false);
    }

    private <T> Attribute<T> createAttribute(AttributeContainer container, AttributeData<T> data, boolean isDirty, boolean createWithDefaults) {
        Attribute<T> attribute = this.createAttribute((AttributeTypeId)data.getType(), data);
        DataProxy<T> proxy = data.getDataProxy();
        ResourceNameResolver resolver = this.createResolver(attribute);
        proxy.setResolver(resolver);
        proxy.setAttribute(attribute);
        WeakReference<AttributeContainer> artifactRef = new WeakReference<AttributeContainer>(container);
        attribute.internalInitialize(this.cache, artifactRef, data, isDirty, createWithDefaults);
        container.add((AttributeTypeToken)data.getType(), attribute);
        return attribute;
    }

    private <T> Attribute<T> createAttribute(AttributeTypeId attributeType, AttributeId attributeId) {
        String baseAttributeType = this.cache.getBaseAttributeTypeId(attributeType);
        Long id = attributeId.getId();
        AttributeImpl attribute = baseAttributeType.equals(StringAttribute.NAME) ? new StringAttribute(id) : (baseAttributeType.equals(BooleanAttribute.NAME) ? new BooleanAttribute(id) : (baseAttributeType.equals(EnumeratedAttribute.NAME) ? new EnumeratedAttribute(id) : (baseAttributeType.equals(DateAttribute.NAME) ? new DateAttribute(id) : (baseAttributeType.equals(IntegerAttribute.NAME) ? new IntegerAttribute(id) : (baseAttributeType.equals(FloatingPointAttribute.NAME) ? new FloatingPointAttribute(id) : (baseAttributeType.equals(ArtifactReferenceAttribute.NAME) ? new ArtifactReferenceAttribute(id) : (baseAttributeType.equals(BranchReferenceAttribute.NAME) ? new BranchReferenceAttribute(id) : (baseAttributeType.equals(JavaObjectAttribute.NAME) ? new JavaObjectAttribute(id) : (baseAttributeType.equals(CompressedContentAttribute.NAME) ? new CompressedContentAttribute(id) : new StringAttribute(id))))))))));
        return attribute;
    }

    public <T> Attribute<T> copyAttribute(AttributeData<T> source, BranchId ontoBranch, AttributeContainer destinationContainer) {
        AttributeData<T> attributeData = this.dataFactory.copy(ontoBranch, source);
        return this.createAttribute(destinationContainer, attributeData, true, false);
    }

    public <T> Attribute<T> cloneAttribute(AttributeData<T> source, AttributeContainer destinationContainer) {
        AttributeData<T> attributeData = this.dataFactory.clone(source);
        Attribute<T> destinationAttribute = this.createAttribute(destinationContainer, attributeData, false, false);
        return destinationAttribute;
    }

    public <T> Attribute<T> introduceAttribute(AttributeData<T> source, BranchId ontoBranch, AttributeManager destination) {
        AttributeData<T> attributeData = this.dataFactory.introduce(ontoBranch, source);
        Attribute<T> destinationAttribute = null;
        if (source.getVersion().isInStorage()) {
            try {
                destinationAttribute = destination.getAttributeById(source, DeletionFlag.INCLUDE_DELETED);
                WeakReference<AttributeContainer> artifactRef = new WeakReference<AttributeContainer>(destination);
                destinationAttribute.internalInitialize(this.cache, artifactRef, attributeData, true, false);
            }
            catch (AttributeDoesNotExist attributeDoesNotExist) {
                destinationAttribute = this.createAttribute(destination, attributeData);
            }
        }
        return destinationAttribute;
    }

    private ResourceNameResolver createResolver(Attribute<?> attribute) {
        return new AttributeResourceNameResolver(this.cache, attribute);
    }

    public int getMaxOccurrenceLimit(AttributeTypeId attributeType) {
        return this.cache.getMaxOccurrences(attributeType);
    }

    public int getMinOccurrenceLimit(AttributeTypeId attributeType) {
        return this.cache.getMinOccurrences(attributeType);
    }
}

