/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.applicability;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.core.applicability.ApplicabilityBranchConfig;
import org.eclipse.osee.framework.core.applicability.FeatureDefinition;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchViewToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.VariantDefinition;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreTupleTypes;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.NamedComparator;
import org.eclipse.osee.framework.jdk.core.util.SortOrder;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsApplicability;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class OrcsApplicabilityOps
implements OrcsApplicability {
    private final OrcsApi orcsApi;
    private ArtifactToken plFolder = ArtifactToken.SENTINEL;
    private ArtifactToken featureFolder = ArtifactToken.SENTINEL;
    private ArtifactToken variantsFolder = ArtifactToken.SENTINEL;

    public OrcsApplicabilityOps(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public ApplicabilityBranchConfig getConfig(BranchId branchId, boolean showAll) {
        ApplicabilityBranchConfig config = new ApplicabilityBranchConfig();
        Branch branch = (Branch)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(branchId)).getResults().getExactlyOne();
        config.setBranch((BranchViewToken)branch);
        List branchViews = this.orcsApi.getQueryFactory().fromBranch((BranchId)branch).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.BranchView}).getResults().getList();
        Collections.sort(branchViews, new NamedComparator(SortOrder.ASCENDING));
        HashMap<ArtifactId, Map<String, List<String>>> branchViewsMap = new HashMap<ArtifactId, Map<String, List<String>>>();
        for (ArtifactToken branchView : branchViews) {
            config.addVariant(branchView);
            branchViewsMap.put((ArtifactId)branchView, this.orcsApi.getQueryFactory().applicabilityQuery().getNamedViewApplicabilityMap((BranchId)branch, (ArtifactId)branchView));
        }
        List featureArts = this.orcsApi.getQueryFactory().fromBranch((BranchId)branch).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.Feature}).getResults().getList();
        Collections.sort(featureArts, new NamedComparator(SortOrder.ASCENDING));
        for (ArtifactToken featureArt : featureArts) {
            FeatureDefinition fDef = this.getFeatureDefinition(featureArt);
            config.addFeature(fDef);
        }
        for (FeatureDefinition fDef : config.getFeatureIdToFeature().values()) {
            HashMap<String, String> variantToValue = new HashMap<String, String>(config.getFeatureIdToFeature().values().size() + 1);
            variantToValue.put("feature", fDef.getName());
            variantToValue.put("id", fDef.getIdString());
            variantToValue.put("description", fDef.getDescription());
            if (showAll) {
                variantToValue.put("valueType", fDef.getValueType());
                variantToValue.put("values", org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)",", (Iterable)fDef.getValues()));
                variantToValue.put("defaultValue", fDef.getDefaultValue());
                variantToValue.put("multiValued", String.valueOf(fDef.isMultiValued()));
            }
            config.addFeatureToValueMap(variantToValue);
        }
        int count = 0;
        for (FeatureDefinition fDef : config.getFeatureIdToFeature().values()) {
            for (ArtifactToken variant : config.getVariants()) {
                Map variantToValue = config.getFeatureToValues(count);
                String variantToFeatureValue = this.getVariantToFeatureValue(variant, fDef, branchViewsMap);
                variantToValue.put(variant.getName().toLowerCase(), variantToFeatureValue);
            }
            ++count;
        }
        return config;
    }

    private String getVariantToFeatureValue(ArtifactToken variant, FeatureDefinition fDef, Map<ArtifactId, Map<String, List<String>>> branchViewsMap) {
        Map<String, List<String>> map = branchViewsMap.get(variant);
        List<String> list = map.get(fDef.getName());
        if (list == null) {
            return "";
        }
        return org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)",", list);
    }

    public VariantDefinition getVariantDefinition(ArtifactToken featureArt) {
        ArtifactReadable art = (ArtifactReadable)featureArt;
        VariantDefinition variant = new VariantDefinition();
        variant.setId(art.getId());
        variant.setName(art.getName());
        variant.setData((Object)art);
        return variant;
    }

    public FeatureDefinition getFeatureDefinition(ArtifactToken featureArt) {
        ArtifactReadable art = (ArtifactReadable)featureArt;
        FeatureDefinition feature = new FeatureDefinition();
        feature.setId(art.getId());
        feature.setName(art.getName());
        feature.setDefaultValue((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.DefaultValue, (Object)""));
        feature.setValues(art.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.Value));
        feature.setValueType(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.FeatureValueType, ""));
        feature.setMultiValued(((Boolean)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.FeatureMultivalued, (Object)false)).booleanValue());
        feature.setDescription(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Description, ""));
        feature.setData((Object)featureArt);
        return feature;
    }

    public ArtifactToken createUpdateFeatureDefinition(FeatureDefinition featureDef, String action, TransactionBuilder tx, XResultData results) {
        ArtifactToken fDefArt = null;
        if (Strings.isInValid((String)featureDef.getName())) {
            results.error("Feature must have a name.");
            return null;
        }
        FeatureDefinition lFeature = this.getFeature(featureDef.getName(), tx.getBranch());
        if (action != null && action.equals("add") && lFeature != null) {
            results.error("Feature: " + lFeature.getName() + " already exists.");
            return null;
        }
        if (lFeature == null) {
            ArtifactToken featuresFolder = tx.getWriteable((ArtifactId)CoreArtifactTokens.FeaturesFolder);
            if (featuresFolder.isInvalid()) {
                featuresFolder = this.getFeaturesFolder(tx.getBranch());
            }
            if (featuresFolder.isInvalid()) {
                results.error("Features Folder cannot be null");
                return null;
            }
            Long artId = featureDef.getId();
            if (artId == null || artId <= 0L) {
                artId = Lib.generateArtifactIdAsInt();
            }
            fDefArt = tx.createArtifact(featuresFolder, CoreArtifactTypes.Feature, featureDef.getName(), artId);
        } else {
            fDefArt = (ArtifactToken)this.orcsApi.getQueryFactory().fromBranch(tx.getBranch()).andId(ArtifactId.valueOf((Long)lFeature.getId())).getResults().getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
        }
        this.updateFeatureDefinition(fDefArt, featureDef, tx);
        return fDefArt;
    }

    private void updateFeatureDefinition(ArtifactToken fDefArt, FeatureDefinition featureDef, TransactionBuilder tx) {
        tx.setName((ArtifactId)fDefArt, featureDef.getName());
        tx.setSoleAttributeValue((ArtifactId)fDefArt, (AttributeTypeToken)CoreAttributeTypes.DefaultValue, (Object)featureDef.getDefaultValue());
        tx.setAttributesFromValues((ArtifactId)fDefArt, (AttributeTypeToken)CoreAttributeTypes.Value, (Collection)featureDef.getValues());
        tx.setSoleAttributeValue((ArtifactId)fDefArt, (AttributeTypeToken)CoreAttributeTypes.FeatureValueType, (Object)featureDef.getValueType());
        tx.setSoleAttributeValue((ArtifactId)fDefArt, (AttributeTypeToken)CoreAttributeTypes.FeatureMultivalued, (Object)featureDef.isMultiValued());
        tx.setSoleAttributeValue((ArtifactId)fDefArt, (AttributeTypeToken)CoreAttributeTypes.Description, (Object)featureDef.getDescription());
    }

    public List<BranchViewToken> getApplicabilityBranches() {
        ArrayList<BranchViewToken> tokens = new ArrayList<BranchViewToken>();
        for (Branch branch : ((BranchQuery)((BranchQuery)((BranchQuery)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().includeArchived(false)).includeDeleted(false)).andIsOfType(new BranchType[]{BranchType.BASELINE, BranchType.WORKING})).andStateIs(new BranchState[]{BranchState.CREATED, BranchState.MODIFIED})).getResults().getList()) {
            if (!this.orcsApi.getQueryFactory().fromBranch((BranchId)branch).andId((ArtifactId)CoreArtifactTokens.ProductLineFolder).exists()) continue;
            tokens.add(new BranchViewToken((BranchId)branch, branch.getName(), branch.getViewId()));
        }
        return tokens;
    }

    public ArtifactToken getFeaturesFolder(BranchId branch) {
        if (this.featureFolder.isInvalid()) {
            this.featureFolder = this.orcsApi.getQueryFactory().fromBranch(branch).andId((ArtifactId)CoreArtifactTokens.FeaturesFolder).getArtifactOrSentinal();
        }
        if (this.featureFolder.isInvalid()) {
            this.featureFolder = this.orcsApi.getQueryFactory().fromBranch(branch).andNameEquals(CoreArtifactTokens.FeaturesFolder.getName()).asArtifactTokenOrSentinel();
        }
        return this.featureFolder;
    }

    public ArtifactToken getVariantsFolder(BranchId branch) {
        if (this.variantsFolder.isInvalid()) {
            this.variantsFolder = this.orcsApi.getQueryFactory().fromBranch(branch).andId((ArtifactId)CoreArtifactTokens.VariantsFolder).getArtifactOrSentinal();
        }
        if (this.variantsFolder.isInvalid()) {
            this.variantsFolder = this.orcsApi.getQueryFactory().fromBranch(branch).andNameEquals(CoreArtifactTokens.VariantsFolder.getName()).asArtifactTokenOrSentinel();
        }
        if (this.variantsFolder.isInvalid()) {
            this.variantsFolder = this.orcsApi.getQueryFactory().fromBranch(branch).andNameEquals("Products").asArtifactTokenOrSentinel();
        }
        return this.variantsFolder;
    }

    public ArtifactToken getProductLineFolder(BranchId branch) {
        if (this.plFolder.isInvalid()) {
            this.plFolder = this.orcsApi.getQueryFactory().fromBranch(branch).andId((ArtifactId)CoreArtifactTokens.ProductLineFolder).getArtifactOrSentinal();
        }
        if (this.plFolder.isInvalid()) {
            this.plFolder = this.orcsApi.getQueryFactory().fromBranch(branch).andNameEquals("Product Line").asArtifactTokenOrSentinel();
        }
        return this.plFolder;
    }

    public String convertConfigToArtifact(BranchId branch) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, (UserId)SystemUser.OseeSystem, "Convert Feature Defs to Artifact");
        for (FeatureDefinition feature : this.orcsApi.getQueryFactory().applicabilityQuery().getFeatureDefinitionData(branch)) {
            ArtifactToken featureArt = this.getFeaturesFolder(branch);
            if (!feature.getValueType().equals("single")) {
                if (feature.getValueType().equals("multiple")) {
                    feature.setMultiValued(true);
                } else {
                    throw new IllegalArgumentException(String.format("Unexpected value type [%s]", feature.getValueType()));
                }
            }
            feature.setValueType("String");
            this.updateFeatureDefinition(featureArt, feature, tx);
        }
        tx.commit();
        return AHTML.simplePage((String)"Completed");
    }

    public XResultData createUpdateFeature(FeatureDefinition feature, String action, BranchId branch, UserId account) {
        UserId user;
        XResultData results = new XResultData();
        try {
            TransactionBuilder tx;
            user = account;
            if (user == null) {
                user = SystemUser.OseeSystem;
            }
            if (this.createUpdateFeatureDefinition(feature, action, tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Update Feature " + feature.toStringWithId()), results) != null) {
                tx.commit();
            }
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        results.getNumErrors();
        if (action.equals("add") && results.getNumErrors() == 0) {
            try {
                user = account;
                boolean changes = false;
                if (user == null) {
                    user = SystemUser.OseeSystem;
                }
                TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Set Defaults for Variants for New Feature:  " + feature.toStringWithId());
                List branchViews = this.orcsApi.getQueryFactory().fromBranch(tx.getBranch()).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.BranchView}).getResults().getList();
                Collections.sort(branchViews, new NamedComparator(SortOrder.ASCENDING));
                for (ArtifactToken variant : branchViews) {
                    Iterable appl = this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, tx.getBranch(), (Object)variant);
                    if (appl.toString().contains(String.valueOf(feature.getName()) + " = ")) continue;
                    tx.addTuple2(CoreTupleTypes.ViewApplicability, (Object)variant, (Object)(String.valueOf(feature.getName()) + " = " + feature.getDefaultValue()));
                    changes = true;
                }
                if (changes) {
                    tx.commit();
                }
            }
            catch (Exception ex) {
                results.error(Lib.exceptionToString((Exception)ex));
            }
        }
        return results;
    }

    public FeatureDefinition getFeature(String feature, BranchId branch) {
        if (Strings.isNumeric((String)feature)) {
            ArtifactToken featureArt = (ArtifactToken)this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.Feature}).andId(ArtifactId.valueOf((String)feature)).getResults().getAtMostOneOrNull();
            if (featureArt != null) {
                return this.getFeatureDefinition(featureArt);
            }
        } else {
            ArtifactToken featureArt = (ArtifactToken)this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.Feature}).andNameEquals(feature).getResults().getAtMostOneOrNull();
            if (featureArt != null) {
                return this.getFeatureDefinition(featureArt);
            }
        }
        return null;
    }

    public XResultData deleteFeature(ArtifactId feature, BranchId branch, UserId account) {
        XResultData results = new XResultData();
        try {
            UserId user = account;
            if (user == null) {
                user = SystemUser.OseeSystem;
            }
            ArtifactToken featureArt = (ArtifactToken)this.getFeature(feature.getIdString(), branch).getData();
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Update Feature " + featureArt.toStringWithId());
            List branchViews = this.orcsApi.getQueryFactory().fromBranch(tx.getBranch()).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.BranchView}).getResults().getList();
            Collections.sort(branchViews, new NamedComparator(SortOrder.ASCENDING));
            for (ArtifactToken v : branchViews) {
                Iterable appl = this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, tx.getBranch(), (Object)v);
                for (String app : appl) {
                    if (!appl.toString().contains(feature + " = ")) continue;
                    tx.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)v, (Object)app);
                }
            }
            tx.deleteArtifact((ArtifactId)featureArt);
            tx.commit();
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    public VariantDefinition getVariant(String variant, BranchId branch) {
        if (Strings.isNumeric((String)variant)) {
            ArtifactToken variantArt = (ArtifactToken)this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.BranchView}).andId(ArtifactId.valueOf((String)variant)).getResults().getAtMostOneOrNull();
            if (variantArt != null) {
                return this.getVariantDefinition(variantArt);
            }
        } else {
            ArtifactToken variantArt = (ArtifactToken)this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.BranchView}).andNameEquals(variant).getResults().getAtMostOneOrNull();
            if (variantArt != null) {
                return this.getVariantDefinition(variantArt);
            }
        }
        return null;
    }

    public XResultData createUpdateVariant(VariantDefinition variant, String action, BranchId branch, UserId account) {
        XResultData results = new XResultData();
        if (!Strings.isValid((String)variant.getName())) {
            results.errorf("Name can not be empty for variant %s", new Object[]{variant.getId()});
            return results;
        }
        VariantDefinition xVariant = this.getVariant(variant.getName(), branch);
        if (action.equals("edit")) {
            results = this.copyFromVariant(branch, ArtifactId.valueOf((Id)xVariant), variant.copyFrom, account);
        } else if (action.equals("add")) {
            if (xVariant != null) {
                results.errorf("Variant Name is already in use.", new Object[0]);
                return results;
            }
            if (xVariant == null) {
                try {
                    UserId user = account;
                    if (user == null) {
                        user = SystemUser.OseeSystem;
                    }
                    TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Update Variant " + variant.toStringWithId());
                    this.createUpdateVariantDefinition(variant, tx);
                    tx.commit();
                }
                catch (Exception ex) {
                    results.error(Lib.exceptionToString((Exception)ex));
                }
            }
            if (variant.copyFrom != null) {
                VariantDefinition nVariant = this.getVariant(variant.getName(), branch);
                results = this.copyFromVariant(branch, ArtifactId.valueOf((Id)nVariant), variant.copyFrom, account);
            }
        }
        return results;
    }

    private ArtifactToken createUpdateVariantDefinition(VariantDefinition variant, TransactionBuilder tx) {
        ArtifactToken vDefArt = null;
        if (variant.getId() != null && variant.getId() > 0L) {
            vDefArt = (ArtifactToken)this.orcsApi.getQueryFactory().fromBranch(tx.getBranch()).andId(ArtifactId.valueOf((Long)variant.getId())).getResults().getAtMostOneOrNull();
        }
        if (vDefArt == null) {
            Long artId = variant.getId();
            if (artId == null || artId <= 0L) {
                artId = Lib.generateArtifactIdAsInt();
            }
            vDefArt = tx.createArtifact(this.getVariantsFolder(tx.getBranch()), CoreArtifactTypes.BranchView, variant.getName(), artId);
        }
        tx.setName(vDefArt, variant.getName());
        return this.orcsApi.getQueryFactory().fromBranch(vDefArt.getBranch()).andId(vDefArt).getArtifactOrSentinal();
    }

    public XResultData deleteVariant(String variant, BranchId branch, UserId account) {
        XResultData results = new XResultData();
        try {
            ArtifactToken variantArt;
            UserId user = account;
            if (user == null) {
                user = SystemUser.OseeSystem;
            }
            if ((variantArt = (ArtifactToken)this.getVariant(variant, branch).getData()).isValid()) {
                TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Delete Variant " + variantArt.toStringWithId());
                tx.deleteArtifact((ArtifactId)variantArt);
                tx.commit();
            }
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    public XResultData setApplicability(BranchId branch, ArtifactId variant, ArtifactId feature, String applicability, UserId account) {
        XResultData results = new XResultData();
        try {
            UserId user = account;
            if (user == null) {
                user = SystemUser.OseeSystem;
            }
            ArtifactToken featureArt = this.orcsApi.getQueryFactory().fromBranch(branch).andId(feature).getArtifactOrNull();
            FeatureDefinition fDef = this.orcsApi.getApplicabilityOps().getFeatureDefinition(featureArt);
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Set Variant Feature Applicability");
            LinkedList<String> existingValues = new LinkedList<String>();
            for (String appl : this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, branch, (Object)variant)) {
                if (!appl.startsWith(String.valueOf(fDef.getName()) + " = ")) continue;
                existingValues.add(appl);
            }
            LinkedList<String> newValues = new LinkedList<String>();
            String[] stringArray = applicability.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                value = value.replace("^ +", "");
                value = value.replace(" +$", "");
                value = String.valueOf(featureArt.getName()) + " = " + value;
                newValues.add(value);
                ++n2;
            }
            boolean change = false;
            if (!((Object)existingValues).toString().equals("[]")) {
                for (String existingValue : existingValues) {
                    if (newValues.contains(existingValue)) continue;
                    change = true;
                    tx.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)variant, (Object)existingValue);
                }
                for (String newValue : newValues) {
                    if (existingValues.contains(newValue)) continue;
                    change = true;
                    tx.addTuple2(CoreTupleTypes.ViewApplicability, (Object)variant, (Object)newValue);
                }
            } else {
                for (String newValue : newValues) {
                    change = true;
                    tx.addTuple2(CoreTupleTypes.ViewApplicability, (Object)variant, (Object)newValue);
                }
            }
            if (change) {
                tx.commit();
            }
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    public XResultData copyFromVariant(BranchId branch, ArtifactId variant, ArtifactId copy_from, UserId account) {
        XResultData results = new XResultData();
        try {
            UserId user = account;
            if (user == null) {
                user = SystemUser.OseeSystem;
            }
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Set Variant Feature Applicability");
            LinkedList<String> existingValues = new LinkedList<String>();
            for (String appl : this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, tx.getBranch(), (Object)variant)) {
                if (appl.startsWith("Config") || appl.startsWith("Base")) continue;
                existingValues.add(appl);
            }
            LinkedList<String> newValues = new LinkedList<String>();
            for (String appl : this.orcsApi.getQueryFactory().tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, tx.getBranch(), (Object)copy_from)) {
                if (appl.startsWith("Config") || appl.startsWith("Base")) continue;
                newValues.add(appl);
            }
            boolean change = false;
            if (!((Object)existingValues).toString().equals("[]")) {
                for (String existingValue : existingValues) {
                    if (newValues.contains(existingValue)) continue;
                    change = true;
                    tx.deleteTuple2(CoreTupleTypes.ViewApplicability, (Object)variant, (Object)existingValue);
                }
                for (String newValue : newValues) {
                    if (existingValues.contains(newValue)) continue;
                    change = true;
                    tx.addTuple2(CoreTupleTypes.ViewApplicability, (Object)variant, (Object)newValue);
                }
            } else {
                for (String newValue : newValues) {
                    change = true;
                    tx.addTuple2(CoreTupleTypes.ViewApplicability, (Object)variant, (Object)newValue);
                }
            }
            if (change) {
                tx.commit();
            }
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }
}

